/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.csv.dataio.writer;

import com.bc.ceres.core.ProgressMonitor;
import java.io.FileWriter;
import java.io.IOException;
import org.esa.beam.csv.dataio.writer.CsvProductWriter;
import org.esa.beam.csv.dataio.writer.CsvWriter;
import org.esa.beam.csv.dataio.writer.FeatureCsvWriter;
import org.esa.beam.csv.dataio.writer.OutputFormat;
import org.esa.beam.csv.dataio.writer.OutputFormatStrategy;
import org.esa.beam.csv.dataio.writer.PixelCsvWriter;
import org.esa.beam.csv.dataio.writer.SourceType;
import org.esa.beam.csv.dataio.writer.TargetType;
import org.esa.beam.csv.dataio.writer.WriteStrategy;
import org.esa.beam.framework.datamodel.Product;

public class CsvWriterBuilder {
    private SourceType sourceType;
    private TargetType targetType;
    private OutputFormat targetFormat;
    private String targetFile;

    CsvWriterBuilder sourceType(SourceType sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    CsvWriterBuilder targetType(TargetType targetType) {
        this.targetType = targetType;
        return this;
    }

    CsvWriterBuilder targetFormat(OutputFormat targetFormat) {
        this.targetFormat = targetFormat;
        return this;
    }

    CsvWriterBuilder targetFile(String targetFile) {
        this.targetFile = targetFile;
        return this;
    }

    CsvWriter build() {
        WriteStrategy writer;
        OutputFormatStrategy outputFormat;
        this.validateState();
        switch (this.targetFormat) {
            case ODESA: {
                outputFormat = new OdesaOutputFormat();
                break;
            }
            default: {
                outputFormat = new BeamOutputFormat();
            }
        }
        switch (this.targetType) {
            case CLIPBOARD: {
                writer = new ClipboardWriter();
                break;
            }
            default: {
                writer = new CsvFileWriter(this.targetFile);
            }
        }
        switch (this.sourceType) {
            case PRODUCT: {
                return new ProductCsvWriter(this.targetFile);
            }
            case PIXEL: {
                return new PixelCsvWriter(writer, outputFormat);
            }
            case FEATURE: {
                return new FeatureCsvWriter(writer, outputFormat);
            }
        }
        throw new IllegalStateException("Illegal source type: '" + (Object)((Object)this.sourceType) + "'.");
    }

    private void validateState() {
        if (this.sourceType == null) {
            throw new IllegalStateException("Unable to create CSV writer due to missing source type.");
        }
        if (this.targetType.equals((Object)TargetType.CLIPBOARD) && this.targetFile != null) {
            throw new IllegalStateException("Unable to create CSV writer since both clipboard and target file are specified.");
        }
        if (this.targetType.equals((Object)TargetType.FILE) && this.targetFile == null) {
            throw new IllegalStateException("No target file specified while target type is '" + (Object)((Object)TargetType.FILE) + "'.");
        }
    }

    static class OdesaOutputFormat
    implements OutputFormatStrategy {
        OdesaOutputFormat() {
        }

        @Override
        public String formatProperty(String key, String value) {
            return key + "=" + value;
        }

        @Override
        public String formatHeader(String[] attributes, Class[] types) {
            StringBuilder builder = new StringBuilder();
            builder.append("feature_id");
            return builder.toString();
        }

        @Override
        public String formatRecord(String recordId, String[] values) {
            return "";
        }
    }

    static class BeamOutputFormat
    implements OutputFormatStrategy {
        private static final String separator = "\t";

        BeamOutputFormat() {
        }

        @Override
        public String formatProperty(String key, String value) {
            return key + "=" + value;
        }

        @Override
        public String formatHeader(String[] attributes, Class[] types) {
            StringBuilder builder = new StringBuilder();
            builder.append("featureId");
            for (int i = 0; i < attributes.length; ++i) {
                builder.append(separator);
                builder.append(attributes[i]);
                builder.append(":");
                builder.append(types[i].getSimpleName().toLowerCase());
            }
            return builder.toString();
        }

        @Override
        public String formatRecord(String recordId, String[] values) {
            StringBuilder builder = new StringBuilder();
            builder.append(recordId);
            for (String value : values) {
                builder.append(separator);
                builder.append(value);
            }
            return builder.toString();
        }
    }

    class ProductCsvWriter
    implements CsvWriter {
        private String targetFile;

        ProductCsvWriter(String targetFile) {
            this.targetFile = targetFile;
        }

        @Override
        public void writeCsv(Object ... input) throws IOException {
            this.validateInput(input);
            Product sourceProduct = (Product)input[0];
            int config = 3;
            CsvProductWriter productWriter = new CsvProductWriter(null, 3, null);
            productWriter.writeProductNodes(sourceProduct, this.targetFile);
            productWriter.writeBandRasterData(null, -1, -1, -1, -1, null, ProgressMonitor.NULL);
        }

        @Override
        public boolean isValidInput(Object ... input) {
            return input != null && input.length == 1 && input[0] instanceof Product;
        }

        private void validateInput(Object[] input) {
            if (this.isValidInput(input)) {
                StringBuilder message = new StringBuilder("Illegal input for writing a product as CSV file: '");
                for (int i = 0; i < input.length; ++i) {
                    Object o = input[i];
                    message.append(o.toString());
                    if (i != input.length - 1) continue;
                    message.append(", ");
                }
                message.append("'");
                throw new IllegalArgumentException(message.toString());
            }
        }
    }

    private static class CsvFileWriter
    implements WriteStrategy {
        private final String targetFile;

        private CsvFileWriter(String targetFile) {
            this.targetFile = targetFile;
        }

        @Override
        public void writeCsv(String fullOutput) throws IOException {
            new FileWriter(this.targetFile);
        }
    }

    private static class ClipboardWriter
    implements WriteStrategy {
        private ClipboardWriter() {
        }

        @Override
        public void writeCsv(String fullOutput) {
        }
    }
}

