/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.csv.dataio.reader;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;
import org.esa.beam.csv.dataio.CsvFile;
import org.esa.beam.csv.dataio.CsvSource;
import org.esa.beam.csv.dataio.CsvSourceParser;
import org.esa.beam.framework.dataio.AbstractProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.util.StringUtils;
import org.esa.beam.util.logging.BeamLogManager;
import org.opengis.feature.type.AttributeDescriptor;

public class CsvProductReader
extends AbstractProductReader {
    private static final String PROPERTY_NAME_SCENE_RASTER_WIDTH = "sceneRasterWidth";
    private CsvSourceParser parser;

    protected CsvProductReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    public void close() throws IOException {
        super.close();
        if (this.parser != null) {
            this.parser.close();
        }
    }

    protected Product readProductNodesImpl() throws IOException {
        int sceneRasterHeight;
        int sceneRasterWidth;
        this.parser = CsvFile.createCsvSourceParser(this.getInput().toString());
        CsvSource source = this.parser.parseMetadata();
        String sceneRasterWidthProperty = source.getProperties().get(PROPERTY_NAME_SCENE_RASTER_WIDTH);
        int recordCount = source.getRecordCount();
        if (sceneRasterWidthProperty != null) {
            sceneRasterWidth = Integer.parseInt(sceneRasterWidthProperty);
            sceneRasterHeight = recordCount % sceneRasterWidth == 0 ? recordCount / sceneRasterWidth : recordCount / sceneRasterWidth + 1;
        } else {
            sceneRasterWidth = CsvProductReader.isSquareNumber(recordCount) ? (int)Math.sqrt(recordCount) : (int)Math.sqrt(recordCount) + 1;
            sceneRasterHeight = sceneRasterWidth;
        }
        String productName = StringUtils.createValidName((String)this.getInput().toString(), null, (char)'_');
        Product product = new Product(productName, "CSV", sceneRasterWidth, sceneRasterHeight);
        product.setPreferredTileSize(sceneRasterWidth, sceneRasterHeight);
        for (AttributeDescriptor descriptor : source.getFeatureType().getAttributeDescriptors()) {
            if (!this.isAccessibleBandType(descriptor.getType().getBinding())) continue;
            int type = this.getProductDataType(descriptor.getType().getBinding());
            product.addBand(descriptor.getName().toString(), type);
        }
        return product;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        Object[] values;
        BeamLogManager.getSystemLogger().log(Level.FINEST, MessageFormat.format("reading band data (" + destBand.getName() + ") from {0} to {1}", destOffsetY * destWidth, sourceOffsetY * destWidth + destWidth * destHeight));
        pm.beginTask("reading band data...", destWidth * destHeight);
        CsvSourceParser csvSourceParser = this.parser;
        synchronized (csvSourceParser) {
            values = this.parser.parseRecords(destOffsetY * destWidth, destWidth * destHeight, destBand.getName());
        }
        this.getProductData(values, destBuffer);
        pm.done();
    }

    void getProductData(Object[] elems, ProductData destBuffer) {
        switch (destBuffer.getType()) {
            case 30: {
                for (int i = 0; i < destBuffer.getNumElems(); ++i) {
                    Object elem = i < elems.length ? (elems[i] != null ? elems[i] : Float.valueOf(Float.NaN)) : Float.valueOf(Float.NaN);
                    destBuffer.setElemFloatAt(i, ((Float)elem).floatValue());
                }
                break;
            }
            case 31: {
                for (int i = 0; i < destBuffer.getNumElems(); ++i) {
                    Object elem = i < elems.length ? (elems[i] != null ? elems[i] : Double.valueOf(Double.NaN)) : Double.valueOf(Double.NaN);
                    destBuffer.setElemDoubleAt(i, ((Double)elem).doubleValue());
                }
                break;
            }
            case 10: {
                for (int i = 0; i < elems.length; ++i) {
                    Object elem = elems[i] != null ? elems[i] : Integer.valueOf(0);
                    destBuffer.setElemIntAt(i, (int)((Byte)elem).byteValue());
                }
                break;
            }
            case 11: {
                for (int i = 0; i < elems.length; ++i) {
                    Object elem = elems[i] != null ? elems[i] : Integer.valueOf(0);
                    destBuffer.setElemIntAt(i, (int)((Short)elem).shortValue());
                }
                break;
            }
            case 12: {
                for (int i = 0; i < elems.length; ++i) {
                    Object elem = elems[i] != null ? elems[i] : Integer.valueOf(0);
                    destBuffer.setElemIntAt(i, ((Integer)elem).intValue());
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type '" + ProductData.getTypeString((int)destBuffer.getType()) + "'.");
            }
        }
    }

    int getProductDataType(Class<?> type) {
        if (type.getSimpleName().toLowerCase().equals("string")) {
            return 41;
        }
        if (type.getSimpleName().toLowerCase().equals("float")) {
            return 30;
        }
        if (type.getSimpleName().toLowerCase().equals("double")) {
            return 31;
        }
        if (type.getSimpleName().toLowerCase().equals("byte")) {
            return 10;
        }
        if (type.getSimpleName().toLowerCase().equals("short")) {
            return 11;
        }
        if (type.getSimpleName().toLowerCase().equals("integer")) {
            return 12;
        }
        if (type.getSimpleName().toLowerCase().equals("utc")) {
            return 51;
        }
        throw new IllegalArgumentException("Unsupported type '" + type + "'.");
    }

    static boolean isSquareNumber(int number) {
        int temp = (int)Math.sqrt(number);
        return temp * temp == number;
    }

    private boolean isAccessibleBandType(Class<?> type) {
        String className = type.getSimpleName().toLowerCase();
        return className.equals("float") || className.equals("double") || className.equals("byte") || className.equals("short") || className.equals("integer");
    }
}

