/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.cluster;

import java.util.Arrays;
import java.util.Comparator;
import org.esa.snap.cluster.KMeansCluster;
import org.esa.snap.cluster.KMeansClusterSet;
import org.esa.snap.cluster.PixelIter;
import org.esa.snap.cluster.RandomSceneIter;

class KMeansClusterer {
    private final int dimensionCount;
    private final int clusterCount;
    private final double[][] means;
    private final int[] memberCounts;
    private double[][] sums;

    KMeansClusterer(int clusterCount, int dimensionCount) {
        this.clusterCount = clusterCount;
        this.dimensionCount = dimensionCount;
        this.memberCounts = new int[clusterCount];
        this.means = new double[clusterCount][dimensionCount];
    }

    void initialize(RandomSceneIter sceneIter) {
        for (int c = 0; c < this.clusterCount; ++c) {
            boolean accepted = true;
            block1: do {
                this.means[c] = sceneIter.getNextValue();
                for (int i = 0; i < c; ++i) {
                    boolean bl = accepted = !Arrays.equals(this.means[c], this.means[i]);
                    if (!accepted) continue block1;
                }
            } while (!accepted);
        }
    }

    void startIteration() {
        this.sums = new double[this.clusterCount][this.dimensionCount];
        Arrays.fill(this.memberCounts, 0);
    }

    void iterateTile(PixelIter iter) {
        double[] point = new double[this.dimensionCount];
        while (iter.next(point) != null) {
            int closestCluster = KMeansClusterer.getClosestCluster(this.means, point);
            double[] sumsOfClosestCluster = this.sums[closestCluster];
            for (int d = 0; d < this.dimensionCount; ++d) {
                int n = d;
                sumsOfClosestCluster[n] = sumsOfClosestCluster[n] + point[d];
            }
            int n = closestCluster;
            this.memberCounts[n] = this.memberCounts[n] + 1;
        }
    }

    boolean endIteration() {
        double diff = 0.0;
        for (int c = 0; c < this.clusterCount; ++c) {
            double[] sumsOfC = this.sums[c];
            double[] meansOfC = this.means[c];
            for (int d = 0; d < this.dimensionCount; ++d) {
                if (this.memberCounts[c] <= 0) continue;
                double newMean = sumsOfC[d] / (double)this.memberCounts[c];
                diff += (newMean - meansOfC[d]) * (newMean - meansOfC[d]);
                meansOfC[d] = newMean;
            }
        }
        return diff == 0.0;
    }

    KMeansClusterSet getClusters() {
        KMeansCluster[] clusters = new KMeansCluster[this.clusterCount];
        for (int c = 0; c < this.clusterCount; ++c) {
            clusters[c] = new KMeansCluster(this.means[c], this.memberCounts[c]);
        }
        Arrays.sort(clusters, new ClusterComparator());
        return new KMeansClusterSet(clusters);
    }

    static int getClosestCluster(double[][] mean, double[] point) {
        double minDistance = Double.MAX_VALUE;
        int closestCluster = 0;
        for (int c = 0; c < mean.length; ++c) {
            double distance = KMeansClusterer.squaredDistance(mean[c], point);
            if (!(distance < minDistance)) continue;
            closestCluster = c;
            minDistance = distance;
        }
        return closestCluster;
    }

    private static double squaredDistance(double[] x, double[] y) {
        double distance = 0.0;
        for (int d = 0; d < x.length; ++d) {
            double difference = y[d] - x[d];
            distance += difference * difference;
        }
        return distance;
    }

    private static class ClusterComparator
    implements Comparator<KMeansCluster> {
        private ClusterComparator() {
        }

        @Override
        public int compare(KMeansCluster c1, KMeansCluster c2) {
            return Double.compare(c2.getMemberCount(), c1.getMemberCount());
        }
    }
}

