/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.cluster;

import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.media.jai.PlanarImage;
import javax.media.jai.operator.MinDescriptor;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Mask;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.util.StringUtils;

class Roi {
    private final Set<RenderedImage> maskImageSet = new HashSet<RenderedImage>();
    private final RenderedImage combinedMaskImage;

    Roi(Product sourceProduct, Band[] sourceBands, String roiMaskName) {
        this.handleRoiMask(sourceProduct, roiMaskName);
        this.handleValidMasks(sourceBands);
        this.combinedMaskImage = this.maskImageSet.size() > 0 ? this.createCombinedMaskImage() : null;
    }

    Roi(Product sourceProduct, Band[] sourceBands, Mask roiMask) {
        this.handleRoiMask(sourceProduct, roiMask);
        this.handleValidMasks(sourceBands);
        this.combinedMaskImage = this.maskImageSet.size() > 0 ? this.createCombinedMaskImage() : null;
    }

    boolean contains(int x, int y) {
        int tileY;
        if (this.combinedMaskImage == null) {
            return true;
        }
        int tileW = this.combinedMaskImage.getTileWidth();
        int tileH = this.combinedMaskImage.getTileHeight();
        int tileX = PlanarImage.XToTileX((int)x, (int)this.combinedMaskImage.getTileGridXOffset(), (int)tileW);
        Raster tile = this.combinedMaskImage.getTile(tileX, tileY = PlanarImage.YToTileY((int)y, (int)this.combinedMaskImage.getTileGridYOffset(), (int)tileH));
        return tile.getSample(x, y, 0) != 0;
    }

    private void handleRoiMask(Product product, String roiMaskName) {
        Mask mask;
        if (StringUtils.isNotNullAndNotEmpty((String)roiMaskName) && (mask = (Mask)product.getMaskGroup().get(roiMaskName)) != null) {
            this.maskImageSet.add((RenderedImage)mask.getSourceImage());
        }
    }

    private void handleRoiMask(Product product, Mask mask) {
        if (mask != null) {
            this.maskImageSet.add((RenderedImage)mask.getSourceImage());
        }
    }

    private void handleValidMasks(Band[] sourceBands) {
        for (Band band : sourceBands) {
            if (!StringUtils.isNotNullAndNotEmpty((String)band.getValidMaskExpression())) continue;
            this.maskImageSet.add((RenderedImage)band.getValidMaskImage());
        }
    }

    private RenderedImage createCombinedMaskImage() {
        ArrayList<RenderedImage> imageList = new ArrayList<RenderedImage>(this.maskImageSet);
        RenderedImage combinedImage = (RenderedImage)imageList.get(0);
        for (int i = 1; i < imageList.size(); ++i) {
            combinedImage = MinDescriptor.create((RenderedImage)combinedImage, (RenderedImage)((RenderedImage)imageList.get(i)), null);
        }
        return combinedImage;
    }
}

