/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.cluster;

import java.awt.Rectangle;
import java.util.Random;
import org.esa.beam.cluster.Roi;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.Tile;

class RandomSceneIter {
    private final Operator operator;
    private final Random random;
    private final RasterDataNode[] rdn;
    private final int[] xValue;
    private final int[] yValue;
    private final int roiMemberCount;

    RandomSceneIter(Operator operator, RasterDataNode[] rdn, Roi roi, int seed) {
        this.operator = operator;
        this.rdn = rdn;
        this.random = new Random(seed);
        int rasterWidth = rdn[0].getSceneRasterWidth();
        int rasterHeight = rdn[0].getSceneRasterHeight();
        int size = rasterWidth * rasterHeight;
        if (roi == null) {
            this.xValue = null;
            this.yValue = null;
            this.roiMemberCount = size;
        } else {
            this.xValue = new int[size];
            this.yValue = new int[size];
            int i = 0;
            for (int y = 0; y < rasterHeight; ++y) {
                for (int x = 0; x < rasterWidth; ++x) {
                    if (!roi.contains(x, y)) continue;
                    this.xValue[i] = x;
                    this.yValue[i] = y;
                    ++i;
                }
            }
            this.roiMemberCount = i;
        }
    }

    int getRoiMemberCount() {
        return this.roiMemberCount;
    }

    double[] getNextValue() {
        int y;
        int x;
        double[] value = new double[this.rdn.length];
        if (this.xValue == null) {
            x = this.random.nextInt(this.rdn[0].getSceneRasterWidth());
            y = this.random.nextInt(this.rdn[0].getSceneRasterHeight());
        } else {
            int randomIndex = this.random.nextInt(this.roiMemberCount);
            x = this.xValue[randomIndex];
            y = this.yValue[randomIndex];
        }
        Rectangle rectangle = new Rectangle(x, y, 1, 1);
        for (int i = 0; i < this.rdn.length; ++i) {
            Tile sourceTile = this.operator.getSourceTile(this.rdn[i], rectangle);
            value[i] = sourceTile.getSampleDouble(x, y);
        }
        return value;
    }
}

