/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.cluster;

import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.factory.SingularValueDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.ops.NormOps;
import org.ejml.ops.SingularOps;

public class PrincipleComponentAnalysis {
    private final int sampleSize;
    private DenseMatrix64F V_t;
    private int numComponents = -1;
    double[] mean;

    public PrincipleComponentAnalysis(int sampleSize) {
        this.sampleSize = sampleSize;
    }

    public void computeBasis(double[] samples, int numComponents) {
        int j;
        int i;
        if (numComponents > this.sampleSize) {
            throw new IllegalArgumentException("More components requested that the data's length.");
        }
        int sampleCount = samples.length / this.sampleSize;
        if (numComponents > sampleCount) {
            throw new IllegalArgumentException("More data needed to compute the desired number of components");
        }
        this.mean = new double[this.sampleSize];
        this.numComponents = numComponents;
        DenseMatrix64F A = DenseMatrix64F.wrap((int)sampleCount, (int)this.sampleSize, (double[])samples);
        for (i = 0; i < sampleCount; ++i) {
            for (j = 0; j < this.sampleSize; ++j) {
                int n = j;
                this.mean[n] = this.mean[n] + A.get(i, j);
            }
        }
        int j2 = 0;
        while (j2 < this.mean.length) {
            int n = j2++;
            this.mean[n] = this.mean[n] / (double)sampleCount;
        }
        for (i = 0; i < sampleCount; ++i) {
            for (j = 0; j < this.sampleSize; ++j) {
                A.set(i, j, A.get(i, j) - this.mean[j]);
            }
        }
        SingularValueDecomposition svd = DecompositionFactory.svd((int)A.numRows, (int)A.numCols, (boolean)false, (boolean)true, (boolean)false);
        if (!svd.decompose((Matrix64F)A)) {
            throw new RuntimeException("SVD failed");
        }
        this.V_t = (DenseMatrix64F)svd.getV(null, true);
        DenseMatrix64F W = (DenseMatrix64F)svd.getW(null);
        SingularOps.descendingOrder(null, (boolean)false, (DenseMatrix64F)W, (DenseMatrix64F)this.V_t, (boolean)true);
        this.V_t.reshape(numComponents, this.mean.length, true);
    }

    public double[] getMeanVector() {
        return (double[])this.mean.clone();
    }

    public double[] getBasisVector(int which) {
        if (which < 0 || which >= this.numComponents) {
            throw new IllegalArgumentException("Invalid component");
        }
        DenseMatrix64F v = new DenseMatrix64F(1, this.sampleSize);
        CommonOps.extract((Matrix64F)this.V_t, (int)which, (int)(which + 1), (int)0, (int)this.sampleSize, (Matrix64F)v, (int)0, (int)0);
        return v.data;
    }

    public double[] sampleToEigenSpace(double[] sampleData) {
        if (sampleData.length != this.sampleSize) {
            throw new IllegalArgumentException("Unexpected sample length");
        }
        DenseMatrix64F mean = DenseMatrix64F.wrap((int)this.sampleSize, (int)1, (double[])this.mean);
        DenseMatrix64F s = new DenseMatrix64F(this.sampleSize, 1, true, sampleData);
        DenseMatrix64F r = new DenseMatrix64F(this.numComponents, 1);
        CommonOps.sub((D1Matrix64F)s, (D1Matrix64F)mean, (D1Matrix64F)s);
        CommonOps.mult((RowD1Matrix64F)this.V_t, (RowD1Matrix64F)s, (RowD1Matrix64F)r);
        return r.data;
    }

    public double[] eigenToSampleSpace(double[] eigenData) {
        if (eigenData.length != this.numComponents) {
            throw new IllegalArgumentException("Unexpected sample length");
        }
        DenseMatrix64F s = new DenseMatrix64F(this.sampleSize, 1);
        DenseMatrix64F r = DenseMatrix64F.wrap((int)this.numComponents, (int)1, (double[])eigenData);
        CommonOps.multTransA((RowD1Matrix64F)this.V_t, (RowD1Matrix64F)r, (RowD1Matrix64F)s);
        DenseMatrix64F mean = DenseMatrix64F.wrap((int)this.sampleSize, (int)1, (double[])this.mean);
        CommonOps.add((D1Matrix64F)s, (D1Matrix64F)mean, (D1Matrix64F)s);
        return s.data;
    }

    public double errorMembership(double[] sampleA) {
        double[] eig = this.sampleToEigenSpace(sampleA);
        double[] reproj = this.eigenToSampleSpace(eig);
        double total = 0.0;
        for (int i = 0; i < reproj.length; ++i) {
            double d = sampleA[i] - reproj[i];
            total += d * d;
        }
        return Math.sqrt(total);
    }

    public double response(double[] sample) {
        if (sample.length != this.sampleSize) {
            throw new IllegalArgumentException("Expected input vector to be in sample space");
        }
        DenseMatrix64F dots = new DenseMatrix64F(this.numComponents, 1);
        DenseMatrix64F s = DenseMatrix64F.wrap((int)this.sampleSize, (int)1, (double[])sample);
        CommonOps.mult((RowD1Matrix64F)this.V_t, (RowD1Matrix64F)s, (RowD1Matrix64F)dots);
        return NormOps.normF((D1Matrix64F)dots);
    }
}

