/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.cluster;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import org.esa.beam.cluster.Distribution;

class MultinormalDistribution
implements Distribution {
    private final double[] mean;
    private final double logNormFactor;
    private double[] eigenvalues;
    private double[][] v;

    MultinormalDistribution(double[] mean, double[][] covariances) {
        this.mean = (double[])mean.clone();
        Eigendecomposition decomposition = new Eigendecomposition(covariances.length, covariances);
        this.eigenvalues = decomposition.getEigenvalues();
        this.v = decomposition.getV();
        double det = this.eigenvalues[0];
        for (int i = 1; i < this.eigenvalues.length; ++i) {
            det *= this.eigenvalues[i];
        }
        double logDet = Math.log(det);
        if (Double.isNaN(logDet) || Double.isInfinite(logDet)) {
            throw new ArithmeticException("Matrix is numerically singular.");
        }
        this.logNormFactor = -0.5 * ((double)mean.length * Math.log(Math.PI * 2) + logDet);
    }

    @Override
    public final double probabilityDensity(double[] y) {
        return Math.exp(this.logProbabilityDensity(y));
    }

    @Override
    public final double logProbabilityDensity(double[] y) {
        if (y.length != this.mean.length) {
            throw new IllegalArgumentException("y.length != mean.length");
        }
        return this.logNormFactor - 0.5 * this.mahalanobisSquaredDistance(y);
    }

    private double mahalanobisSquaredDistance(double[] y) {
        double u = 0.0;
        for (int i = 0; i < this.mean.length; ++i) {
            double d = 0.0;
            for (int j = 0; j < this.mean.length; ++j) {
                d += this.v[i][j] * (y[j] - this.mean[j]);
            }
            u += d * d / this.eigenvalues[i];
        }
        return u;
    }

    private static class Eigendecomposition {
        private double[] eigenvalues;
        private double[][] v;

        private Eigendecomposition(int n, double[][] matrix) {
            SingularValueDecomposition svd = new Matrix(matrix, n, n).svd();
            this.eigenvalues = svd.getSingularValues();
            this.v = svd.getV().getArrayCopy();
        }

        public final double[] getEigenvalues() {
            return this.eigenvalues;
        }

        public final double[][] getV() {
            return this.v;
        }
    }
}

