/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.cluster;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import org.esa.beam.cluster.Distribution;
import org.esa.beam.cluster.EMCluster;
import org.esa.beam.cluster.MultinormalDistribution;
import org.esa.beam.cluster.ProbabilityCalculator;

class EMClusterer {
    private final int pointCount;
    private final int dimensionCount;
    private final int clusterCount;
    private final double[][] points;
    private final double[] priors;
    private final double[][] means;
    private final double[][][] covariances;
    private final Distribution[] distributions;
    private final ProbabilityCalculator calculator;

    static ProbabilityCalculator createProbabilityCalculator(EMCluster[] clusters) {
        Distribution[] distributions = new Distribution[clusters.length];
        double[] priors = new double[clusters.length];
        for (int i = 0; i < clusters.length; ++i) {
            distributions[i] = new MultinormalDistribution(clusters[i].getMean(), clusters[i].getCovariances());
            priors[i] = clusters[i].getPriorProbability();
        }
        return new ProbabilityCalculator(distributions, priors);
    }

    static EMCluster[] findClusters(double[][] points, int clusterCount, int iterationCount, int randomSeed) {
        return new EMClusterer(points, clusterCount, randomSeed).findClusters(iterationCount);
    }

    EMClusterer(double[][] points, int clusterCount, int randomSeed) {
        this.pointCount = points.length;
        this.dimensionCount = points[0].length;
        this.points = points;
        this.clusterCount = clusterCount;
        this.priors = new double[clusterCount];
        this.means = new double[clusterCount][this.dimensionCount];
        this.covariances = new double[clusterCount][this.dimensionCount][this.dimensionCount];
        this.distributions = new MultinormalDistribution[clusterCount];
        this.calculator = new ProbabilityCalculator(this.distributions, this.priors);
        this.initialize(new Random(randomSeed));
    }

    private EMCluster[] findClusters(int iterationCount) {
        while (iterationCount > 0) {
            this.iterate();
            --iterationCount;
        }
        return this.getClusters();
    }

    EMCluster[] getClusters() {
        return this.getClusters(new PriorProbabilityClusterComparator());
    }

    EMCluster[] getClusters(Comparator<EMCluster> clusterComparator) {
        EMCluster[] clusters = new EMCluster[this.clusterCount];
        for (int k = 0; k < this.clusterCount; ++k) {
            clusters[k] = new EMCluster(this.means[k], this.covariances[k], this.priors[k]);
        }
        Arrays.sort(clusters, clusterComparator);
        return clusters;
    }

    private void initialize(Random random) {
        int k;
        for (k = 0; k < this.clusterCount; ++k) {
            System.arraycopy(this.points[random.nextInt(this.pointCount)], 0, this.means[k], 0, this.dimensionCount);
        }
        for (k = 0; k < this.clusterCount; ++k) {
            this.priors[k] = 1.0;
            for (int l = 0; l < this.dimensionCount; ++l) {
                this.covariances[k][l][l] = 1.0;
            }
            this.distributions[k] = new MultinormalDistribution(this.means[k], this.covariances[k]);
        }
    }

    void iterate() {
        double[] sums = new double[this.clusterCount];
        double[] posteriors = new double[this.clusterCount];
        for (int i = 0; i < this.pointCount; ++i) {
            int k;
            this.calculator.calculate(this.points[i], posteriors);
            double sum = 0.0;
            for (k = 0; k < this.clusterCount; ++k) {
                int n = k;
                posteriors[n] = posteriors[n] + 1.0E-4;
                sum += posteriors[k];
            }
            k = 0;
            while (k < this.clusterCount) {
                int n = k++;
                posteriors[n] = posteriors[n] / sum;
            }
            if (i == 0) {
                for (k = 0; k < this.clusterCount; ++k) {
                    for (int l = 0; l < this.dimensionCount; ++l) {
                        this.means[k][l] = this.points[0][l];
                        for (int m = l; m < this.dimensionCount; ++m) {
                            this.covariances[k][l][m] = 0.0;
                        }
                    }
                    sums[k] = posteriors[k];
                }
                continue;
            }
            for (k = 0; k < this.clusterCount; ++k) {
                double temp = posteriors[k] + sums[k];
                for (int l = 0; l < this.dimensionCount; ++l) {
                    for (int m = l; m < this.dimensionCount; ++m) {
                        double[] dArray = this.covariances[k][l];
                        int n = m;
                        dArray[n] = dArray[n] + sums[k] * posteriors[k] * (this.points[i][l] - this.means[k][l]) * (this.points[i][m] - this.means[k][m]) / temp;
                    }
                    double[] dArray = this.means[k];
                    int n = l;
                    dArray[n] = dArray[n] + posteriors[k] * (this.points[i][l] - this.means[k][l]) / temp;
                }
                sums[k] = temp;
            }
        }
        for (int k = 0; k < this.clusterCount; ++k) {
            for (int l = 0; l < this.dimensionCount; ++l) {
                for (int m = l; m < this.dimensionCount; ++m) {
                    double[] dArray = this.covariances[k][l];
                    int n = m;
                    dArray[n] = dArray[n] / sums[k];
                    this.covariances[k][m][l] = this.covariances[k][l][m];
                }
            }
            this.priors[k] = sums[k] / (double)this.pointCount;
            this.distributions[k] = new MultinormalDistribution(this.means[k], this.covariances[k]);
        }
    }

    private static class PriorProbabilityClusterComparator
    implements Comparator<EMCluster> {
        private PriorProbabilityClusterComparator() {
        }

        @Override
        public int compare(EMCluster c1, EMCluster c2) {
            return Double.compare(c2.getPriorProbability(), c1.getPriorProbability());
        }
    }
}

