/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.cluster;

import java.text.NumberFormat;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.IndexCoding;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.ProductData;

class ClusterMetaDataUtils {
    ClusterMetaDataUtils() {
    }

    public static void addCenterToIndexCoding(IndexCoding indexCoding, Band[] sourceBands, double[][] means) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(3);
        int numAttributes = indexCoding.getNumAttributes();
        for (int i = 0; i < numAttributes; ++i) {
            MetadataAttribute attribute = indexCoding.getAttributeAt(i);
            String description = "Cluster " + i + ", Center(";
            for (int j = 0; j < sourceBands.length; ++j) {
                String number = numberFormat.format(means[i][j]);
                description = description + sourceBands[j].getName() + "=" + number;
                if (j == sourceBands.length - 1) continue;
                description = description + ", ";
            }
            description = description + ")";
            attribute.setDescription(description);
        }
    }

    public static void addCenterToMetadata(MetadataElement clusterAnalysis, Band[] sourceBands, double[][] means) {
        for (int i = 0; i < means.length; ++i) {
            MetadataElement element = new MetadataElement("class." + i);
            for (int j = 0; j < sourceBands.length; ++j) {
                ProductData pData = ProductData.createInstance((double[])new double[]{means[i][j]});
                MetadataAttribute metadataAttribute = new MetadataAttribute("cluster_center." + sourceBands[j].getName(), pData, true);
                element.addAttribute(metadataAttribute);
            }
            clusterAnalysis.addElement(element);
        }
    }

    public static void addEMInfoToMetadata(MetadataElement clusterAnalysis, double[][][] covariances, double[] priorProbabilities) {
        int numElements = clusterAnalysis.getNumElements();
        for (int i = 0; i < numElements; ++i) {
            MetadataElement element = clusterAnalysis.getElementAt(i);
            double[][] covariance = covariances[i];
            for (int k = 0; k < covariance.length; ++k) {
                ProductData cData = ProductData.createInstance((double[])covariance[k]);
                MetadataAttribute cAttribute = new MetadataAttribute("covariance." + k, cData, true);
                element.addAttribute(cAttribute);
            }
            ProductData pData = ProductData.createInstance((double[])new double[]{priorProbabilities[i]});
            MetadataAttribute pAttribute = new MetadataAttribute("prior_probability", pData, true);
            element.addAttribute(pAttribute);
        }
    }
}

