/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.cluster;

import com.bc.ceres.core.ProgressMonitor;
import de.gkss.hs.datev2004.Clucov;
import de.gkss.hs.datev2004.DataSet;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Set;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;

@OperatorMetadata(alias="ClucovClusterAnalysis", category="Classification/Clustering", version="1.0", authors="Helmut Schiller, Norman Fomferra", copyright="(c) 2007 by Brockmann Consult", description="Cluster analysis using the CLUCOV algorithm.", internal=true)
public class ClucovClusterOp
extends Operator {
    @SourceProduct(alias="source")
    Product sourceProduct;
    @TargetProduct
    Product targetProduct;
    @Parameter(label="Source band names", description="The names of the bands being used for the cluster analysis.", rasterDataNodeType=Band.class)
    String[] sourceBandNames;
    @Parameter
    String roiExpression;
    private transient Band[] featureBands;
    private transient Band groupBand;
    private transient Clucov clucov;

    public void initialize() throws OperatorException {
        this.featureBands = new Band[this.sourceBandNames.length];
        for (int i = 0; i < this.sourceBandNames.length; ++i) {
            String featureBandName = this.sourceBandNames[i];
            Band band = this.sourceProduct.getBand(featureBandName);
            if (band == null) {
                throw new OperatorException("Feature band not found: " + featureBandName);
            }
            this.featureBands[i] = band;
        }
        int width = this.sourceProduct.getSceneRasterWidth();
        int height = this.sourceProduct.getSceneRasterHeight();
        this.targetProduct = new Product("clucov", "clucov", width, height);
        this.groupBand = this.targetProduct.addBand("group", 20);
        this.groupBand.setUnit("-");
        this.groupBand.setDescription("Cluster group number");
    }

    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        if (this.clucov == null) {
            try {
                this.computeClusters(pm);
                this.storeClustersInProduct();
            }
            catch (IOException e) {
                throw new OperatorException((Throwable)e);
            }
        }
        if (band == this.groupBand) {
            Rectangle rectangle = targetTile.getRectangle();
            int sourceWidth = this.sourceProduct.getSceneRasterWidth();
            DataSet ds = this.clucov.ds;
            for (int y = rectangle.y; y < rectangle.y + rectangle.height; ++y) {
                for (int x = rectangle.x; x < rectangle.x + rectangle.width; ++x) {
                    int dsIndex = y * sourceWidth + x;
                    targetTile.setSample(x, y, (int)ds.group[dsIndex]);
                }
                this.checkForCancellation();
            }
        }
    }

    private void storeClustersInProduct() {
        MetadataElement metadataRoot = this.targetProduct.getMetadataRoot();
        Set<Short> shorts = this.clucov.clusters.keySet();
        MetadataElement clustersElement = new MetadataElement("clusters");
        metadataRoot.addElement(clustersElement);
        for (Short aShort : shorts) {
            Clucov.Cluster cluster = this.clucov.clusters.get(aShort);
            MetadataElement clusterElement = new MetadataElement("cluster");
            clusterElement.addAttribute(new MetadataAttribute("group", ProductData.createInstance((short[])new short[]{cluster.group}), true));
            clusterElement.addAttribute(new MetadataAttribute("gauss.normfactor", ProductData.createInstance((double[])new double[]{cluster.gauss.normfactor}), true));
            clusterElement.addAttribute(new MetadataAttribute("gauss.cog", ProductData.createInstance((double[])cluster.gauss.cog), true));
            double[][] array = cluster.gauss.covinv.getArray();
            for (int i = 0; i < array.length; ++i) {
                clusterElement.addAttribute(new MetadataAttribute("gauss.covinv." + i, ProductData.createInstance((double[])array[i]), true));
            }
            clustersElement.addElement(clusterElement);
        }
    }

    private void computeClusters(ProgressMonitor pm) throws IOException {
        int width = this.sourceProduct.getSceneRasterWidth();
        int height = this.sourceProduct.getSceneRasterHeight();
        double[] scanLine = new double[width];
        double[][] dsVectors = new double[width][this.featureBands.length];
        DataSet ds = new DataSet(width * height, this.featureBands.length);
        for (int y = 0; y < height; ++y) {
            for (int i = 0; i < this.featureBands.length; ++i) {
                Band featureBand = this.featureBands[i];
                featureBand.readPixels(0, y, width, 1, scanLine, ProgressMonitor.NULL);
                for (int x = 0; x < width; ++x) {
                    dsVectors[x][i] = scanLine[x];
                }
            }
            for (int x = 0; x < width; ++x) {
                ds.add(dsVectors[x]);
            }
            this.checkForCancellation();
        }
        this.clucov = new Clucov(ds);
        this.clucov.initialize(30);
        this.clucov.run();
    }

    public void dispose() {
        super.dispose();
        this.clucov = null;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ClucovClusterOp.class);
        }
    }
}

