/*
 * Decompiled with CFR 0.152.
 */
package de.gkss.hs.datev2004;

import de.gkss.hs.datev2004.DataSet;
import de.gkss.hs.datev2004.FirstMoments;
import de.gkss.hs.datev2004.Gaussian;
import de.gkss.hs.datev2004.General;
import de.gkss.hs.datev2004.MathUtil;
import de.gkss.hs.datev2004.RecMom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Logger;

public class Clucov {
    public int max_iteration = 20;
    public int n_planes = 100;
    public double mahadistsqCut = 100.0;
    public double t_div = 0.0;
    public double t_comb = 0.05;
    public int cont_min = 8;
    public int max_clusters = 10;
    public int few_changes = 0;
    public DataSet ds;
    Logger logger;
    Random rgen;
    public HashMap<Short, Cluster> clusters;
    int iteration;
    short next_cluster;

    public Clucov(DataSet ds) {
        this(ds, new Random());
    }

    public Clucov(DataSet ds, Logger logger) {
        this(ds, logger, new Random());
    }

    public Clucov(DataSet ds, Logger logger, Random rgen) {
        this.ds = ds;
        this.rgen = rgen;
        this.logger = logger;
    }

    public Clucov(DataSet ds, Random rgen) {
        this(ds, Logger.getAnonymousLogger(), rgen);
    }

    void printCluster(Cluster cluster) {
        this.logger.info("this is cluster " + cluster.group + " history: " + cluster.history);
    }

    Cluster[] alive() {
        Cluster[] res = new Cluster[this.clusters.size()];
        Iterator<Short> keys = this.clusters.keySet().iterator();
        int i = 0;
        while (keys.hasNext()) {
            res[i] = this.clusters.get(keys.next());
            ++i;
        }
        return res;
    }

    void calculate_moments() {
        Cluster cl;
        for (Short s : this.clusters.keySet()) {
            cl = this.clusters.get(s);
            cl.right = new RecMom(this.ds.dim);
            cl.left = new RecMom(this.ds.dim);
        }
        for (int np = 0; np < this.ds.npoints; ++np) {
            if (this.ds.group[np] == 0) continue;
            cl = this.clusters.get(this.ds.group[np]);
            int lr = this.side(this.ds.pt[np], cl.plane, cl.fm.avg);
            if (lr == 0) {
                cl.right.recalc(this.ds.pt[np], this.ds.wgt[np]);
                continue;
            }
            cl.left.recalc(this.ds.pt[np], this.ds.wgt[np]);
        }
    }

    int closest(double[] pt, Cluster[] clusters) {
        double[] d = new double[clusters.length];
        for (int c = 0; c < clusters.length; ++c) {
            d[c] = clusters[c].fm.swgt * clusters[c].gauss.density(pt);
        }
        int fnd = General.indmax(d);
        if (clusters[fnd].gauss.distancesqu(pt) < this.mahadistsqCut) {
            return fnd;
        }
        return -1;
    }

    public boolean clustering(boolean last) {
        boolean res = false;
        int find_res = this.find_planes();
        if (!last) {
            if (find_res < 0) {
                return false;
            }
            if (find_res > this.few_changes) {
                res = true;
            }
            if (this.removeSmall() != 0) {
                res = true;
            }
            this.calculate_moments();
            if (this.split()) {
                res = true;
            }
            if (this.combine()) {
                res = true;
            }
        }
        if (this.iteration == 1) {
            res = true;
        }
        for (Short s : this.clusters.keySet()) {
            Cluster rc = this.clusters.get(s);
            rc.gauss = new Gaussian(rc.fm.avg, rc.fm.cov);
        }
        return res;
    }

    boolean combine() {
        boolean res = false;
        boolean change = true;
        while (change) {
            double thigh = -1.0;
            Cluster[] clusters = this.alive();
            int cmax = 0;
            int dmax = 0;
            for (int c = 0; c < clusters.length; ++c) {
                for (int d = 0; d < c; ++d) {
                    double tv = this.test_ndim(clusters[c].fm, clusters[d].fm);
                    this.logger.fine(clusters[c].group + " | " + clusters[d].group + " have a combinated t of " + tv);
                    if (!(tv > thigh)) continue;
                    thigh = tv;
                    cmax = c;
                    dmax = d;
                }
            }
            if (thigh > this.t_comb) {
                String bn = "(" + clusters[cmax].history + "," + clusters[dmax].history + ")";
                short nn = this.next_cluster;
                this.next_cluster = (short)(this.next_cluster + 1);
                this.logger.info(clusters[cmax].group + " | " + clusters[dmax].group + " t=" + thigh + ": groups are combined" + " into the new group " + nn);
                Cluster both = new Cluster(nn, bn);
                both.fm = clusters[cmax].fm.combine(clusters[dmax].fm);
                this.clusters.put(nn, both);
                this.clusters.remove(clusters[cmax].group);
                this.clusters.remove(clusters[dmax].group);
                res = true;
                continue;
            }
            change = false;
        }
        return res;
    }

    int find_planes() {
        int k;
        int changes = 0;
        double[][] planes = new double[this.n_planes][this.ds.dim];
        for (int i = 0; i < this.n_planes; ++i) {
            planes[i] = General.vector_rand(this.ds.dim, this.rgen);
        }
        Cluster[] cl = this.alive();
        if (cl.length < 2 & this.iteration > 1) {
            this.logger.info("only " + cl.length + " clusters left");
            this.rename();
            return -1;
        }
        RecMom[][][] r1 = new RecMom[2][this.n_planes][cl.length];
        for (int i = 0; i < this.n_planes; ++i) {
            for (int k2 = 0; k2 < cl.length; ++k2) {
                r1[0][i][k2] = new RecMom(1);
                r1[1][i][k2] = new RecMom(1);
            }
        }
        for (int np = 0; np < this.ds.npoints; ++np) {
            int indneu = this.closest(this.ds.pt[np], cl);
            if (indneu < 0) {
                this.ds.group[np] = 0;
                continue;
            }
            if (cl[indneu].group != this.ds.group[np]) {
                ++changes;
                this.ds.group[np] = cl[indneu].group;
            }
            for (k = 0; k < this.n_planes; ++k) {
                double proj = MathUtil.scalarProduct(planes[k], MathUtil.vectorSubtract(this.ds.pt[np], cl[indneu].fm.avg));
                if (proj < 0.0) {
                    r1[0][k][indneu].recalc(proj, this.ds.wgt[np]);
                    continue;
                }
                r1[1][k][indneu].recalc(proj, this.ds.wgt[np]);
            }
        }
        for (int c = 0; c < cl.length; ++c) {
            double[] d = new double[this.n_planes];
            for (k = 0; k < this.n_planes; ++k) {
                d[k] = r1[0][k][c].npoints < 2L || r1[1][k][c].npoints < 2L ? Double.MAX_VALUE : this.test_1dim(r1[0][k][c], r1[1][k][c]);
            }
            int fnd = General.indmin(d);
            cl[c].plane = d[fnd] > 1.0 ? General.vector_rand(this.ds.dim, this.rgen) : planes[fnd];
        }
        this.logger.info(changes + " points changed group membership");
        return changes;
    }

    public void initialize(int nclinit) {
        this.logger.info("\n----------------------------------------\nClucov.initialize try " + nclinit + " clusters");
        int nclini = nclinit;
        if (nclini > this.ds.npoints) {
            nclini = this.ds.npoints;
            this.logger.info("Clucov.initialize: nclinit changed to " + nclini);
        }
        int[] ptn = new int[nclini];
        boolean ok = false;
        while (!ok) {
            int i;
            for (i = 0; i < nclini; ++i) {
                ptn[i] = (int)((double)this.ds.npoints * this.rgen.nextDouble());
            }
            ok = true;
            block2: for (i = 0; i < nclini - 1; ++i) {
                for (int j = i + 1; j < nclini; ++j) {
                    if (ptn[i] != ptn[j]) continue;
                    ok = false;
                    continue block2;
                }
            }
        }
        double[] dp = new double[nclini];
        for (int i = 0; i < this.ds.npoints; ++i) {
            for (int k = 0; k < nclini; ++k) {
                dp[k] = General.eucliddist(this.ds.pt[i], this.ds.pt[ptn[k]]);
            }
            int cl = General.indmin(dp);
            this.ds.group[i] = (short)(cl + 1);
        }
        this.makeClusters();
        this.iteration = 0;
    }

    public void initialize(double radius) {
        int near;
        int ncl;
        int np;
        double[][] centers = new double[this.max_clusters][this.ds.dim];
        double[] dist = new double[this.max_clusters];
        this.logger.info("\n----------------------------------------\nClucov.initialize with cluster radius " + radius);
        for (int i = 0; i < this.max_clusters; ++i) {
            dist[i] = Double.MAX_VALUE;
        }
        centers[0] = this.ds.pt[0];
        int nclex = 1;
        for (np = 1; np < this.ds.npoints; ++np) {
            for (ncl = 0; ncl < nclex; ++ncl) {
                dist[ncl] = General.eucliddist(centers[ncl], this.ds.pt[np]);
            }
            near = General.indmin(dist);
            if (!(dist[near] > radius)) continue;
            centers[nclex] = this.ds.pt[np];
            this.ds.group[np] = nclex = (int)((short)(nclex + 1));
            if (nclex != this.max_clusters) continue;
            General.error("Clucov.initialize: to many clusters");
        }
        this.ds.group[0] = 1;
        for (np = 1; np < this.ds.npoints; ++np) {
            for (ncl = 0; ncl < nclex; ++ncl) {
                dist[ncl] = General.eucliddist(centers[ncl], this.ds.pt[np]);
            }
            near = General.indmin(dist);
            this.ds.group[np] = (short)(near + 1);
        }
        this.makeClusters();
        this.iteration = 0;
    }

    public int iterate() {
        int res = 0;
        boolean clustering = true;
        while (clustering) {
            ++res;
            ++this.iteration;
            if (this.iteration == this.max_iteration + 1) {
                this.logger.info("break by max_iteration <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
                break;
            }
            this.logger.info("------------------------------------------");
            this.logger.info("Start of iteration " + res);
            clustering = this.clustering(false);
            this.printSizes();
        }
        return res - 1;
    }

    void makeClusters() {
        this.clusters = new HashMap();
        short[] cln = this.ds.groups();
        FirstMoments[] fm = this.ds.groupMoments();
        for (int i = 0; i < cln.length; ++i) {
            if (fm[i].npoints < (long)this.cont_min) {
                this.logger.info("ones clusters content too small: not generated");
                continue;
            }
            Cluster cl = new Cluster(cln[i]);
            this.printCluster(cl);
            cl.gauss = new Gaussian(fm[i].avg, fm[i].cov);
            cl.fm = fm[i];
            this.clusters.put(cln[i], cl);
        }
        this.next_cluster = (short)(cln.length + 1);
    }

    public void printOverlap() {
        int c;
        int j;
        Cluster[] clusters = this.alive();
        if (clusters.length < 2) {
            return;
        }
        this.logger.info("overlap matrix:");
        double[][] ovm = new double[clusters.length][clusters.length];
        for (Cluster cluster : clusters) {
            this.logger.info("  group " + cluster.group);
        }
        this.logger.info("overlaps with ");
        for (int i = 0; i < clusters.length; ++i) {
            for (j = 0; j < clusters.length; ++j) {
                ovm[i][j] = 0.0;
            }
        }
        for (int np = 0; np < this.ds.npoints; ++np) {
            double[] d = new double[clusters.length];
            for (c = 0; c < clusters.length; ++c) {
                d[c] = clusters[c].fm.swgt * clusters[c].gauss.density(this.ds.pt[np]);
            }
            int fnd = General.indmax(d);
            if (clusters[fnd].gauss.distancesqu(this.ds.pt[np]) < this.mahadistsqCut) {
                for (int c2 = 0; c2 < clusters.length; ++c2) {
                    double[] dArray = ovm[fnd];
                    int n = c2;
                    dArray[n] = dArray[n] + d[c2];
                }
                this.ds.group[np] = clusters[fnd].group;
                continue;
            }
            this.ds.group[np] = 0;
        }
        double[] sum = new double[clusters.length];
        for (j = 0; j < clusters.length; ++j) {
            sum[j] = 0.0;
        }
        for (int c3 = 0; c3 < clusters.length; ++c3) {
            for (int j2 = 0; j2 < clusters.length; ++j2) {
                int n = c3;
                sum[n] = sum[n] + ovm[c3][j2];
            }
        }
        for (j = 0; j < clusters.length; ++j) {
            this.logger.info(clusters[j].group + "\t");
            for (c = 0; c < clusters.length; ++c) {
                this.logger.info((int)(1000.0 * ovm[c][j] / sum[c]) + "\t");
            }
        }
    }

    public void printClusters() {
        int[] idx = this.ds.indices((short)0);
        if (idx.length == 0) {
            this.logger.info("all points are assigned to clusters.");
        } else {
            this.logger.info("the following " + idx.length + " points are not assigned to clusters:");
            for (int anIdx : idx) {
                this.logger.info("  P" + anIdx + " ");
            }
        }
        Iterator<Short> keys = this.clusters.keySet().iterator();
        this.logger.info("the " + this.clusters.size() + " clusters and their contents:");
        while (keys.hasNext()) {
            short grp = keys.next();
            Cluster cl = this.clusters.get(grp);
            idx = this.ds.indices(grp);
            this.logger.info("  cl. " + grp + " with history " + cl.history + " has the following " + idx.length + " points");
            for (int anIdx : idx) {
                this.logger.info("    P" + anIdx + " ");
            }
        }
    }

    public void printSizes() {
        int[] idx = this.ds.indices((short)0);
        if (idx.length == 0) {
            this.logger.info("all points are assigned to clusters.");
        } else {
            this.logger.info(idx.length + " points are not assigned to clusters. ");
        }
        Iterator<Short> keys = this.clusters.keySet().iterator();
        this.logger.info("the " + this.clusters.size() + " clusters and their contents:");
        while (keys.hasNext()) {
            short grp = keys.next();
            idx = this.ds.indices(grp);
            Cluster cl = this.clusters.get(grp);
            this.logger.info("  cluster " + grp + " with history " + cl.history + " has " + idx.length + " points");
        }
    }

    int removeSmall() {
        int res = 0;
        Iterator<Short> keys = this.clusters.keySet().iterator();
        while (keys.hasNext()) {
            short grp = keys.next();
            int[] idx = this.ds.indices(grp);
            if (idx.length >= this.cont_min) continue;
            ++res;
            for (int np = 0; np < this.ds.npoints; ++np) {
                if (grp != this.ds.group[np]) continue;
                this.ds.group[np] = 0;
            }
            keys.remove();
            this.logger.info("cluster " + grp + " removed. content was " + idx.length);
        }
        return res;
    }

    public void rename() {
        Cluster[] clusters = this.alive();
        this.clusters = new HashMap();
        int[][] ind = new int[clusters.length][];
        long[] cont = new long[clusters.length];
        for (int i = 0; i < clusters.length; ++i) {
            ind[i] = this.ds.indices(clusters[i].group);
            cont[i] = ind[i].length;
        }
        this.next_cluster = 1;
        for (Cluster cluster : clusters) {
            int ima = General.indmax(cont);
            short nn = this.next_cluster;
            this.next_cluster = (short)(this.next_cluster + 1);
            short on = clusters[ima].group;
            this.logger.info("old group " + on + " becomes new group " + nn);
            clusters[ima].group = nn;
            this.clusters.put(nn, clusters[ima]);
            for (int k = 0; k < ind[ima].length; ++k) {
                this.ds.group[ind[ima][k]] = nn;
            }
            cont[ima] = -1L;
        }
    }

    public void run() {
        if (this.ds.npoints < 2 * this.ds.dim) {
            this.logger.info("no sense to cluster " + this.ds.npoints + " points of dimension " + this.ds.dim);
            return;
        }
        this.logger.info("\n--------------------------------------\nmax_iteration=" + this.max_iteration + "\nn_planes=" + this.n_planes + "\nsigma_cut=" + this.mahadistsqCut + "\nt_div=" + this.t_div + "\nt_comb=" + this.t_comb + "\ncont_min=" + this.cont_min + "\nmax_clusters=" + this.max_clusters + "\nfew_changes=" + this.few_changes);
        this.iteration = 0;
        int numIter = this.iterate();
        this.logger.info("\nrun finished after " + numIter + " iterations.\n");
        this.rename();
        this.printOverlap();
        this.printSizes();
    }

    int side(double[] pt, double[] plane, double[] cog) {
        if (MathUtil.scalarProduct(plane, MathUtil.vectorSubtract(pt, cog)) < 0.0) {
            return 0;
        }
        return 1;
    }

    boolean split() {
        Cluster[] clusters;
        boolean res = false;
        for (Cluster cluster : clusters = this.alive()) {
            FirstMoments right = cluster.right.get();
            FirstMoments left = cluster.left.get();
            double tv = this.test_ndim(right, left);
            this.logger.info("group " + cluster.group + " t=" + tv);
            boolean split = false;
            if (tv < this.t_div) {
                split = true;
                if (right.npoints < (long)this.cont_min || left.npoints < (long)this.cont_min) {
                    split = false;
                    this.logger.info(" not splitted. Groups would be to small");
                }
                if (clusters.length > this.max_clusters - 1) {
                    split = false;
                    this.logger.info(" not splitted. Would give to many groups.");
                }
            }
            if (split) {
                short nr = this.next_cluster;
                this.next_cluster = (short)(this.next_cluster + 1);
                Cluster part = new Cluster(nr, cluster.history + "r");
                part.fm = right;
                this.clusters.put(nr, part);
                short nl = this.next_cluster;
                this.next_cluster = (short)(this.next_cluster + 1);
                part = new Cluster(nl, cluster.history + "l");
                part.fm = left;
                this.clusters.put(nl, part);
                this.clusters.remove(cluster.group);
                this.logger.info(" splitted into " + nr + " and " + nl);
                res = true;
                continue;
            }
            cluster.fm = right.combine(left);
        }
        return res;
    }

    double test_1(RecMom lm, RecMom rm, Gaussian l, Gaussian r, double x) {
        return lm.swgt * l.density(x) + rm.swgt * r.density(x);
    }

    double test_1dim(RecMom lm, RecMom rm) {
        Gaussian l = new Gaussian(lm.avg, lm.var);
        Gaussian r = new Gaussian(rm.avg, rm.var);
        double h1 = this.test_1(lm, rm, l, r, lm.avg);
        double h2 = this.test_1(lm, rm, l, r, rm.avg);
        double dx = (lm.avg - rm.avg) / 50.0;
        double h0 = Double.MAX_VALUE;
        for (int i = 1; i < 50; ++i) {
            double df = this.test_1(lm, rm, l, r, rm.avg + (double)i * dx);
            if (!(df < h0)) continue;
            h0 = df;
        }
        return h0 / Math.sqrt(h1 * h2);
    }

    double test_n(FirstMoments lm, FirstMoments rm, Gaussian l, Gaussian r, double[] x) {
        return lm.swgt * l.density(x) + rm.swgt * r.density(x);
    }

    double test_ndim(FirstMoments lm, FirstMoments rm) {
        Gaussian l = new Gaussian(lm.avg, lm.cov);
        Gaussian r = new Gaussian(rm.avg, rm.cov);
        double h1 = this.test_n(lm, rm, l, r, lm.avg);
        double h2 = this.test_n(lm, rm, l, r, rm.avg);
        double[] dx = MathUtil.multiplyVecorWithScalar(MathUtil.vectorSubtract(lm.avg, rm.avg), 0.02);
        double h0 = Double.MAX_VALUE;
        for (int i = 1; i < 50; ++i) {
            double df = this.test_n(lm, rm, l, r, MathUtil.vectorAdd(rm.avg, MathUtil.multiplyVecorWithScalar(dx, i)));
            if (!(df < h0)) continue;
            h0 = df;
        }
        return h0 / Math.sqrt(h1 * h2);
    }

    public static class Cluster {
        public short group;
        public String history;
        public Gaussian gauss;
        public double[] plane;
        public RecMom right;
        public RecMom left;
        public FirstMoments fm;

        Cluster(short group) {
            this.group = group;
            this.history = "" + group;
        }

        Cluster(short group, String history) {
            this.group = group;
            this.history = history;
        }
    }
}

