/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.classification.gpf;

import java.awt.Desktop;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.util.SystemUtils;

public class ClassifierReport {
    private final String classifierType;
    private final String classifierName;
    private String topClassifier;
    private final List<String> classifierEvaluations = new ArrayList<String>();
    private final List<String> featureEvaluations = new ArrayList<String>();
    private final List<String> powerSetEvaluations = new ArrayList<String>();
    private static final String REPORT_FILE_EXTENSION = ".txt";

    public ClassifierReport(String classifierType, String classifierName) {
        this.classifierType = classifierType;
        this.classifierName = classifierName;
    }

    public void addClassifierEvaluation(String classifierEvaluation) {
        this.classifierEvaluations.add(classifierEvaluation);
    }

    public void addFeatureEvaluation(String featureEvaluation) {
        this.featureEvaluations.add(featureEvaluation);
    }

    public void addPowerSetEvaluation(String powerSetEvaluation) {
        this.powerSetEvaluations.add(powerSetEvaluation);
    }

    public void setTopClassifier(String statement) {
        this.topClassifier = statement;
    }

    public Path getReportFilePath() throws IOException {
        Path classifierDir = SystemUtils.getAuxDataPath().resolve("classifiers").resolve(this.classifierType);
        if (Files.notExists(classifierDir, new LinkOption[0])) {
            Files.createDirectories(classifierDir, new FileAttribute[0]);
        }
        return classifierDir.resolve(this.classifierName + REPORT_FILE_EXTENSION);
    }

    public void writeReport() throws IOException {
        try (PrintWriter printWriter = new PrintWriter(new FileWriter(this.getReportFilePath().toFile()));){
            printWriter.println(this.classifierType + " classifier " + this.classifierName);
            printWriter.println();
            for (String classifierEvaluation : this.classifierEvaluations) {
                printWriter.println(classifierEvaluation);
            }
            for (String featureEvaluation : this.featureEvaluations) {
                printWriter.println(featureEvaluation);
            }
            if (this.powerSetEvaluations.size() > 1) {
                printWriter.println("Power set evaluation:");
                for (String powerSetEvaluation : this.powerSetEvaluations) {
                    printWriter.println(powerSetEvaluation);
                }
                printWriter.println();
                printWriter.println(this.topClassifier);
            }
        }
    }

    public void openClassifierReport() throws IOException {
        File reportFile = this.getReportFilePath().toFile();
        if (Desktop.isDesktopSupported() && reportFile.exists()) {
            try {
                Desktop.getDesktop().open(reportFile);
            }
            catch (Exception e) {
                SystemUtils.LOG.warning("Error opening report file " + e.getMessage());
            }
        }
    }
}

