/*
 * Copyright (C) 2012 Brockmann Consult GmbH (info@brockmann-consult.de)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, see http://www.gnu.org/licenses/
 */

package org.esa.snap.binning.operator;

import org.esa.snap.core.gpf.annotations.Parameter;

/**
 * Configuration of a binning variable.
 *
 * @author Norman Fomferra
 * @see org.esa.snap.binning.VariableContext
 */
public class VariableConfig {
    @Parameter(description = "The name of the variable", notEmpty = true, notNull = true)
    private String name;

    @Parameter(description = "The expression of the variable")
    private String expr;

    public VariableConfig() {
    }

    public VariableConfig(String name, String expr) {
        this.name = name;
        this.expr = expr;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExpr() {
        return expr;
    }

    public void setExpr(String expr) {
        this.expr = expr;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        VariableConfig that = (VariableConfig) o;

        if (!name.equals(that.name)) return false;
        if (!expr.equals(that.expr)) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = name.hashCode();
        result = 31 * result + expr.hashCode();
        return result;
    }
}
