/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.support;

import java.util.Calendar;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.Product;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TemporalDataPeriodTest {
    public static final String[] INPUT_FILES = new String[]{"MER_RR__2PNUPA20051202_102336_000026292043_00051_19644_7303.N1", "MER_RR__2PNUPA20051202_120412_000026292043_00052_19645_7304.N1", "MER_RR__2PNUPA20051202_134448_000026292043_00053_19646_1187.N1", "MER_RR__2PNUPA20051202_152524_000026292043_00054_19647_7305.N1", "MER_RR__2PNUPA20051202_170600_000026322043_00055_19648_7306.N1", "MER_RR__2PNUPA20051202_184636_000026322043_00056_19649_7307.N1", "MER_RR__2PNUPA20051202_202713_000026292043_00057_19650_7308.N1", "MER_RR__2PNUPA20051202_220749_000026292043_00058_19651_1188.N1", "MER_RR__2PNUPA20051202_234825_000026292043_00059_19652_7309.N1", "MER_RR__2PNUPA20051203_012901_000026292043_00060_19653_7310.N1", "MER_RR__2PNUPA20051203_030937_000026292043_00061_19654_7311.N1", "MER_RR__2PNUPA20051203_063049_000026292043_00063_19656_7312.N1", "MER_RR__2PNUPA20051203_081125_000026322043_00064_19657_7313.N1", "MER_RR__2PNUPA20051203_095201_000026292043_00065_19658_7314.N1", "MER_RR__2PNUPA20051203_113237_000026292043_00066_19659_7315.N1", "MER_RR__2PNUPA20051203_131314_000026552043_00067_19660_1189.N1", "MER_RR__2PNUPA20051203_145350_000026292043_00068_19661_7316.N1", "MER_RR__2PNUPA20051203_163426_000026292043_00069_19662_7317.N1", "MER_RR__2PNUPA20051203_181502_000026292043_00070_19663_7318.N1", "MER_RR__2PNUPA20051203_195538_000026292043_00071_19664_1190.N1", "MER_RR__2PNUPA20051203_213614_000026292043_00072_19665_7319.N1", "MER_RR__2PNUPA20051203_231651_000026292043_00073_19666_7320.N1", "MER_RR__2PNUPA20051204_005727_000026292043_00074_19667_7321.N1", "MER_RR__2PNUPA20051204_023803_000026292043_00075_19668_7322.N1", "MER_RR__2PNUPA20051204_041839_000026292043_00076_19669_7323.N1", "MER_RR__2PNUPA20051204_055915_000026292043_00077_19670_7324.N1", "MER_RR__2PNUPA20051204_073951_000026292043_00078_19671_1191.N1", "MER_RR__2PNUPA20051204_092027_000026292043_00079_19672_7325.N1"};

    @Test
    @Ignore(value="Ignoring in order to not irritate the build server")
    public void testName() throws Exception {
        int ifile;
        instr input = new instr();
        input.sday = 2005337;
        input.eday = 2005338;
        int nfiles = INPUT_FILES.length;
        l2_prod[] l2_str = new l2_prod[nfiles];
        int proc_day_beg = input.sday;
        int proc_day_end = input.eday;
        int[] brk_scan = new int[nfiles];
        for (ifile = 0; ifile < nfiles; ++ifile) {
            String inputFile = INPUT_FILES[ifile];
            Product product = ProductIO.readProduct((String)("C:\\dev\\Ressourcen\\EOData\\binning_testdata_oc\\" + inputFile));
            l2_str[ifile] = new l2_prod();
            Calendar startTime = product.getStartTime().getAsCalendar();
            l2_str[ifile].syear = startTime.get(1);
            l2_str[ifile].sday = startTime.get(6);
            int hourAsMillisecond = startTime.get(11) * 60 * 60 * 1000;
            int minuteAsMillisecond = startTime.get(12) * 60 * 1000;
            int secondAsMillisecond = startTime.get(13) * 1000;
            l2_str[ifile].smsec = hourAsMillisecond + minuteAsMillisecond + secondAsMillisecond + startTime.get(14);
            l2_str[ifile].nrec = product.getSceneRasterHeight();
            l2_str[ifile].nsamp = product.getSceneRasterWidth();
            l2_str[ifile].longitude = new float[product.getSceneRasterHeight() * product.getSceneRasterWidth()];
            l2_str[ifile].latitude = new float[product.getSceneRasterHeight() * product.getSceneRasterWidth()];
            this.fillArray(l2_str[ifile].longitude, product, "longitude");
            this.fillArray(l2_str[ifile].latitude, product, "latitude");
            product.closeIO();
            int syear = l2_str[ifile].syear;
            int sday = l2_str[ifile].sday;
            int smsec = l2_str[ifile].smsec;
            int date = TemporalDataPeriodTest.date(syear, sday);
            int diffday_beg = TemporalDataPeriodTest.diffday(date, proc_day_beg);
            int diffday_end = TemporalDataPeriodTest.diffday(date, proc_day_end);
            int ssec = smsec / 1000;
            float[] slon = new float[product.getSceneRasterHeight()];
            float[] elon = new float[product.getSceneRasterHeight()];
            for (int i = 0; i < product.getSceneRasterHeight(); ++i) {
                slon[i] = l2_str[ifile].longitude[i * product.getSceneRasterWidth()];
                elon[i] = l2_str[ifile].longitude[i * product.getSceneRasterWidth() + product.getSceneRasterWidth() - 1];
            }
            boolean scancross = TemporalDataPeriodTest.scancross(product.getSceneRasterHeight(), slon, elon);
            brk_scan[ifile] = 0;
            int p1hr = 19;
            if (diffday_beg <= -2) {
                brk_scan[ifile] = -9999;
            } else if (diffday_end >= 2) {
                brk_scan[ifile] = -9999;
            }
            if (diffday_beg == -1) {
                boolean later;
                boolean bl = later = ssec > p1hr * 60 * 60;
                brk_scan[ifile] = later && scancross ? -1 : (later && !scancross ? 0 : -9999);
            }
            if (diffday_end == 1) {
                brk_scan[ifile] = -9999;
            } else if (date == proc_day_beg && date == proc_day_end && ssec > p1hr * 60 * 60) {
                brk_scan[ifile] = scancross ? 1 : -9999;
            }
            System.out.println("brk_scan[" + INPUT_FILES[ifile] + "] = " + brk_scan[ifile]);
            l2_str[ifile] = null;
        }
        System.exit(0);
        for (ifile = 0; ifile < nfiles; ++ifile) {
            if (brk_scan[ifile] == -9999) continue;
            int date = l2_str[ifile].syear * 1000 + l2_str[ifile].sday;
            int diffday_beg = TemporalDataPeriodTest.diffday(date, proc_day_beg);
            int diffday_end = TemporalDataPeriodTest.diffday(date, proc_day_end);
            int sday = l2_str[ifile].sday;
            int ssec = l2_str[ifile].smsec / 1000;
            for (int jsrow = 0; jsrow < l2_str[ifile].nrec; ++jsrow) {
                int nsamp = l2_str[ifile].nsamp;
                if (nsamp == 0) continue;
                for (int isamp = 0; isamp < nsamp; ++isamp) {
                    int ipixl = isamp;
                    if (!(input.night ? (brk_scan[ifile] != -1 || diffday_beg != -1 || !(l2_str[ifile].longitude[ipixl] < 0.0f)) && brk_scan[ifile] == 1 && diffday_end == 0 && l2_str[ifile].longitude[ipixl] > 0.0f : brk_scan[ifile] == -1 && diffday_beg <= 0 && l2_str[ifile].longitude[ipixl] < 0.0f || brk_scan[ifile] != 1 || diffday_end < 0 || l2_str[ifile].longitude[ipixl] > 0.0f)) continue;
                }
            }
        }
    }

    private void fillArray(float[] array, Product product, String gridName) {
        int j = 0;
        for (int y = 0; y < product.getSceneRasterHeight(); ++y) {
            for (int x = 0; x < product.getSceneRasterWidth(); ++x) {
                array[j] = product.getTiePointGrid(gridName).getSampleFloat(x, y);
                ++j;
            }
        }
    }

    @Test
    public void testScancross() throws Exception {
        Assert.assertFalse((boolean)TemporalDataPeriodTest.scancross(5, new float[]{0.0f, 1.0f, 2.0f, 3.0f, 4.0f}, new float[]{0.5f, 1.5f, 2.5f, 3.5f, 4.5f}));
        Assert.assertTrue((boolean)TemporalDataPeriodTest.scancross(6, new float[]{-2.0f, -1.0f, 0.0f, 1.0f, 2.0f, 3.0f}, new float[]{-1.5f, -0.5f, 0.5f, 1.5f, 2.5f, 3.5f}));
        Assert.assertFalse((boolean)TemporalDataPeriodTest.scancross(6, new float[]{2.0f, 1.0f, 0.0f, -1.0f, -2.0f, -3.0f}, new float[]{2.5f, 1.5f, 0.5f, -0.5f, -1.5f, -2.5f}));
        Assert.assertTrue((boolean)TemporalDataPeriodTest.scancross(5, new float[]{-178.0f, -179.0f, 180.0f, 179.0f, 178.0f}, new float[]{-177.5f, -178.5f, -179.5f, 179.5f, 178.5f}));
        Assert.assertTrue((boolean)TemporalDataPeriodTest.scancross(5, new float[]{178.0f, 179.0f, 180.0f, -179.0f, -178.0f}, new float[]{178.5f, 179.5f, -179.5f, -178.5f, -177.5f}));
    }

    public static int date(int year, int doy) {
        return year * 1000 + doy;
    }

    public static boolean scancross(int nrec, float[] slon, float[] elon) {
        boolean scancross = false;
        for (int jsrow = nrec - 1; jsrow >= 1; --jsrow) {
            boolean bl = scancross = slon[jsrow] >= 0.0f && slon[jsrow - 1] < 0.0f;
            if (scancross) break;
            boolean bl2 = scancross = slon[jsrow] >= 0.0f && elon[jsrow] < 0.0f;
            if (scancross) break;
        }
        return scancross;
    }

    public static boolean isleap(int year) {
        return year % 400 == 0 || year % 4 == 0 && year % 100 != 0;
    }

    public static int diffday(int date1, int date2) {
        int i;
        int year1 = date1 / 1000;
        int year2 = date2 / 1000;
        int day1 = date1 % 1000;
        int day2 = date2 % 1000;
        for (i = year2; i < year1; ++i) {
            if (TemporalDataPeriodTest.isleap(i)) {
                day1 += 366;
                continue;
            }
            day1 += 365;
        }
        for (i = year1; i < year2; ++i) {
            if (TemporalDataPeriodTest.isleap(i)) {
                day2 += 366;
                continue;
            }
            day2 += 365;
        }
        return day1 - day2;
    }

    public static class l2_prod {
        int nrec;
        int syear;
        int sday;
        int smsec;
        int nsamp;
        float[] longitude;
        float[] latitude;
    }

    public static class instr {
        int sday;
        int eday;
        boolean night;
    }
}

