/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.support;

import org.esa.snap.binning.support.SEAGrid;
import org.junit.Assert;
import org.junit.Test;

public class SEAGridTest {
    @Test
    public void testConstructors() {
        SEAGrid grid = new SEAGrid();
        Assert.assertEquals((long)2160L, (long)grid.getNumRows());
        grid = new SEAGrid(2);
        Assert.assertEquals((long)2L, (long)grid.getNumRows());
        try {
            new SEAGrid(1);
            Assert.fail((String)"IAE expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new SEAGrid(0);
            Assert.fail((String)"IAE expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new SEAGrid(-1);
            Assert.fail((String)"IAE expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new SEAGrid(9);
            Assert.fail((String)"IAE expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testDefaultGrid() {
        int NUM_ROWS = 2160;
        int NUM_BINS = 5940422;
        SEAGrid grid = new SEAGrid();
        SEAGridTest.testGrid(grid, NUM_ROWS, 5940422L);
    }

    @Test
    public void testMerisFRGrid() {
        int NUM_ROWS = 66792;
        long NUM_BINS = 5680139712L;
        SEAGrid grid = new SEAGrid(66792);
        SEAGridTest.testGrid(grid, 66792, 5680139712L);
    }

    private static void testGrid(SEAGrid grid, int numRows, long numBins) {
        Assert.assertEquals((long)numRows, (long)grid.getNumRows());
        Assert.assertEquals((long)numBins, (long)grid.getNumBins());
        Assert.assertEquals((long)3L, (long)grid.getNumCols(0));
        Assert.assertEquals((long)(2 * numRows), (long)grid.getNumCols(numRows / 2));
        Assert.assertEquals((long)(2 * numRows), (long)grid.getNumCols(numRows / 2 + 1));
        Assert.assertEquals((long)3L, (long)grid.getNumCols(numRows - 1));
        double W = 360.0 / (double)(2 * numRows);
        double H = 180.0 / (double)numRows;
        Assert.assertEquals((long)0L, (long)grid.getBinIndex(90.0, -180.0));
        Assert.assertEquals((long)1L, (long)grid.getBinIndex(90.0, 0.0));
        Assert.assertEquals((long)2L, (long)grid.getBinIndex(90.0, 180.0));
        Assert.assertEquals((long)(numBins - 3L), (long)grid.getBinIndex(-90.0, -180.0));
        Assert.assertEquals((long)(numBins - 2L), (long)grid.getBinIndex(-90.0, 0.0));
        Assert.assertEquals((long)(numBins - 1L), (long)grid.getBinIndex(-90.0, 180.0));
        Assert.assertEquals((long)(numBins / 2L - 1L), (long)grid.getBinIndex(H / 2.0, 180.0));
        Assert.assertEquals((long)(numBins / 2L), (long)grid.getBinIndex(-H / 2.0, -180.0));
    }

    @Test
    public void testPerformance() {
        long t0 = System.nanoTime();
        int N = 1000;
        for (int i = 0; i < N; ++i) {
            new SEAGrid();
        }
        long t1 = System.nanoTime();
        double seconds = (double)(t1 - t0) / 1.0E9;
        Assert.assertTrue((String)("Bad performance in " + SEAGrid.class + " detected, took " + seconds + " seconds"), (seconds < 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetRowIndex() {
        SEAGrid grid = new SEAGrid(6);
        try {
            grid.getRowIndex(-1L);
            Assert.fail((String)"ArrayIndexOutOfBoundsException?");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)grid.getRowIndex(0L));
        Assert.assertEquals((long)0L, (long)grid.getRowIndex(1L));
        Assert.assertEquals((long)0L, (long)grid.getRowIndex(2L));
        Assert.assertEquals((long)1L, (long)grid.getRowIndex(3L));
        Assert.assertEquals((long)1L, (long)grid.getRowIndex(4L));
        Assert.assertEquals((long)1L, (long)grid.getRowIndex(5L));
        Assert.assertEquals((long)1L, (long)grid.getRowIndex(6L));
        Assert.assertEquals((long)1L, (long)grid.getRowIndex(7L));
        Assert.assertEquals((long)1L, (long)grid.getRowIndex(8L));
        Assert.assertEquals((long)1L, (long)grid.getRowIndex(9L));
        Assert.assertEquals((long)1L, (long)grid.getRowIndex(10L));
        Assert.assertEquals((long)2L, (long)grid.getRowIndex(11L));
        Assert.assertEquals((long)2L, (long)grid.getRowIndex(12L));
        Assert.assertEquals((long)2L, (long)grid.getRowIndex(13L));
        Assert.assertEquals((long)2L, (long)grid.getRowIndex(14L));
        Assert.assertEquals((long)2L, (long)grid.getRowIndex(15L));
        Assert.assertEquals((long)2L, (long)grid.getRowIndex(16L));
        Assert.assertEquals((long)2L, (long)grid.getRowIndex(17L));
        Assert.assertEquals((long)2L, (long)grid.getRowIndex(18L));
        Assert.assertEquals((long)2L, (long)grid.getRowIndex(19L));
        Assert.assertEquals((long)2L, (long)grid.getRowIndex(20L));
        Assert.assertEquals((long)2L, (long)grid.getRowIndex(21L));
        Assert.assertEquals((long)2L, (long)grid.getRowIndex(22L));
        Assert.assertEquals((long)3L, (long)grid.getRowIndex(23L));
        Assert.assertEquals((long)3L, (long)grid.getRowIndex(24L));
        Assert.assertEquals((long)3L, (long)grid.getRowIndex(25L));
        Assert.assertEquals((long)3L, (long)grid.getRowIndex(26L));
        Assert.assertEquals((long)3L, (long)grid.getRowIndex(27L));
        Assert.assertEquals((long)3L, (long)grid.getRowIndex(28L));
        Assert.assertEquals((long)3L, (long)grid.getRowIndex(29L));
        Assert.assertEquals((long)3L, (long)grid.getRowIndex(30L));
        Assert.assertEquals((long)3L, (long)grid.getRowIndex(31L));
        Assert.assertEquals((long)3L, (long)grid.getRowIndex(32L));
        Assert.assertEquals((long)3L, (long)grid.getRowIndex(33L));
        Assert.assertEquals((long)3L, (long)grid.getRowIndex(34L));
        Assert.assertEquals((long)4L, (long)grid.getRowIndex(35L));
        Assert.assertEquals((long)4L, (long)grid.getRowIndex(36L));
        Assert.assertEquals((long)4L, (long)grid.getRowIndex(37L));
        Assert.assertEquals((long)4L, (long)grid.getRowIndex(38L));
        Assert.assertEquals((long)4L, (long)grid.getRowIndex(39L));
        Assert.assertEquals((long)4L, (long)grid.getRowIndex(40L));
        Assert.assertEquals((long)4L, (long)grid.getRowIndex(41L));
        Assert.assertEquals((long)4L, (long)grid.getRowIndex(42L));
        Assert.assertEquals((long)5L, (long)grid.getRowIndex(43L));
        Assert.assertEquals((long)5L, (long)grid.getRowIndex(44L));
        Assert.assertEquals((long)5L, (long)grid.getRowIndex(45L));
        try {
            grid.getRowIndex(46L);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFirstBinIndex() {
        SEAGrid grid = new SEAGrid(6);
        try {
            grid.getFirstBinIndex(-1);
            Assert.fail((String)"ArrayIndexOutOfBoundsException?");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)grid.getFirstBinIndex(0));
        Assert.assertEquals((long)3L, (long)grid.getFirstBinIndex(1));
        Assert.assertEquals((long)11L, (long)grid.getFirstBinIndex(2));
        Assert.assertEquals((long)23L, (long)grid.getFirstBinIndex(3));
        Assert.assertEquals((long)35L, (long)grid.getFirstBinIndex(4));
        Assert.assertEquals((long)43L, (long)grid.getFirstBinIndex(5));
        try {
            grid.getFirstBinIndex(6);
            Assert.fail((String)"ArrayIndexOutOfBoundsException?");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testGetCenterLat() {
        SEAGrid grid = new SEAGrid(6);
        try {
            grid.getCenterLat(-1);
            Assert.fail((String)"ArrayIndexOutOfBoundsException?");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertEquals((double)75.0, (double)grid.getCenterLat(0), (double)1.0E-10);
        Assert.assertEquals((double)45.0, (double)grid.getCenterLat(1), (double)1.0E-10);
        Assert.assertEquals((double)15.0, (double)grid.getCenterLat(2), (double)1.0E-10);
        Assert.assertEquals((double)-15.0, (double)grid.getCenterLat(3), (double)1.0E-10);
        Assert.assertEquals((double)-45.0, (double)grid.getCenterLat(4), (double)1.0E-10);
        Assert.assertEquals((double)-75.0, (double)grid.getCenterLat(5), (double)1.0E-10);
        try {
            grid.getCenterLat(6);
            Assert.fail((String)"ArrayIndexOutOfBoundsException?");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testGetBinIndex() {
        SEAGrid grid = new SEAGrid(6);
        Assert.assertEquals((long)0L, (long)grid.getBinIndex(75.0, -500.0));
        Assert.assertEquals((long)0L, (long)grid.getBinIndex(100.0, -120.0));
        Assert.assertEquals((long)0L, (long)grid.getBinIndex(75.0, -120.0));
        Assert.assertEquals((long)2L, (long)grid.getBinIndex(75.0, 120.0));
        Assert.assertEquals((long)3L, (long)grid.getBinIndex(45.0, -157.5));
        Assert.assertEquals((long)10L, (long)grid.getBinIndex(45.0, 157.5));
        Assert.assertEquals((long)11L, (long)grid.getBinIndex(15.0, -165.0));
        Assert.assertEquals((long)22L, (long)grid.getBinIndex(15.0, 165.0));
        Assert.assertEquals((long)23L, (long)grid.getBinIndex(-15.0, -165.0));
        Assert.assertEquals((long)34L, (long)grid.getBinIndex(-15.0, 165.0));
        Assert.assertEquals((long)35L, (long)grid.getBinIndex(-45.0, -157.5));
        Assert.assertEquals((long)42L, (long)grid.getBinIndex(-45.0, 157.5));
        Assert.assertEquals((long)43L, (long)grid.getBinIndex(-75.0, -120.0));
        Assert.assertEquals((long)45L, (long)grid.getBinIndex(-75.0, 120.0));
        Assert.assertEquals((long)45L, (long)grid.getBinIndex(-75.0, 500.0));
        Assert.assertEquals((long)45L, (long)grid.getBinIndex(-100.0, 120.0));
    }

    @Test
    public void testGetCenterLatLon() {
        SEAGrid grid = new SEAGrid(6);
        try {
            grid.getCenterLatLon(-1L);
            Assert.fail((String)"ArrayIndexOutOfBoundsException?");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertArrayEquals((double[])new double[]{75.0, -120.0}, (double[])grid.getCenterLatLon(0L), (double)1.0E-10);
        Assert.assertArrayEquals((double[])new double[]{75.0, 120.0}, (double[])grid.getCenterLatLon(2L), (double)1.0E-10);
        Assert.assertArrayEquals((double[])new double[]{45.0, -157.5}, (double[])grid.getCenterLatLon(3L), (double)1.0E-10);
        Assert.assertArrayEquals((double[])new double[]{45.0, 157.5}, (double[])grid.getCenterLatLon(10L), (double)1.0E-10);
        Assert.assertArrayEquals((double[])new double[]{15.0, -165.0}, (double[])grid.getCenterLatLon(11L), (double)1.0E-10);
        Assert.assertArrayEquals((double[])new double[]{15.0, 165.0}, (double[])grid.getCenterLatLon(22L), (double)1.0E-10);
        Assert.assertArrayEquals((double[])new double[]{-15.0, -165.0}, (double[])grid.getCenterLatLon(23L), (double)1.0E-10);
        Assert.assertArrayEquals((double[])new double[]{-15.0, 165.0}, (double[])grid.getCenterLatLon(34L), (double)1.0E-10);
        Assert.assertArrayEquals((double[])new double[]{-45.0, -157.5}, (double[])grid.getCenterLatLon(35L), (double)1.0E-10);
        Assert.assertArrayEquals((double[])new double[]{-45.0, 157.5}, (double[])grid.getCenterLatLon(42L), (double)1.0E-10);
        Assert.assertArrayEquals((double[])new double[]{-75.0, -120.0}, (double[])grid.getCenterLatLon(43L), (double)1.0E-10);
        Assert.assertArrayEquals((double[])new double[]{-75.0, 120.0}, (double[])grid.getCenterLatLon(45L), (double)1.0E-10);
        try {
            grid.getCenterLatLon(grid.getNumBins());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testComputeRowCount() {
        Assert.assertEquals((long)2160L, (long)SEAGrid.computeRowCount((double)9.28));
        Assert.assertEquals((long)4320L, (long)SEAGrid.computeRowCount((double)4.64));
        Assert.assertEquals((long)1080L, (long)SEAGrid.computeRowCount((double)18.56));
        Assert.assertEquals((long)66792L, (long)SEAGrid.computeRowCount((double)0.3));
        Assert.assertEquals((long)50094L, (long)SEAGrid.computeRowCount((double)0.4));
    }
}

