/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.support;

import org.esa.snap.binning.support.GaussianGridConfig;
import org.junit.Assert;
import org.junit.Test;

public class GaussianGridConfigTest {
    @Test
    public void testN128() throws Exception {
        GaussianGridConfig gridConfig = GaussianGridConfig.load((int)128);
        Assert.assertEquals((long)512L, (long)gridConfig.getRegularColumnCount());
        Assert.assertEquals((long)25L, (long)gridConfig.getReducedColumnCount(1));
        Assert.assertEquals((long)450L, (long)gridConfig.getReducedColumnCount(80));
        Assert.assertEquals((long)25L, (long)gridConfig.getReducedColumnCount(254));
        Assert.assertEquals((long)18L, (long)gridConfig.getReducedColumnCount(255));
        Assert.assertEquals((double)71.929491, (double)gridConfig.getLatitude(25), (double)1.0E-6);
        Assert.assertEquals((double)-0.350877, (double)gridConfig.getLatitude(128), (double)1.0E-6);
        Assert.assertEquals((long)512L, (long)gridConfig.getRegularLongitudePoints().length);
        Assert.assertEquals((long)18L, (long)gridConfig.getReducedLongitudePoints(0).length);
        Assert.assertEquals((long)450L, (long)gridConfig.getReducedLongitudePoints(80).length);
        Assert.assertEquals((long)3973L, (long)gridConfig.getReducedFirstBinIndex(33));
    }

    @Test
    public void testN400() throws Exception {
        GaussianGridConfig gridConfig = GaussianGridConfig.load((int)400);
        Assert.assertEquals((long)1600L, (long)gridConfig.getRegularColumnCount());
        Assert.assertEquals((long)25L, (long)gridConfig.getReducedColumnCount(1));
        Assert.assertEquals((long)540L, (long)gridConfig.getReducedColumnCount(80));
        Assert.assertEquals((long)640L, (long)gridConfig.getReducedColumnCount(700));
        Assert.assertEquals((long)18L, (long)gridConfig.getReducedColumnCount(799));
        Assert.assertEquals((double)84.209759, (double)gridConfig.getLatitude(25), (double)1.0E-6);
        Assert.assertEquals((double)-8.207369, (double)gridConfig.getLatitude(436), (double)1.0E-6);
        Assert.assertEquals((long)1600L, (long)gridConfig.getRegularLongitudePoints().length);
        Assert.assertEquals((long)18L, (long)gridConfig.getReducedLongitudePoints(0).length);
        Assert.assertEquals((long)540L, (long)gridConfig.getReducedLongitudePoints(80).length);
        Assert.assertEquals((long)1517L, (long)gridConfig.getReducedFirstBinIndex(20));
    }

    @Test
    public void testLongitudeComputation() throws Exception {
        double[] lons = GaussianGridConfig.computeLongitudePoints((int)2);
        Assert.assertEquals((long)2L, (long)lons.length);
        Assert.assertEquals((double)0.0, (double)lons[0], (double)0.0);
        Assert.assertEquals((double)180.0, (double)lons[1], (double)0.0);
        lons = GaussianGridConfig.computeLongitudePoints((int)360);
        Assert.assertEquals((long)360L, (long)lons.length);
        Assert.assertEquals((double)0.0, (double)lons[0], (double)0.0);
        Assert.assertEquals((double)179.0, (double)lons[179], (double)0.0);
        Assert.assertEquals((double)180.0, (double)lons[180], (double)0.0);
        Assert.assertEquals((double)359.0, (double)lons[359], (double)0.0);
        lons = GaussianGridConfig.computeLongitudePoints((int)9);
        Assert.assertEquals((long)9L, (long)lons.length);
        Assert.assertEquals((double)0.0, (double)lons[0], (double)0.0);
        Assert.assertEquals((double)160.0, (double)lons[4], (double)0.0);
        Assert.assertEquals((double)320.0, (double)lons[8], (double)0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testException() throws Exception {
        GaussianGridConfig.load((int)100);
    }
}

