/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.reader;

import java.net.URI;
import java.net.URL;
import org.esa.snap.binning.reader.BinnedProductReader;
import org.esa.snap.core.datamodel.ProductData;
import org.junit.Assert;
import org.junit.Test;
import ucar.nc2.NetcdfFile;

public class BinnedProductReaderTest {
    @Test
    public void testExtractStartTime() throws Exception {
        URL resource = this.getClass().getResource("test.nc");
        NetcdfFile netcdfFile = NetcdfFile.openInMemory((URI)resource.toURI());
        ProductData.UTC startTime = BinnedProductReader.extractStartTime((NetcdfFile)netcdfFile);
        Assert.assertEquals((long)ProductData.UTC.parse((String)"20030101:0000", (String)"yyyyMMdd:HHmm").getAsDate().getTime(), (long)startTime.getAsDate().getTime());
    }

    @Test
    public void testExtractEndTime() throws Exception {
        URL resource = this.getClass().getResource("test.nc");
        NetcdfFile netcdfFile = NetcdfFile.openInMemory((URI)resource.toURI());
        ProductData.UTC startTime = BinnedProductReader.extractEndTime((NetcdfFile)netcdfFile);
        Assert.assertEquals((long)ProductData.UTC.parse((String)"20030101:0000", (String)"yyyyMMdd:HHmm").getAsDate().getTime(), (long)startTime.getAsDate().getTime());
    }

    @Test
    public void testExtractStartTime_NoTimeInfo() throws Exception {
        URL resource = this.getClass().getResource("test_without_time_info.nc");
        NetcdfFile netcdfFile = NetcdfFile.openInMemory((URI)resource.toURI());
        ProductData.UTC startTime = BinnedProductReader.extractStartTime((NetcdfFile)netcdfFile);
        Assert.assertNull((Object)startTime);
    }

    @Test
    public void testExtractEndTime_NoTimeInfo() throws Exception {
        URL resource = this.getClass().getResource("test_without_time_info.nc");
        NetcdfFile netcdfFile = NetcdfFile.openInMemory((URI)resource.toURI());
        ProductData.UTC endTime = BinnedProductReader.extractEndTime((NetcdfFile)netcdfFile);
        Assert.assertNull((Object)endTime);
    }

    @Test
    public void testGetWavelengthFromBandName() {
        Assert.assertEquals((long)670L, (long)BinnedProductReader.getWavelengthFromBandName((String)"atot_670"));
        Assert.assertEquals((long)443L, (long)BinnedProductReader.getWavelengthFromBandName((String)"aph_443"));
        Assert.assertEquals((long)0L, (long)BinnedProductReader.getWavelengthFromBandName((String)"chlor_a"));
        Assert.assertEquals((long)0L, (long)BinnedProductReader.getWavelengthFromBandName((String)"latitude"));
    }

    @Test
    public void testIsSubSampled() {
        Assert.assertTrue((boolean)BinnedProductReader.isSubSampled((int)2, (int)1));
        Assert.assertTrue((boolean)BinnedProductReader.isSubSampled((int)1, (int)4));
        Assert.assertFalse((boolean)BinnedProductReader.isSubSampled((int)1, (int)1));
    }
}

