/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import java.util.SortedMap;
import org.esa.snap.binning.AggregatorConfig;
import org.esa.snap.binning.CellProcessorConfig;
import org.esa.snap.binning.DataPeriod;
import org.esa.snap.binning.aggregators.AggregatorAverage;
import org.esa.snap.binning.aggregators.AggregatorMinMax;
import org.esa.snap.binning.aggregators.AggregatorPercentile;
import org.esa.snap.binning.operator.BinningConfig;
import org.esa.snap.binning.operator.BinningOp;
import org.esa.snap.binning.operator.BinningProductFilter;
import org.esa.snap.binning.operator.SpatialDataDaySourceProductFilter;
import org.esa.snap.binning.operator.TestUtils;
import org.esa.snap.binning.operator.VariableConfig;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.main.GPT;
import org.esa.snap.core.util.converters.JtsGeometryConverter;
import org.esa.snap.core.util.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BinningOpTest {
    static final File TESTDATA_DIR = new File("target/binning-test-io");

    @Before
    public void setUp() throws Exception {
        TESTDATA_DIR.mkdirs();
        if (!TESTDATA_DIR.isDirectory()) {
            Assert.fail((String)("Can't create test I/O directory: " + TESTDATA_DIR));
        }
    }

    @After
    public void tearDown() throws Exception {
        if (!FileUtils.deleteTree((File)TESTDATA_DIR)) {
            System.err.println("Warning: failed to completely delete test I/O directory:" + TESTDATA_DIR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetadataGeneration() throws Exception {
        BinningOp binningOp = this.createBinningOp();
        binningOp.setSourceProducts(new Product[]{BinningOpTest.createSourceProduct(1, 0.1f), BinningOpTest.createSourceProduct(2, 0.2f), BinningOpTest.createSourceProduct(3, 0.3f)});
        binningOp.setStartDateTime("2002-01-01");
        binningOp.setPeriodDuration(Double.valueOf(10.0));
        binningOp.setAggregatorConfigs(new AggregatorConfig[]{BinningOpTest.chlAgg(), BinningOpTest.p70Agg()});
        binningOp.setNumRows(180);
        binningOp.setMaskExpr("true");
        binningOp.setOutputFile(BinningOpTest.getTestFile("target-1.dim").getPath());
        binningOp.setOutputType("Product");
        binningOp.setOutputFormat("BEAM-DIMAP");
        binningOp.setMetadataAggregatorName("NAME");
        binningOp.setParameter("metadataTemplateDir", (Object)TESTDATA_DIR);
        Assert.assertNull((Object)binningOp.getMetadataProperties());
        Product targetProduct = binningOp.getTargetProduct();
        try {
            SortedMap metadataProperties = binningOp.getMetadataProperties();
            Assert.assertNotNull((Object)metadataProperties);
            Assert.assertEquals((long)17L, (long)metadataProperties.size());
            Set strings = metadataProperties.keySet();
            Object[] names = strings.toArray(new String[strings.size()]);
            Object[] expectedNames = new String[]{"aggregation_period_duration", "aggregation_period_start", "aggregator_config.0:type", "aggregator_config.0:varName", "aggregator_config.1:percentage", "aggregator_config.1:type", "aggregator_config.1:varName", "mask_expression", "metadata_aggregator_name", "num_rows", "pixel_size_in_km", "product_name", "region", "software_name", "software_qualified_name", "software_version", "super_sampling"};
            Assert.assertArrayEquals((Object[])expectedNames, (Object[])names);
            Assert.assertEquals((Object)"target-1", metadataProperties.get("product_name"));
            Assert.assertEquals((Object)"Binning", metadataProperties.get("software_name"));
            Assert.assertEquals((Object)"org.esa.snap.binning.operator.BinningOp", metadataProperties.get("software_qualified_name"));
            Assert.assertEquals((Object)"1.0", metadataProperties.get("software_version"));
            Assert.assertEquals((Object)"2002-01-01", metadataProperties.get("aggregation_period_start"));
            Assert.assertEquals((Object)"LINEARRING (0 0, 0 1, 1 1, 1 0, 0 0)", metadataProperties.get("region"));
            MetadataElement metadataRoot = targetProduct.getMetadataRoot();
            MetadataElement processingGraph = metadataRoot.getElement("Processing_Graph");
            MetadataElement node_0 = processingGraph.getElement("node.0");
            MetadataElement sourcesElement = node_0.getElement("sources");
            Assert.assertNotNull((Object)sourcesElement);
            Assert.assertEquals((long)3L, (long)sourcesElement.getNumElements());
        }
        finally {
            targetProduct.dispose();
        }
    }

    @Test
    public void testInvalidDates() throws Exception {
        BinningOp binningOp = this.createBinningOp();
        binningOp.setStartDateTime("2010-01-01");
        binningOp.setPeriodDuration(Double.valueOf(-1.0));
        try {
            binningOp.initialize();
            Assert.fail();
        }
        catch (OperatorException expected) {
            Assert.assertTrue((boolean)expected.getMessage().equals("The parameter 'periodDuration' must be a positive value"));
        }
    }

    @Test
    public void testBinningWithEmptyMaskExpression() throws Exception {
        float obs1 = 0.2f;
        BinningOp binningOp = this.createBinningOp();
        binningOp.setAggregatorConfigs(new AggregatorConfig[]{BinningOpTest.chlAgg(), BinningOpTest.p70Agg()});
        binningOp.setNumRows(180);
        JtsGeometryConverter geometryConverter = new JtsGeometryConverter();
        binningOp.setSourceProducts(new Product[]{BinningOpTest.createSourceProduct(1, obs1)});
        binningOp.setStartDateTime("2002-01-01");
        binningOp.setPeriodDuration(Double.valueOf(10.0));
        binningOp.setMaskExpr("");
        File targetFile = BinningOpTest.getTestFile("target-1.dim");
        binningOp.setOutputFile(targetFile.getPath());
        binningOp.setOutputType("Product");
        binningOp.setOutputFormat("BEAM-DIMAP");
        binningOp.setRegion(geometryConverter.parse("POLYGON ((-180 -90, -180 90, 180 90, 180 -90, -180 -90))"));
        Product targetProduct = binningOp.getTargetProduct();
        Assert.assertNotNull((Object)targetProduct);
        targetProduct.dispose();
    }

    @Test
    public void testBinningWhenMaskExpressionIsNull() throws Exception {
        File targetFile = BinningOpTest.getTestFile("target-1.dim");
        float obs1 = 0.2f;
        BinningOp binningOp = this.createBinningOp();
        binningOp.setAggregatorConfigs(new AggregatorConfig[]{BinningOpTest.chlAgg(), BinningOpTest.p70Agg()});
        binningOp.setNumRows(180);
        JtsGeometryConverter geometryConverter = new JtsGeometryConverter();
        binningOp.setSourceProducts(new Product[]{BinningOpTest.createSourceProduct(1, obs1)});
        binningOp.setStartDateTime("2002-01-01");
        binningOp.setPeriodDuration(Double.valueOf(10.0));
        binningOp.setMaskExpr(null);
        binningOp.setOutputFile(targetFile.getPath());
        binningOp.setOutputType("Product");
        binningOp.setOutputFormat("BEAM-DIMAP");
        binningOp.setRegion(geometryConverter.parse("POLYGON ((-180 -90, -180 90, 180 90, 180 -90, -180 -90))"));
        Product targetProduct = binningOp.getTargetProduct();
        Assert.assertNotNull((Object)targetProduct);
        targetProduct.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGlobalBinning() throws Exception {
        File targetFile = BinningOpTest.getTestFile("target-1.dim");
        float obs1 = 0.2f;
        float obs2 = 0.4f;
        float obs3 = 0.6f;
        float obs4 = 0.8f;
        float obs5 = 1.0f;
        BinningOp binningOp = this.createBinningOp();
        binningOp.setAggregatorConfigs(new AggregatorConfig[]{BinningOpTest.chlAgg(), BinningOpTest.p70Agg()});
        binningOp.setNumRows(180);
        binningOp.setMaskExpr("true");
        binningOp.setSourceProducts(new Product[]{BinningOpTest.createSourceProduct(1, obs1), BinningOpTest.createSourceProduct(2, obs2), BinningOpTest.createSourceProduct(3, obs3), BinningOpTest.createSourceProduct(4, obs4), BinningOpTest.createSourceProduct(5, obs5)});
        JtsGeometryConverter geometryConverter = new JtsGeometryConverter();
        binningOp.setOutputFile(targetFile.getPath());
        binningOp.setOutputType("Product");
        binningOp.setOutputFormat("BEAM-DIMAP");
        binningOp.setStartDateTime("2002-01-01");
        binningOp.setPeriodDuration(Double.valueOf(10.0));
        binningOp.setRegion(geometryConverter.parse("POLYGON ((-180 -90, -180 90, 180 90, 180 -90, -180 -90))"));
        Product targetProduct = binningOp.getTargetProduct();
        Assert.assertNotNull((Object)targetProduct);
        try {
            this.assertGlobalBinningProductIsOk(targetProduct, null, obs1, obs2, obs3, obs4, obs5);
        }
        finally {
            targetProduct.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalBinning() throws Exception {
        File targetFile = BinningOpTest.getTestFile("target-1.dim");
        float obs1 = 0.2f;
        float obs2 = 0.4f;
        float obs3 = 0.6f;
        float obs4 = 0.8f;
        float obs5 = 1.0f;
        BinningOp binningOp = this.createBinningOp();
        binningOp.setAggregatorConfigs(new AggregatorConfig[]{BinningOpTest.chlAgg(), BinningOpTest.p70Agg()});
        binningOp.setNumRows(180);
        binningOp.setMaskExpr("true");
        binningOp.setOutputFile(targetFile.getPath());
        binningOp.setOutputType("Product");
        binningOp.setOutputFormat("BEAM-DIMAP");
        binningOp.setSourceProducts(new Product[]{BinningOpTest.createSourceProduct(1, obs1), BinningOpTest.createSourceProduct(2, obs2), BinningOpTest.createSourceProduct(3, obs3), BinningOpTest.createSourceProduct(4, obs4), BinningOpTest.createSourceProduct(5, obs5)});
        GeometryFactory gf = new GeometryFactory();
        binningOp.setRegion((Geometry)gf.createPolygon(gf.createLinearRing(new Coordinate[]{new Coordinate(-1.0, -1.0), new Coordinate(3.0, -1.0), new Coordinate(3.0, 3.0), new Coordinate(-1.0, 3.0), new Coordinate(-1.0, -1.0)}), null));
        binningOp.setStartDateTime("2002-01-01");
        binningOp.setPeriodDuration(Double.valueOf(10.0));
        Product targetProduct = binningOp.getTargetProduct();
        Assert.assertNotNull((Object)targetProduct);
        try {
            this.assertLocalBinningProductIsOk(targetProduct, null, obs1, obs2, obs3, obs4, obs5);
        }
        finally {
            targetProduct.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGlobalBinningViaGPF() throws Exception {
        File targetFile = BinningOpTest.getTestFile("target-1.dim");
        float obs1 = 0.2f;
        float obs2 = 0.4f;
        float obs3 = 0.6f;
        float obs4 = 0.8f;
        float obs5 = 1.0f;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("startDateTime", "2002-01-01");
        parameters.put("periodDuration", "10");
        parameters.put("numRows", 180);
        parameters.put("maskExpr", "true");
        parameters.put("aggregatorConfigs", new AggregatorConfig[]{BinningOpTest.chlAgg(), BinningOpTest.p70Agg()});
        parameters.put("outputFile", targetFile.getPath());
        parameters.put("outputType", "Product");
        parameters.put("outputFormat", "BEAM-DIMAP");
        parameters.put("region", "POLYGON ((-180 -90, -180 90, 180 90, 180 -90, -180 -90))");
        Product targetProduct = GPF.createProduct((String)"Binning", parameters, (Product[])new Product[]{BinningOpTest.createSourceProduct(1, obs1), BinningOpTest.createSourceProduct(2, obs2), BinningOpTest.createSourceProduct(3, obs3), BinningOpTest.createSourceProduct(4, obs4), BinningOpTest.createSourceProduct(5, obs5)});
        Assert.assertNotNull((Object)targetProduct);
        try {
            this.assertGlobalBinningProductIsOk(targetProduct, null, obs1, obs2, obs3, obs4, obs5);
        }
        finally {
            targetProduct.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalBinningViaGPF() throws Exception {
        File targetFile = BinningOpTest.getTestFile("target-1.dim");
        float obs1 = 0.2f;
        float obs2 = 0.4f;
        float obs3 = 0.6f;
        float obs4 = 0.8f;
        float obs5 = 1.0f;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("region", "POLYGON((-1 -1, 3 -1, 3 3, -1 3, -1 -1))");
        parameters.put("startDateTime", "2002-01-01");
        parameters.put("periodDuration", "10");
        parameters.put("numRows", 180);
        parameters.put("maskExpr", "true");
        parameters.put("aggregatorConfigs", new AggregatorConfig[]{BinningOpTest.chlAgg(), BinningOpTest.p70Agg()});
        parameters.put("outputFile", targetFile.getPath());
        parameters.put("outputType", "Product");
        parameters.put("outputFormat", "BEAM-DIMAP");
        Product targetProduct = GPF.createProduct((String)"Binning", parameters, (Product[])new Product[]{BinningOpTest.createSourceProduct(1, obs1), BinningOpTest.createSourceProduct(2, obs2), BinningOpTest.createSourceProduct(3, obs3), BinningOpTest.createSourceProduct(4, obs4), BinningOpTest.createSourceProduct(5, obs5)});
        Assert.assertNotNull((Object)targetProduct);
        try {
            this.assertLocalBinningProductIsOk(targetProduct, null, obs1, obs2, obs3, obs4, obs5);
        }
        finally {
            targetProduct.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGlobalBinningViaGPT() throws Exception {
        float obs1 = 0.2f;
        float obs2 = 0.4f;
        float obs3 = 0.6f;
        float obs4 = 0.8f;
        float obs5 = 1.0f;
        File parameterFile = new File(this.getClass().getResource("BinningParamsGlobal.xml").toURI());
        File targetFile = BinningOpTest.getTestFile("output.dim");
        File sourceFile1 = BinningOpTest.getTestFile("obs1.dim");
        File sourceFile2 = BinningOpTest.getTestFile("obs2.dim");
        File sourceFile3 = BinningOpTest.getTestFile("obs3.dim");
        File sourceFile4 = BinningOpTest.getTestFile("obs4.dim");
        File sourceFile5 = BinningOpTest.getTestFile("obs5.dim");
        ProductIO.writeProduct((Product)BinningOpTest.createSourceProduct(1, obs1), (File)sourceFile1, (String)"BEAM-DIMAP", (boolean)false);
        ProductIO.writeProduct((Product)BinningOpTest.createSourceProduct(2, obs2), (File)sourceFile2, (String)"BEAM-DIMAP", (boolean)false);
        ProductIO.writeProduct((Product)BinningOpTest.createSourceProduct(3, obs3), (File)sourceFile3, (String)"BEAM-DIMAP", (boolean)false);
        ProductIO.writeProduct((Product)BinningOpTest.createSourceProduct(4, obs4), (File)sourceFile4, (String)"BEAM-DIMAP", (boolean)false);
        ProductIO.writeProduct((Product)BinningOpTest.createSourceProduct(5, obs5), (File)sourceFile5, (String)"BEAM-DIMAP", (boolean)false);
        GPT.run((String[])new String[]{"Binning", "-p", parameterFile.getPath(), "-t", targetFile.getPath(), sourceFile1.getPath(), sourceFile2.getPath(), sourceFile3.getPath(), sourceFile4.getPath(), sourceFile5.getPath()});
        Assert.assertTrue((boolean)targetFile.exists());
        Product targetProduct = ProductIO.readProduct((File)targetFile);
        Assert.assertNotNull((Object)targetProduct);
        try {
            this.assertGlobalBinningProductIsOk(targetProduct, targetFile, obs1, obs2, obs3, obs4, obs5);
        }
        finally {
            targetProduct.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalBinningViaGPT() throws Exception {
        float obs1 = 0.2f;
        float obs2 = 0.4f;
        float obs3 = 0.6f;
        float obs4 = 0.8f;
        float obs5 = 1.0f;
        File parameterFile = new File(this.getClass().getResource("BinningParamsLocal.xml").toURI());
        String fileName = "output.dim";
        File targetFile = BinningOpTest.getTestFile("output.dim");
        File sourceFile1 = BinningOpTest.getTestFile("obs1.dim");
        File sourceFile2 = BinningOpTest.getTestFile("obs2.dim");
        File sourceFile3 = BinningOpTest.getTestFile("obs3.dim");
        File sourceFile4 = BinningOpTest.getTestFile("obs4.dim");
        File sourceFile5 = BinningOpTest.getTestFile("obs5.dim");
        ProductIO.writeProduct((Product)BinningOpTest.createSourceProduct(1, obs1), (File)sourceFile1, (String)"BEAM-DIMAP", (boolean)false);
        ProductIO.writeProduct((Product)BinningOpTest.createSourceProduct(2, obs2), (File)sourceFile2, (String)"BEAM-DIMAP", (boolean)false);
        ProductIO.writeProduct((Product)BinningOpTest.createSourceProduct(3, obs3), (File)sourceFile3, (String)"BEAM-DIMAP", (boolean)false);
        ProductIO.writeProduct((Product)BinningOpTest.createSourceProduct(4, obs4), (File)sourceFile4, (String)"BEAM-DIMAP", (boolean)false);
        ProductIO.writeProduct((Product)BinningOpTest.createSourceProduct(5, obs5), (File)sourceFile5, (String)"BEAM-DIMAP", (boolean)false);
        GPT.run((String[])new String[]{"Binning", "-p", parameterFile.getPath(), "-t", targetFile.getPath(), sourceFile1.getPath(), sourceFile2.getPath(), sourceFile3.getPath(), sourceFile4.getPath(), sourceFile5.getPath()});
        Assert.assertTrue((boolean)targetFile.exists());
        Product targetProduct = ProductIO.readProduct((File)targetFile);
        Assert.assertNotNull((Object)targetProduct);
        try {
            this.assertLocalBinningProductIsOk(targetProduct, targetFile, obs1, obs2, obs3, obs4, obs5);
        }
        finally {
            targetProduct.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGlobalBinningViaGPT_FilePattern() throws Exception {
        float obs1 = 0.2f;
        float obs2 = 0.4f;
        float obs3 = 0.6f;
        float obs4 = 0.8f;
        float obs5 = 1.0f;
        File parameterFile = new File(this.getClass().getResource("BinningParamsGlobal_FilePattern.xml").toURI());
        File targetFile = BinningOpTest.getTestFile("output.dim");
        File sourceFile1 = BinningOpTest.getTestFile("obs1.dim");
        File sourceFile2 = BinningOpTest.getTestFile("obs2.dim");
        File sourceFile3 = BinningOpTest.getTestFile("obs3.dim");
        File sourceFile4 = BinningOpTest.getTestFile("obs4.dim");
        File sourceFile5 = BinningOpTest.getTestFile("obs5.dim");
        ProductIO.writeProduct((Product)BinningOpTest.createSourceProduct(1, obs1), (File)sourceFile1, (String)"BEAM-DIMAP", (boolean)false);
        ProductIO.writeProduct((Product)BinningOpTest.createSourceProduct(2, obs2), (File)sourceFile2, (String)"BEAM-DIMAP", (boolean)false);
        ProductIO.writeProduct((Product)BinningOpTest.createSourceProduct(3, obs3), (File)sourceFile3, (String)"BEAM-DIMAP", (boolean)false);
        ProductIO.writeProduct((Product)BinningOpTest.createSourceProduct(4, obs4), (File)sourceFile4, (String)"BEAM-DIMAP", (boolean)false);
        ProductIO.writeProduct((Product)BinningOpTest.createSourceProduct(5, obs5), (File)sourceFile5, (String)"BEAM-DIMAP", (boolean)false);
        GPT.run((String[])new String[]{"Binning", "-p", parameterFile.getPath(), "-t", targetFile.getPath()});
        Assert.assertTrue((boolean)targetFile.exists());
        Product targetProduct = ProductIO.readProduct((File)targetFile);
        Assert.assertNotNull((Object)targetProduct);
        try {
            this.assertGlobalBinningProductIsOk(targetProduct, targetFile, obs1, obs2, obs3, obs4, obs5);
        }
        finally {
            targetProduct.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalBinningViaGPT_FilePattern() throws Exception {
        float obs1 = 0.2f;
        float obs2 = 0.4f;
        float obs3 = 0.6f;
        float obs4 = 0.8f;
        float obs5 = 1.0f;
        File parameterFile = new File(this.getClass().getResource("BinningParamsLocal_FilePattern.xml").toURI());
        String fileName = "output.dim";
        File targetFile = BinningOpTest.getTestFile("output.dim");
        File sourceFile1 = BinningOpTest.getTestFile("obs1.dim");
        File sourceFile2 = BinningOpTest.getTestFile("obs2.dim");
        File sourceFile3 = BinningOpTest.getTestFile("obs3.dim");
        File sourceFile4 = BinningOpTest.getTestFile("obs4.dim");
        File sourceFile5 = BinningOpTest.getTestFile("obs5.dim");
        ProductIO.writeProduct((Product)BinningOpTest.createSourceProduct(1, obs1), (File)sourceFile1, (String)"BEAM-DIMAP", (boolean)false);
        ProductIO.writeProduct((Product)BinningOpTest.createSourceProduct(2, obs2), (File)sourceFile2, (String)"BEAM-DIMAP", (boolean)false);
        ProductIO.writeProduct((Product)BinningOpTest.createSourceProduct(3, obs3), (File)sourceFile3, (String)"BEAM-DIMAP", (boolean)false);
        ProductIO.writeProduct((Product)BinningOpTest.createSourceProduct(4, obs4), (File)sourceFile4, (String)"BEAM-DIMAP", (boolean)false);
        ProductIO.writeProduct((Product)BinningOpTest.createSourceProduct(5, obs5), (File)sourceFile5, (String)"BEAM-DIMAP", (boolean)false);
        GPT.run((String[])new String[]{"Binning", "-p", parameterFile.getPath(), "-t", targetFile.getPath()});
        Assert.assertTrue((boolean)targetFile.exists());
        Product targetProduct = ProductIO.readProduct((File)targetFile);
        Assert.assertNotNull((Object)targetProduct);
        try {
            this.assertLocalBinningProductIsOk(targetProduct, targetFile, obs1, obs2, obs3, obs4, obs5);
        }
        finally {
            targetProduct.dispose();
        }
    }

    @Test
    public void testCreateGeoCodingProductFilter() throws Exception {
        BinningOp binningOp = this.createBinningOp();
        binningOp.setTimeFilterMethod(BinningOp.TimeFilterMethod.NONE);
        Assert.assertNotNull((Object)BinningOp.createSourceProductFilter(null, null, null, null));
    }

    @Test
    public void testCreateSpatialDataDayFilter() throws Exception {
        DataPeriod dataPeriod = TestUtils.createSpatialDataPeriod();
        Product product1 = TestUtils.createProduct(dataPeriod, DataPeriod.Membership.PREVIOUS_PERIODS, DataPeriod.Membership.PREVIOUS_PERIODS);
        Product product2 = TestUtils.createProduct(dataPeriod, DataPeriod.Membership.PREVIOUS_PERIODS, DataPeriod.Membership.CURRENT_PERIOD);
        Product product3 = TestUtils.createProduct(dataPeriod, DataPeriod.Membership.PREVIOUS_PERIODS, DataPeriod.Membership.SUBSEQUENT_PERIODS);
        Product product4 = TestUtils.createProduct(dataPeriod, DataPeriod.Membership.CURRENT_PERIOD, DataPeriod.Membership.CURRENT_PERIOD);
        Product product5 = TestUtils.createProduct(dataPeriod, DataPeriod.Membership.CURRENT_PERIOD, DataPeriod.Membership.SUBSEQUENT_PERIODS);
        Product product6 = TestUtils.createProduct(dataPeriod, DataPeriod.Membership.SUBSEQUENT_PERIODS, DataPeriod.Membership.SUBSEQUENT_PERIODS);
        BinningOp binningOp = this.createBinningOp();
        binningOp.setTimeFilterMethod(BinningOp.TimeFilterMethod.SPATIOTEMPORAL_DATA_DAY);
        BinningProductFilter filter = BinningOp.createSourceProductFilter((DataPeriod)dataPeriod, null, null, null);
        Assert.assertSame(SpatialDataDaySourceProductFilter.class, filter.getClass());
        Assert.assertFalse((boolean)filter.accept(product1));
        Assert.assertTrue((boolean)filter.accept(product2));
        Assert.assertTrue((boolean)filter.accept(product3));
        Assert.assertTrue((boolean)filter.accept(product4));
        Assert.assertTrue((boolean)filter.accept(product5));
        Assert.assertFalse((boolean)filter.accept(product6));
    }

    @Test
    public void testParseStartDateUtc() {
        ProductData.UTC utc = BinningOp.parseStartDateUtc((String)"2012-05-22");
        Assert.assertEquals((Object)"22-MAY-2012 00:00:00.000000", (Object)utc.format());
        utc = BinningOp.parseStartDateUtc((String)"2012-05-22 11:22:33");
        Assert.assertEquals((Object)"22-MAY-2012 11:22:33.000000", (Object)utc.format());
    }

    @Test
    public void testParseDateUtc_errorCase() {
        try {
            BinningOp.parseStartDateUtc((String)"yesterday evening");
            Assert.fail((String)"OperatorException expected");
        }
        catch (OperatorException oe) {
            String expected = "Error while parsing start date parameter 'yesterday evening': Unparseable date: \"yesterday evening\"";
            Assert.assertEquals((Object)expected, (Object)oe.getMessage());
        }
    }

    @Test
    public void testBinningSetsCorrectStartAndStopTimesFromProductTimes() throws Exception {
        File targetFile = BinningOpTest.getTestFile("target-1.dim");
        float obs1 = 0.2f;
        BinningOp binningOp = this.createBinningOp();
        JtsGeometryConverter geometryConverter = new JtsGeometryConverter();
        Product sourceProduct = BinningOpTest.createSourceProduct(1, obs1);
        sourceProduct.setStartTime(ProductData.UTC.parse((String)"02-JAN-2002 11:30:25"));
        sourceProduct.setEndTime(ProductData.UTC.parse((String)"02-JAN-2002 12:28:19"));
        binningOp.setSourceProducts(new Product[]{sourceProduct});
        binningOp.setAggregatorConfigs(new AggregatorConfig[]{BinningOpTest.chlAgg(), BinningOpTest.p70Agg()});
        binningOp.setNumRows(180);
        binningOp.setMaskExpr("true");
        binningOp.setOutputFile(targetFile.getPath());
        binningOp.setOutputType("Product");
        binningOp.setOutputFormat("BEAM-DIMAP");
        binningOp.setRegion(geometryConverter.parse("POLYGON ((-180 -90, -180 90, 180 90, 180 -90, -180 -90))"));
        Product targetProduct = binningOp.getTargetProduct();
        Assert.assertNotNull((Object)targetProduct);
        targetProduct.dispose();
    }

    @Test
    public void testCreateConfig() throws ParseException {
        BinningOp binningOp = this.createBinningOp();
        binningOp.setNumRows(19);
        binningOp.setSuperSampling(Integer.valueOf(20));
        binningOp.setMaskExpr("twenty-one");
        binningOp.setVariableConfigs(new VariableConfig[]{new VariableConfig("yeah", "wow")});
        binningOp.setAggregatorConfigs(new AggregatorConfig[]{new AggregatorMinMax.Config()});
        binningOp.setPostProcessorConfig((CellProcessorConfig)new TestCellProcessorConfig());
        binningOp.setMinDataHour(Double.valueOf(25.0));
        binningOp.setMetadataAggregatorName("clump");
        binningOp.setStartDateTime("start-me-up");
        binningOp.setPeriodDuration(Double.valueOf(26.0));
        binningOp.setTimeFilterMethod(BinningOp.TimeFilterMethod.TIME_RANGE);
        binningOp.setOutputFile("a_file");
        WKTReader wktReader = new WKTReader();
        binningOp.setRegion(wktReader.read("POLYGON((10 10, 15 10, 15 12, 10 12, 10 10))"));
        BinningConfig config = binningOp.createConfig();
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((long)19L, (long)config.getNumRows());
        Assert.assertEquals((long)20L, (long)config.getSuperSampling().intValue());
        Assert.assertEquals((Object)"twenty-one", (Object)config.getMaskExpr());
        VariableConfig[] variableConfigs = config.getVariableConfigs();
        Assert.assertEquals((long)1L, (long)variableConfigs.length);
        Assert.assertEquals((Object)"wow", (Object)variableConfigs[0].getExpr());
        AggregatorConfig[] aggregatorConfigs = config.getAggregatorConfigs();
        Assert.assertEquals((long)1L, (long)aggregatorConfigs.length);
        Assert.assertEquals((Object)"MIN_MAX", (Object)aggregatorConfigs[0].getName());
        Assert.assertNotNull((Object)config.getPostProcessorConfig());
        Assert.assertEquals((double)25.0, (double)config.getMinDataHour(), (double)1.0E-8);
        Assert.assertEquals((Object)"clump", (Object)config.getMetadataAggregatorName());
        Assert.assertEquals((Object)"start-me-up", (Object)config.getStartDateTime());
        Assert.assertEquals((double)26.0, (double)config.getPeriodDuration(), (double)1.0E-8);
        Assert.assertEquals((Object)BinningOp.TimeFilterMethod.TIME_RANGE, (Object)config.getTimeFilterMethod());
        Assert.assertEquals((Object)"a_file", (Object)config.getOutputFile());
        Assert.assertEquals((Object)"POLYGON ((10 10, 15 10, 15 12, 10 12, 10 10))", (Object)config.getRegion().toString());
    }

    private BinningOp createBinningOp() {
        BinningOp binningOp = new BinningOp();
        binningOp.setParameterDefaultValues();
        return binningOp;
    }

    private void assertGlobalBinningProductIsOk(Product targetProduct, File location, float obs1, float obs2, float obs3, float obs4, float obs5) throws IOException {
        this.assertTargetProductIsOk(targetProduct, location, obs1, obs2, obs3, obs4, obs5, 360, 180, 179, 87);
    }

    private void assertLocalBinningProductIsOk(Product targetProduct, File location, float obs1, float obs2, float obs3, float obs4, float obs5) throws IOException {
        this.assertTargetProductIsOk(targetProduct, location, obs1, obs2, obs3, obs4, obs5, 4, 4, 0, 0);
    }

    private void assertTargetProductIsOk(Product targetProduct, File location, float obs1, float obs2, float obs3, float obs4, float obs5, int sceneRasterWidth, int sceneRasterHeight, int x0, int y0) throws IOException {
        int w = 4;
        int h = 4;
        int _o_ = -1;
        float _x_ = Float.NaN;
        Assert.assertEquals((Object)location, (Object)targetProduct.getFileLocation());
        Assert.assertEquals((long)sceneRasterWidth, (long)targetProduct.getSceneRasterWidth());
        Assert.assertEquals((long)sceneRasterHeight, (long)targetProduct.getSceneRasterHeight());
        Assert.assertNotNull((Object)targetProduct.getStartTime());
        Assert.assertNotNull((Object)targetProduct.getEndTime());
        Assert.assertEquals((Object)"01-JAN-2002 00:00:00.000000", (Object)targetProduct.getStartTime().format());
        Assert.assertEquals((Object)"11-JAN-2002 00:00:00.000000", (Object)targetProduct.getEndTime().format());
        Assert.assertNotNull((Object)targetProduct.getBand("num_obs"));
        Assert.assertEquals((long)12L, (long)targetProduct.getBand("num_obs").getDataType());
        Assert.assertNotNull((Object)targetProduct.getBand("num_passes"));
        Assert.assertNotNull((Object)targetProduct.getBand("chl_mean"));
        Assert.assertNotNull((Object)targetProduct.getBand("chl_sigma"));
        Assert.assertNotNull((Object)targetProduct.getBand("chl_p70"));
        Assert.assertEquals((double)-1.0, (double)targetProduct.getBand("num_obs").getNoDataValue(), (double)1.0E-10);
        Assert.assertEquals((double)-1.0, (double)targetProduct.getBand("num_passes").getNoDataValue(), (double)1.0E-10);
        Assert.assertEquals((double)Double.NaN, (double)targetProduct.getBand("chl_mean").getNoDataValue(), (double)1.0E-10);
        Assert.assertEquals((double)Double.NaN, (double)targetProduct.getBand("chl_sigma").getNoDataValue(), (double)1.0E-10);
        Assert.assertEquals((double)Double.NaN, (double)targetProduct.getBand("chl_p70").getNoDataValue(), (double)1.0E-10);
        int nob = 5;
        int[] expectedNobs = new int[]{-1, -1, -1, -1, -1, 5, 5, -1, -1, 5, 5, -1, -1, -1, -1, -1};
        int[] actualNobs = new int[16];
        targetProduct.getBand("num_obs").getSourceImage().getData().getPixels(x0, y0, 4, 4, actualNobs);
        Assert.assertArrayEquals((int[])expectedNobs, (int[])actualNobs);
        int npa = 5;
        int[] expectedNpas = new int[]{-1, -1, -1, -1, -1, 5, 5, -1, -1, 5, 5, -1, -1, -1, -1, -1};
        int[] actualNpas = new int[16];
        targetProduct.getBand("num_passes").getSourceImage().getData().getPixels(x0, y0, 4, 4, actualNpas);
        Assert.assertArrayEquals((int[])expectedNpas, (int[])actualNpas);
        float mea = (obs1 + obs2 + obs3 + obs4 + obs5) / 5.0f;
        float[] expectedMeas = new float[]{Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, mea, mea, Float.NaN, Float.NaN, mea, mea, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN};
        float[] actualMeas = new float[16];
        targetProduct.getBand("chl_mean").getSourceImage().getData().getPixels(x0, y0, 4, 4, actualMeas);
        Assert.assertArrayEquals((float[])expectedMeas, (float[])actualMeas, (float)1.0E-4f);
        float sig = (float)Math.sqrt((obs1 * obs1 + obs2 * obs2 + obs3 * obs3 + obs4 * obs4 + obs5 * obs5) / 5.0f - mea * mea);
        float[] expectedSigs = new float[]{Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, sig, sig, Float.NaN, Float.NaN, sig, sig, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN};
        float[] actualSigs = new float[16];
        targetProduct.getBand("chl_sigma").getSourceImage().getData().getPixels(x0, y0, 4, 4, actualSigs);
        Assert.assertArrayEquals((float[])expectedSigs, (float[])actualSigs, (float)1.0E-4f);
        float p70 = AggregatorPercentile.computePercentile((int)70, (float[])new float[]{obs1, obs2, obs3, obs4, obs5});
        float[] expectedP70 = new float[]{Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, p70, p70, Float.NaN, Float.NaN, p70, p70, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN};
        float[] actualP70 = new float[16];
        targetProduct.getBand("chl_p70").getSourceImage().getData().getPixels(x0, y0, 4, 4, actualP70);
        Assert.assertArrayEquals((float[])expectedP70, (float[])actualP70, (float)1.0E-4f);
    }

    private static AggregatorPercentile.Config p70Agg() {
        return new AggregatorPercentile.Config(null, "chl", 70);
    }

    private static AggregatorAverage.Config chlAgg() {
        return new AggregatorAverage.Config("chl");
    }

    static Product createSourceProduct(int sourceProductCounter, float value) {
        Product p = new Product("P" + sourceProductCounter, "T", 2, 2);
        TiePointGrid latitude = new TiePointGrid("latitude", 2, 2, 0.5, 0.5, 1.0, 1.0, new float[]{1.0f, 1.0f, 0.0f, 0.0f});
        TiePointGrid longitude = new TiePointGrid("longitude", 2, 2, 0.5, 0.5, 1.0, 1.0, new float[]{0.0f, 1.0f, 0.0f, 1.0f});
        p.addTiePointGrid(latitude);
        p.addTiePointGrid(longitude);
        p.setSceneGeoCoding((GeoCoding)new TiePointGeoCoding(latitude, longitude));
        p.addBand("chl", value + "");
        return p;
    }

    static File getTestFile(String fileName) {
        return new File(TESTDATA_DIR, fileName);
    }

    static {
        GPF.getDefaultInstance().getOperatorSpiRegistry().loadOperatorSpis();
    }

    private static class TestCellProcessorConfig
    extends CellProcessorConfig {
        private TestCellProcessorConfig() {
        }
    }
}

