/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import java.io.File;
import java.util.regex.Pattern;
import org.esa.snap.binning.operator.BinningOp;
import org.esa.snap.binning.operator.BinningOpTest;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.util.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BinningOpRobustnessTest {
    @Before
    public void setUp() throws Exception {
        BinningOpTest.TESTDATA_DIR.mkdir();
    }

    @After
    public void tearDown() throws Exception {
        FileUtils.deleteTree((File)BinningOpTest.TESTDATA_DIR);
    }

    @Test
    public void testNoSourceProductSet() throws Exception {
        BinningOp binningOp = new BinningOp();
        this.testThatOperatorExceptionIsThrown(binningOp, ".*or parameter 'sourceProductPaths' must be.*");
    }

    @Test
    public void testNumRowsNotSet() throws Exception {
        BinningOp binningOp = new BinningOp();
        binningOp.setSourceProduct(BinningOpTest.createSourceProduct(1, 0.3f));
        this.testThatOperatorExceptionIsThrown(binningOp, ".*parameter 'numRows'.*");
    }

    @Test
    public void testBinningConfigNotSet() throws Exception {
        BinningOp binningOp = new BinningOp();
        binningOp.setSourceProduct(BinningOpTest.createSourceProduct(1, 0.3f));
        binningOp.setNumRows(2);
        this.testThatOperatorExceptionIsThrown(binningOp, "No aggregators have been defined");
    }

    private void testThatOperatorExceptionIsThrown(BinningOp binningOp, String regex) {
        String message = "OperatorException expected with message regex: " + regex;
        try {
            binningOp.getTargetProduct();
            Assert.fail((String)message);
        }
        catch (OperatorException e) {
            System.out.println("e = " + (Object)((Object)e));
            Assert.assertTrue((String)(message + ", got [" + e.getMessage() + "]"), (boolean)Pattern.matches(regex, e.getMessage()));
        }
    }
}

