/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.cellprocessor;

import org.esa.snap.binning.MyVariableContext;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.Vector;
import org.esa.snap.binning.WritableVector;
import org.esa.snap.binning.aggregators.AggregatorTestUtils;
import org.esa.snap.binning.cellprocessor.FeatureSelection;
import org.esa.snap.binning.support.VectorImpl;
import org.junit.Assert;
import org.junit.Test;

public class FeatureSelectionTest {
    @Test
    public void testSelection() throws Exception {
        MyVariableContext variableContext = new MyVariableContext("A", "B", "C");
        FeatureSelection selection = new FeatureSelection((VariableContext)variableContext, new String[]{"B"});
        Object[] outputFeatureNames = selection.getOutputFeatureNames();
        Assert.assertArrayEquals((Object[])new String[]{"B"}, (Object[])outputFeatureNames);
        VectorImpl input = AggregatorTestUtils.vec(0.1f, 0.2f, 0.3f);
        VectorImpl output = AggregatorTestUtils.vec(Float.NaN);
        selection.compute((Vector)input, (WritableVector)output);
        Assert.assertEquals((float)0.2f, (float)output.get(0), (float)1.0E-5f);
    }

    @Test
    public void testSelectionWithRenaming() throws Exception {
        MyVariableContext variableContext = new MyVariableContext("A", "B", "C");
        FeatureSelection selection = new FeatureSelection((VariableContext)variableContext, new String[]{"B", "D=A"});
        Object[] outputFeatureNames = selection.getOutputFeatureNames();
        Assert.assertArrayEquals((Object[])new String[]{"B", "D"}, (Object[])outputFeatureNames);
        VectorImpl input = AggregatorTestUtils.vec(0.1f, 0.2f, 0.3f);
        VectorImpl output = AggregatorTestUtils.vec(Float.NaN, Float.NaN);
        selection.compute((Vector)input, (WritableVector)output);
        Assert.assertEquals((float)0.2f, (float)output.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)0.1f, (float)output.get(1), (float)1.0E-5f);
    }
}

