/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning;

import org.esa.snap.binning.Aggregator;
import org.esa.snap.binning.BinManager;
import org.esa.snap.binning.CellProcessorConfig;
import org.esa.snap.binning.MyVariableContext;
import org.esa.snap.binning.SpatialBin;
import org.esa.snap.binning.TemporalBin;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.aggregators.AggregatorAverage;
import org.esa.snap.binning.aggregators.AggregatorAverageML;
import org.esa.snap.binning.aggregators.AggregatorMinMax;
import org.esa.snap.binning.aggregators.AggregatorOnMaxSet;
import org.esa.snap.binning.cellprocessor.FeatureSelection;
import org.junit.Assert;
import org.junit.Test;

public class BinManagerTest {
    @Test
    public void testBinCreation() {
        VariableContext variableContext = this.createVariableContext();
        BinManager binManager = new BinManager(variableContext, new Aggregator[]{new AggregatorAverage(variableContext, "c", 0.0), new AggregatorAverageML(variableContext, "b", 0.5), new AggregatorMinMax(variableContext, "a", "a"), new AggregatorOnMaxSet(variableContext, "c", "c", new String[]{"a", "b"})});
        Assert.assertEquals((long)4L, (long)binManager.getAggregatorCount());
        SpatialBin sbin = binManager.createSpatialBin(42L);
        Assert.assertEquals((long)42L, (long)sbin.getIndex());
        Assert.assertEquals((long)10L, (long)sbin.getFeatureValues().length);
        TemporalBin tbin = binManager.createTemporalBin(42L);
        Assert.assertEquals((long)42L, (long)tbin.getIndex());
        Assert.assertEquals((long)12L, (long)tbin.getFeatureValues().length);
    }

    @Test
    public void testNameUnifying() throws Exception {
        BinManager.NameUnifier nameUnifier = new BinManager.NameUnifier();
        Assert.assertEquals((Object)"expression_p90", (Object)nameUnifier.unifyName("expression_p90"));
        Assert.assertEquals((Object)"expression_p90_1", (Object)nameUnifier.unifyName("expression_p90"));
        Assert.assertEquals((Object)"expression_p90_2", (Object)nameUnifier.unifyName("expression_p90"));
        Assert.assertEquals((Object)"expression_p50", (Object)nameUnifier.unifyName("expression_p50"));
        Assert.assertEquals((Object)"expression_p50_1", (Object)nameUnifier.unifyName("expression_p50"));
    }

    @Test
    public void testGetResultFeatureNames_noPostProcessor() {
        VariableContext variableContext = this.createVariableContext();
        BinManager binManager = new BinManager(variableContext, new Aggregator[]{new AggregatorAverage(variableContext, "d", 0.0)});
        String[] resultFeatureNames = binManager.getResultFeatureNames();
        Assert.assertEquals((long)2L, (long)resultFeatureNames.length);
        Assert.assertEquals((Object)"d_mean", (Object)resultFeatureNames[0]);
        Assert.assertEquals((Object)"d_sigma", (Object)resultFeatureNames[1]);
    }

    @Test
    public void testGetResultFeatureCount_noPostProcessor() {
        VariableContext variableContext = this.createVariableContext();
        BinManager binManager = new BinManager(variableContext, new Aggregator[]{new AggregatorAverageML(variableContext, "e", 0.5)});
        int featureCount = binManager.getResultFeatureCount();
        Assert.assertEquals((long)4L, (long)featureCount);
    }

    @Test
    public void testGetResultFeatureNames_withPostProcessor() {
        VariableContext variableContext = this.createVariableContext();
        FeatureSelection.Config ppSelection = new FeatureSelection.Config(new String[]{"out_min"});
        BinManager binManager = new BinManager(variableContext, (CellProcessorConfig)ppSelection, new Aggregator[]{new AggregatorMinMax(variableContext, "e", "out")});
        String[] resultFeatureNames = binManager.getResultFeatureNames();
        Assert.assertEquals((long)1L, (long)resultFeatureNames.length);
        Assert.assertEquals((Object)"out_min", (Object)resultFeatureNames[0]);
    }

    @Test
    public void testGetResultFeatureCount_withPostProcessor_targetName() {
        VariableContext variableContext = this.createVariableContext();
        FeatureSelection.Config ppSelection = new FeatureSelection.Config(new String[]{"out_max"});
        BinManager binManager = new BinManager(variableContext, (CellProcessorConfig)ppSelection, new Aggregator[]{new AggregatorMinMax(variableContext, "f", "out")});
        int featureCount = binManager.getResultFeatureCount();
        Assert.assertEquals((long)1L, (long)featureCount);
    }

    @Test
    public void testGetResultFeatureCount_withPostProcessor() {
        VariableContext variableContext = this.createVariableContext();
        FeatureSelection.Config ppSelection = new FeatureSelection.Config(new String[]{"f_max"});
        BinManager binManager = new BinManager(variableContext, (CellProcessorConfig)ppSelection, new Aggregator[]{new AggregatorMinMax(variableContext, "f", "f")});
        int featureCount = binManager.getResultFeatureCount();
        Assert.assertEquals((long)1L, (long)featureCount);
    }

    private VariableContext createVariableContext() {
        return new MyVariableContext("a", "b", "c");
    }
}

