/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning;

import java.util.List;
import org.esa.snap.binning.Aggregator;
import org.esa.snap.binning.AggregatorConfig;
import org.esa.snap.binning.AggregatorDescriptor;
import org.esa.snap.binning.MyVariableContext;
import org.esa.snap.binning.TypedDescriptorsRegistry;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.aggregators.AggregatorAverage;
import org.esa.snap.binning.aggregators.AggregatorMinMax;
import org.esa.snap.binning.aggregators.AggregatorOnMaxSet;
import org.esa.snap.binning.aggregators.AggregatorPercentile;
import org.junit.Assert;
import org.junit.Test;

public class AggregatorDescriptorRegistryTest {
    private MyVariableContext ctx = new MyVariableContext("x", "y", "z");

    @Test
    public void testDefaultAggregatorIsRegistered_Average() {
        AggregatorDescriptor descriptor = this.assertRegistered("AVG");
        Aggregator aggregator = descriptor.createAggregator((VariableContext)this.ctx, (AggregatorConfig)new AggregatorAverage.Config("x", "target", Double.valueOf(0.2), Boolean.valueOf(false), Boolean.valueOf(false)));
        Assert.assertNotNull((Object)aggregator);
        Assert.assertEquals(AggregatorAverage.class, aggregator.getClass());
    }

    @Test
    public void testDefaultAggregatorIsRegistered_MinMax() {
        AggregatorDescriptor descriptor = this.assertRegistered("MIN_MAX");
        Aggregator aggregator = descriptor.createAggregator((VariableContext)this.ctx, (AggregatorConfig)new AggregatorMinMax.Config("x", "y"));
        Assert.assertNotNull((Object)aggregator);
        Assert.assertEquals(AggregatorMinMax.class, aggregator.getClass());
    }

    @Test
    public void testDefaultAggregatorIsRegistered_Percentile() {
        AggregatorDescriptor descriptor = this.assertRegistered("PERCENTILE");
        Aggregator aggregator = descriptor.createAggregator((VariableContext)this.ctx, (AggregatorConfig)new AggregatorPercentile.Config("x", "y", 75));
        Assert.assertNotNull((Object)aggregator);
        Assert.assertEquals(AggregatorPercentile.class, aggregator.getClass());
    }

    @Test
    public void testDefaultAggregatorIsRegistered_OnMaxSet() {
        AggregatorDescriptor descriptor = this.assertRegistered("ON_MAX_SET");
        AggregatorOnMaxSet.Config config = new AggregatorOnMaxSet.Config("target", "x", new String[]{"y", "z"});
        Aggregator aggregator = descriptor.createAggregator((VariableContext)this.ctx, (AggregatorConfig)config);
        Assert.assertNotNull((Object)aggregator);
        Assert.assertEquals(AggregatorOnMaxSet.class, aggregator.getClass());
    }

    @Test
    public void testGetAllRegisteredAggregatorDescriptors() throws Exception {
        TypedDescriptorsRegistry registry = TypedDescriptorsRegistry.getInstance();
        List aggregatorDescriptors = registry.getDescriptors(AggregatorDescriptor.class);
        Assert.assertEquals((long)4L, (long)aggregatorDescriptors.size());
    }

    private AggregatorDescriptor assertRegistered(String name) {
        TypedDescriptorsRegistry registry = TypedDescriptorsRegistry.getInstance();
        AggregatorDescriptor descriptor = (AggregatorDescriptor)registry.getDescriptor(AggregatorDescriptor.class, name);
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)name, (Object)descriptor.getName());
        return descriptor;
    }
}

