/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.arcbin;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.util.Map;
import junit.framework.Assert;
import org.esa.snap.dataio.arcbin.LegendFile;
import org.junit.Test;

public class XlsReadingTest {
    @Test
    public void testFirstCreateXlsDescriptionMap() throws URISyntaxException, FileNotFoundException {
        File file = new File(this.getClass().getResource("test_1_legend.xls").toURI());
        Assert.assertNotNull((Object)file);
        file = LegendFile.findXlsLegendFile((File)file);
        Assert.assertNotNull((Object)file);
        file = new File(this.getClass().getResource("test_1_legend.xls").toURI());
        Map map = LegendFile.createXlsDescriptionMap((File)file);
        Assert.assertEquals((String)"broadleaved evergreen forest", (String)((String)map.get(3)));
        Assert.assertEquals((String)"seaside wet lands", (String)((String)map.get(7)));
        Assert.assertEquals((String)"meadow", (String)((String)map.get(12)));
        Assert.assertEquals((String)"dersert", (String)((String)map.get(20)));
        Assert.assertEquals((String)"Forest Mosaic / Degraded Forest", (String)((String)map.get(24)));
    }

    @Test
    public void testSecondCreateXlsDescriptionMap() throws URISyntaxException, FileNotFoundException {
        File file = new File(this.getClass().getResource("test_2_legend.xls").toURI());
        Assert.assertNotNull((Object)file);
        file = LegendFile.findXlsLegendFile((File)file);
        Assert.assertNotNull((Object)file);
        file = new File(this.getClass().getResource("test_2_legend.xls").toURI());
        Map map = LegendFile.createXlsDescriptionMap((File)file);
        Assert.assertEquals((String)"", (String)((String)map.get(0)));
        Assert.assertEquals((String)"Open forest (Eucalyptus)", (String)((String)map.get(3)));
        Assert.assertEquals((String)"Grasslands with sparse shrubs (A", (String)((String)map.get(7)));
        Assert.assertEquals((String)"Croplands", (String)((String)map.get(9)));
        Assert.assertEquals((String)"Cities", (String)((String)map.get(12)));
    }

    @Test
    public void testThirdCreateXlsDescriptionMap() throws URISyntaxException, FileNotFoundException {
        File file = new File(this.getClass().getResource("test_3_legend.xls").toURI());
        Assert.assertNotNull((Object)file);
        file = LegendFile.findXlsLegendFile((File)file);
        Assert.assertNotNull((Object)file);
        file = new File(this.getClass().getResource("test_3_legend.xls").toURI());
        Map map = LegendFile.createXlsDescriptionMap((File)file);
        Assert.assertEquals((String)"Tropical and sub-tropical mountain forests , broadleaved, evergreen >1000m", (String)((String)map.get(3)));
        Assert.assertEquals((String)"Swamp forest and woodlands", (String)((String)map.get(7)));
        Assert.assertEquals((String)"Deciduous shrubland / Mosiacs of deciudous shrubcover and cropping", (String)((String)map.get(10)));
        Assert.assertEquals((String)"Cropland", (String)((String)map.get(18)));
        Assert.assertEquals((String)"Urban Areas", (String)((String)map.get(24)));
    }
}

