/*
 * Decompiled with CFR 0.152.
 */
package be.abeel.util;

import be.abeel.graphics.GraphicsFileExport;
import be.abeel.jfreechart.JFreeChartWrapper;
import be.abeel.util.FrequencyMap;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYBarDataset;
import org.jfree.data.xy.XYDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrequencyMapUtils {
    public static void plot(FrequencyMap freq, String file) {
        FrequencyMapUtils.plot(freq, file, false);
    }

    public static void plot(FrequencyMap freq, String file, boolean countNormalization) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        Iterator i$ = freq.keySet().iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            if (i > max) {
                max = i;
            }
            if (i >= min) continue;
            min = i;
        }
        FrequencyMapUtils.plot(freq, file, countNormalization, min, max);
    }

    public static void plot(FrequencyMap freq, String file, boolean countNormalization, int lower, int upper) {
        FrequencyMapUtils.plot("Frequency map", freq, file, countNormalization, lower, upper);
    }

    public static void plot(String title, FrequencyMap freq, String file, boolean countNormalization, int lower, int upper) {
        int i;
        double[][] data = new double[2][freq.keySet().size()];
        int index = 0;
        Iterator i$ = freq.keySet().iterator();
        while (i$.hasNext()) {
            i = (Integer)i$.next();
            data[0][index] = i;
            data[1][index] = ((Integer)freq.get(i)).intValue();
            ++index;
        }
        if (countNormalization) {
            int totalCount = freq.totalCount();
            i = 0;
            while (i < data[1].length) {
                double[] dArray = data[1];
                int n = i++;
                dArray[n] = dArray[n] / (double)totalCount;
            }
        }
        DefaultXYDataset set = new DefaultXYDataset();
        set.addSeries((Comparable)((Object)"freq"), data);
        JFreeChart chart = ChartFactory.createXYBarChart((String)title, (String)"bin", (boolean)false, (String)"count", (IntervalXYDataset)new XYBarDataset((XYDataset)set, 1.0), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        if (countNormalization) {
            chart.getXYPlot().getRangeAxis().setRange(0.0, 1.0);
        }
        chart.getXYPlot().getDomainAxis().setRange((double)lower, (double)upper);
        GraphicsFileExport.exportPNG(new JFreeChartWrapper(chart), file, 800, 600);
    }

    public static void plot(String title, List<FrequencyMap> list, String file, boolean countNormalization, int lower, int upper, String[] labels) {
        int count = 0;
        DefaultXYDataset set = new DefaultXYDataset();
        for (FrequencyMap freq : list) {
            int i;
            double[][] data = new double[2][freq.keySet().size()];
            int index = 0;
            Iterator i$ = freq.keySet().iterator();
            while (i$.hasNext()) {
                i = (Integer)i$.next();
                data[0][index] = i;
                data[1][index] = ((Integer)freq.get(i)).intValue();
                ++index;
            }
            if (countNormalization) {
                int totalCount = freq.totalCount();
                i = 0;
                while (i < data[1].length) {
                    double[] dArray = data[1];
                    int n = i++;
                    dArray[n] = dArray[n] / (double)totalCount;
                }
            }
            set.addSeries((Comparable)((Object)(labels != null ? labels[count++] : "freq" + count++)), data);
        }
        JFreeChart chart = ChartFactory.createXYBarChart((String)title, (String)"bin", (boolean)false, (String)"count", (IntervalXYDataset)new XYBarDataset((XYDataset)set, 1.0), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        if (countNormalization) {
            chart.getXYPlot().getRangeAxis().setRange(0.0, 1.0);
        }
        chart.getXYPlot().getDomainAxis().setRange((double)lower, (double)upper);
        GraphicsFileExport.exportPNG(new JFreeChartWrapper(chart), file, 800, 600);
    }
}

