/*
 * Decompiled with CFR 0.152.
 */
package be.abeel.gui;

import be.abeel.gui.GridBagPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class MemoryWidget
extends JLabel {
    private static final long serialVersionUID = -3984980155889057580L;
    private static long available;

    public static long getAvailable() {
        return available;
    }

    public MemoryWidget() {
        super.setToolTipText("Memory used/available");
        Thread t = new Thread(new Runnable(){

            public void run() {
                while (true) {
                    MemoryWidget.this.repaint();
                    try {
                        Thread.sleep(5000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
        t.setDaemon(true);
        t.start();
    }

    public void paintComponent(Graphics g) {
        MemoryUsage mu = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        available = mu.getMax() - mu.getUsed();
        int width = this.getSize().width;
        int used = (int)((double)mu.getUsed() / (double)mu.getMax() * (double)width);
        int comm = (int)((double)mu.getCommitted() / (double)mu.getMax() * (double)width);
        mu.toString();
        g.setColor(Color.green);
        g.fillRect(0, 0, width, this.getSize().height);
        g.setColor(Color.orange);
        g.fillRect(0, 0, comm, this.getSize().height);
        g.setColor(Color.red);
        g.fillRect(0, 0, used, this.getSize().height);
        StringBuffer buf = new StringBuffer();
        buf.append((mu.getUsed() >> 20) + " / ");
        buf.append((mu.getMax() >> 20) + " (Mb)");
        g.setColor(Color.black);
        this.drawCenteredString(buf.toString(), width, this.getSize().height, g);
    }

    public void drawCenteredString(String s, int w, int h, Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int x = (w - fm.stringWidth(s)) / 2;
        int y = fm.getAscent() + (h - (fm.getAscent() + fm.getDescent())) / 2;
        g.drawString(s, x, y);
    }

    public static void main(String[] args) {
        JFrame window = new JFrame("Test MemoryWidget");
        window.setDefaultCloseOperation(3);
        window.getContentPane().add(new MemoryWidget());
        GridBagPanel gp = new GridBagPanel();
        gp.add((Component)new MemoryWidget(), gp.gc);
        window.setPreferredSize(new Dimension(100, 50));
        window.pack();
        window.setVisible(true);
    }
}

