/*
 * Decompiled with CFR 0.152.
 */
package be.abeel.bioinformatics.dnaproperties;

import be.abeel.bioinformatics.dnaproperties.ConversionMap;
import be.abeel.bioinformatics.dnaproperties.DNAProperty;

public class ConversionMapDNAProperty
extends DNAProperty {
    private ConversionMap map = null;
    private ConversionMap normalizedMap = null;

    protected ConversionMapDNAProperty(String name) {
        super(name);
        String file = name.toLowerCase() + ".tsv";
        this.map = ConversionMap.create(file);
        this.normalizedMap = ConversionMap.create(file);
        this.normalizedMap.normalize();
    }

    public int length() {
        return this.map.length();
    }

    public double value(String sequence) {
        return this.value(ConversionMap.lowercase(sequence.getBytes()), this.map);
    }

    public double normalizedValue(String sequence) {
        return this.value(ConversionMap.lowercase(sequence.getBytes()), this.normalizedMap);
    }

    private double value(byte[] seq, ConversionMap localMap) {
        int length = localMap.length();
        int numberOfValues = seq.length - length + 1;
        if (seq.length < length) {
            System.err.println("Offending sequence: \"" + new String(seq) + "\"");
            throw new RuntimeException("The sequence is too short to be converted");
        }
        double output = 0.0;
        for (int i = 0; i < numberOfValues; ++i) {
            if (length == 2) {
                output += localMap.get(ConversionMap.translate(seq[i], seq[i + 1])).doubleValue();
                continue;
            }
            if (length == 3) {
                output += localMap.get(ConversionMap.translate(seq[i], seq[i + 1], seq[i + 2])).doubleValue();
                continue;
            }
            byte[] tmp = new byte[length];
            System.arraycopy(seq, i, tmp, 0, length);
            output += localMap.get(ConversionMap.translate(tmp)).doubleValue();
        }
        return output / (double)numberOfValues;
    }

    public double[] profile(String sequence) {
        return this.profile(ConversionMap.lowercase(sequence.getBytes()), this.map);
    }

    public double[] normalizedProfile(String sequence) {
        return this.profile(ConversionMap.lowercase(sequence.getBytes()), this.normalizedMap);
    }

    private double[] profile(byte[] seq, ConversionMap localMap) {
        int length = localMap.length();
        if (seq.length < length) {
            System.err.println("Offending sequence: \"" + new String(seq) + "\"");
            throw new RuntimeException("The sequence is too short to be converted");
        }
        double[] output = new double[seq.length - length + 1];
        for (int i = 0; i < seq.length - length + 1; ++i) {
            if (length == 2) {
                output[i] = localMap.get(ConversionMap.translate(seq[i], seq[i + 1]));
                continue;
            }
            if (length == 3) {
                output[i] = localMap.get(ConversionMap.translate(seq[i], seq[i + 1], seq[i + 2]));
                continue;
            }
            byte[] tmp = new byte[length];
            System.arraycopy(seq, i, tmp, 0, length);
            output[i] = localMap.get(ConversionMap.translate(tmp));
        }
        return output;
    }
}

