/*
 * Decompiled with CFR 0.152.
 */
package be.abeel.bioinformatics;

import be.abeel.bioinformatics.Record;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastaIterator
implements Iterable<Record>,
Iterator<Record> {
    private BufferedReader in = null;
    private String lastLine = null;
    private Record next = null;

    public FastaIterator(InputStream is) throws IOException {
        this.in = new BufferedReader(new InputStreamReader(is));
        assert (this.in != null);
        this.lastLine = this.readLine(this.in);
        this.next = this.createNextRecord();
    }

    public FastaIterator(String file) throws IOException {
        this(new File(file));
    }

    public FastaIterator(File file) throws IOException {
        this(new FileInputStream(file));
    }

    private String readLine(BufferedReader in) throws IOException {
        String line = in.readLine();
        while (line != null && (line.startsWith(";") || line.length() == 0)) {
            line = in.readLine();
        }
        return line;
    }

    private Record createNextRecord() {
        if (this.lastLine == null) {
            return null;
        }
        StringBuffer description = new StringBuffer();
        StringBuffer sequence = new StringBuffer();
        if (!this.lastLine.startsWith(">")) {
            throw new RuntimeException("The fasta file is not valid around the following line:\n\t" + this.lastLine);
        }
        description.append(this.lastLine);
        try {
            this.lastLine = this.readLine(this.in);
            while (this.lastLine != null && !this.lastLine.startsWith(">")) {
                sequence.append(this.lastLine);
                this.lastLine = this.readLine(this.in);
            }
            if (description != null) {
                return new Record(description.toString(), sequence.toString());
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Iterator<Record> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Record next() {
        Record tmp = this.next;
        try {
            this.next = this.createNextRecord();
        }
        catch (RuntimeException e) {
            throw new NoSuchElementException(e.getMessage());
        }
        return tmp;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

