/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.model.repositories;

import javax.swing.ImageIcon;
import org.esa.snap.engine_utilities.datamodel.Credentials;
import org.esa.snap.engine_utilities.db.ProductQueryInterface;
import org.esa.snap.engine_utilities.download.opensearch.CopernicusProductQuery;
import org.esa.snap.graphbuilder.rcp.dialogs.PromptDialog;
import org.esa.snap.productlibrary.rcp.toolviews.ProductLibraryToolView;
import org.esa.snap.productlibrary.rcp.toolviews.model.repositories.RepositoryInterface;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.UIUtils;

public class ScihubRepository
implements RepositoryInterface {
    private static final ImageIcon icon = UIUtils.loadImageIcon((String)"/org/esa/snap/productlibrary/icons/scihub24.png", ProductLibraryToolView.class);

    @Override
    public String getName() {
        return "ESA SciHub";
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public ImageIcon getIconImage() {
        return icon;
    }

    @Override
    public ProductQueryInterface getProductQueryInterface() {
        ScihubRepository.checkCredentials();
        return CopernicusProductQuery.instance();
    }

    @Override
    public void resetCredentials() {
        ScihubRepository.promptForCredentials();
    }

    private static void promptForCredentials() {
        PromptDialog dlg = new PromptDialog("https://scihub.copernicus.eu", new PromptDialog.Descriptor[]{new PromptDialog.Descriptor("User name:", "", PromptDialog.TYPE.TEXTFIELD), new PromptDialog.Descriptor("Password:", "", PromptDialog.TYPE.PASSWORD)});
        dlg.show();
        if (dlg.IsOK()) {
            try {
                String user = dlg.getValue("User name:");
                String password = dlg.getValue("Password:");
                Credentials.instance().put("https://scihub.copernicus.eu", user, password);
            }
            catch (Exception ex) {
                Dialogs.showError((String)ex.getMessage());
            }
        }
    }

    private static void checkCredentials() {
        Credentials.CredentialInfo credentialInfo = Credentials.instance().get("https://scihub.copernicus.eu");
        if (credentialInfo == null) {
            ScihubRepository.promptForCredentials();
        }
    }
}

