/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.extensions;

import com.bc.ceres.core.ProgressMonitor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.productlibrary.rcp.toolviews.ProductLibraryActions;
import org.esa.snap.productlibrary.rcp.toolviews.ProductLibraryToolView;
import org.esa.snap.productlibrary.rcp.toolviews.extensions.ProductLibraryActionExt;
import org.esa.snap.productlibrary.rcp.utils.ProductOpener;
import org.esa.snap.ui.UIUtils;

public class OpenActionExt
implements ProductLibraryActionExt {
    private static final ImageIcon openIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/productlibrary/icons/open24.png", ProductLibraryToolView.class);
    private JButton button = null;
    private ProductLibraryActions actionHandler;

    @Override
    public void setActionHandler(ProductLibraryActions actionHandler) {
        this.actionHandler = actionHandler;
    }

    @Override
    public JButton getButton(JPanel panel) {
        if (this.button == null) {
            this.button = DialogUtils.createButton((String)"openAllSelectedButton", (String)"Open", (ImageIcon)openIcon, (JPanel)panel, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        }
        return this.button;
    }

    @Override
    public void selectionChanged(ProductEntry[] selections) {
        this.button.setEnabled(selections.length > 0 && ProductLibraryActions.allProductsExist(selections));
    }

    @Override
    public void performAction(ProgressMonitor pm) {
        ProductOpener.openProducts(this.actionHandler.getSelectedFiles());
    }
}

