/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.extensions;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.awt.Component;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.engine_utilities.download.opendata.OpenData;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.productlibrary.rcp.toolviews.ProductLibraryActions;
import org.esa.snap.productlibrary.rcp.toolviews.extensions.ProductLibraryActionExt;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.SnapFileChooser;
import org.esa.snap.ui.UIUtils;

public class DownloadActionExt
implements ProductLibraryActionExt {
    private static final ImageIcon downloadIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/productlibrary/icons/downloads-icon22.png", DownloadActionExt.class);
    private JButton button = null;
    private ProductLibraryActions actionHandler;
    private static final String COPERNICUS_HOST = "https://scihub.copernicus.eu";
    private static final String COPERNICUS_ODATA_ROOT = "https://scihub.copernicus.eu/dhus/odata/v1/";
    private File outputFolder;

    @Override
    public void setActionHandler(ProductLibraryActions actionHandler) {
        this.actionHandler = actionHandler;
    }

    @Override
    public JButton getButton(JPanel panel) {
        if (this.button == null) {
            this.button = DialogUtils.createButton((String)"downloadButton", (String)"Download", (ImageIcon)downloadIcon, (JPanel)panel, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        }
        return this.button;
    }

    @Override
    public void selectionChanged(ProductEntry[] selections) {
        this.button.setEnabled(selections.length > 0 && !ProductLibraryActions.allProductsExist(selections));
    }

    private static File requestFolderForSave(String title, String preferenceKey) {
        File file;
        do {
            if ((file = DownloadActionExt.requestFolderForSave2(title, preferenceKey)) != null) continue;
            return null;
        } while (file == null);
        SystemUtils.LOG.info("Download to " + file.getAbsolutePath());
        return file;
    }

    private static File requestFolderForSave2(String title, String preferenceKey) {
        Assert.notNull((Object)preferenceKey, (String)"preferenceKey");
        String lastDir = SnapApp.getDefault().getPreferences().get(preferenceKey, SystemUtils.getUserHomeDir().getPath());
        File currentDir = new File(lastDir);
        SnapFileChooser fileChooser = new SnapFileChooser();
        fileChooser.setCurrentDirectory(currentDir);
        fileChooser.setDialogTitle(Dialogs.getDialogTitle((String)title));
        fileChooser.setFileSelectionMode(1);
        fileChooser.setAcceptAllFileFilterUsed(false);
        int result = fileChooser.showSaveDialog((Component)SnapApp.getDefault().getMainFrame());
        if (fileChooser.getCurrentDirectory() != null) {
            SnapApp.getDefault().getPreferences().put(preferenceKey, fileChooser.getCurrentDirectory().getPath());
        }
        if (result == 0) {
            File file = fileChooser.getSelectedFile();
            if (file == null || file.getName().equals("")) {
                return null;
            }
            String path = file.getPath();
            return new File(path);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performAction(ProgressMonitor pm) {
        this.outputFolder = DownloadActionExt.requestFolderForSave("Download product(s) to folder", "snap.download.folder");
        if (this.outputFolder == null) {
            return;
        }
        ProductEntry[] selections = this.actionHandler.getSelectedProductEntries();
        pm.beginTask("Downloading...", selections.length);
        try {
            OpenData openData = new OpenData(COPERNICUS_HOST, COPERNICUS_ODATA_ROOT);
            for (ProductEntry entry : selections) {
                if (pm.isCanceled()) {
                    SystemUtils.LOG.info("DownloadActionExt: Download is cancelled");
                    break;
                }
                OpenData.Entry oData = openData.getEntryByID(entry.getRefID());
                SystemUtils.LOG.info(oData.fileName);
                openData.getProduct(entry.getRefID(), oData, this.outputFolder, (ProgressMonitor)new SubProgressMonitor(pm, 1));
            }
            for (ProductLibraryActionExt.ActionExtListener listener : listenerList) {
                listener.notifyMSG(this, ProductLibraryActionExt.ActionExtListener.MSG.NEW_REPO);
            }
        }
        catch (Exception e) {
            Dialogs.showError((String)("unable to download " + e.getMessage()));
        }
        finally {
            pm.done();
        }
    }

    @Override
    public File getNewRepoFolder() {
        return this.outputFolder;
    }
}

