/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.db.ProductDB;
import org.esa.snap.productlibrary.rcp.toolviews.DatabasePane;
import org.esa.snap.productlibrary.rcp.toolviews.extensions.ProductLibraryActionExt;

public final class DBWorker
extends SwingWorker<Boolean, Object> {
    private TYPE operationType;
    private File baseDir;
    private ProductDB db;
    private DatabasePane dbPane;
    private ProductLibraryActionExt action;
    private final ProgressMonitor pm;
    private final List<DBWorkerListener> listenerList = new ArrayList<DBWorkerListener>(1);

    public DBWorker(TYPE type, ProductDB database, File baseDir, ProgressMonitor pm) {
        this.operationType = type;
        this.db = database;
        this.baseDir = baseDir;
        this.pm = pm;
    }

    public DBWorker(TYPE type, DatabasePane dbPane, ProgressMonitor pm) {
        this.operationType = type;
        this.dbPane = dbPane;
        this.pm = pm;
    }

    public DBWorker(TYPE type, ProductLibraryActionExt action, ProgressMonitor pm) {
        this.operationType = type;
        this.action = action;
        this.pm = pm;
    }

    public void addListener(DBWorkerListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    private void notifyMSG(DBWorkerListener.MSG msg) {
        for (DBWorkerListener listener : this.listenerList) {
            listener.notifyMSG(msg);
        }
    }

    @Override
    protected Boolean doInBackground() throws Exception {
        try {
            if (this.operationType.equals((Object)TYPE.REMOVE)) {
                this.removeProducts();
            } else if (this.operationType.equals((Object)TYPE.QUERY)) {
                this.dbPane.fullQuery(this.pm);
            } else if (this.operationType.equals((Object)TYPE.EXECUTEACTION)) {
                this.action.performAction(this.pm);
            }
        }
        catch (Throwable e) {
            SystemUtils.LOG.severe("DB Worker Exception\n" + e.getMessage());
        }
        finally {
            this.pm.done();
        }
        return true;
    }

    private void removeProducts() throws SQLException {
        if (this.baseDir == null) {
            this.db.removeAllProducts(this.pm);
        } else {
            this.db.removeProducts(this.baseDir, this.pm);
        }
    }

    @Override
    public void done() {
        this.notifyMSG(DBWorkerListener.MSG.DONE);
    }

    public static interface DBWorkerListener {
        public void notifyMSG(MSG var1);

        public static enum MSG {
            DONE;

        }
    }

    public static enum TYPE {
        REMOVE,
        QUERY,
        EXECUTEACTION;

    }
}

