/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model.dataprovider;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.text.DecimalFormat;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model.AOI;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model.dataprovider.DataProvider;

public class AOIDetailsProvider
implements DataProvider {
    private static final DecimalFormat df = new DecimalFormat("#.##");
    private static final String[] detailsLables = new String[]{"Name:", "Input Folder:", "Output Folder:", "Processing Graph"};
    private final Comparator<AOI> aoiComparator = new AOIComparator();
    private TableColumn detailsColumn;

    @Override
    public Comparator<AOI> getComparator() {
        return this.aoiComparator;
    }

    @Override
    public void cleanUp(ProductEntry entry) {
    }

    @Override
    public TableColumn getTableColumn() {
        if (this.detailsColumn == null) {
            this.detailsColumn = new TableColumn();
            this.detailsColumn.setResizable(true);
            this.detailsColumn.setPreferredWidth(350);
            this.detailsColumn.setHeaderValue("Areas of Interest");
            this.detailsColumn.setCellRenderer(new AOIDetailsRenderer());
        }
        return this.detailsColumn;
    }

    private static class AOIComparator
    implements Comparator<AOI> {
        private AOIComparator() {
        }

        @Override
        public int compare(AOI o1, AOI o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static class AOIDetailsRenderer
    extends JTable
    implements TableCellRenderer {
        private static final int ROW_HEIGHT = 100;
        private final JPanel centeringPanel = new JPanel(new BorderLayout());
        private final Font valueFont;

        public AOIDetailsRenderer() {
            DefaultTableModel dataModel = new DefaultTableModel();
            dataModel.setColumnCount(2);
            dataModel.setRowCount(detailsLables.length);
            for (int i = 0; i < detailsLables.length; ++i) {
                dataModel.setValueAt(detailsLables[i], i, 0);
                dataModel.setValueAt("", i, 1);
            }
            this.setModel(dataModel);
            this.valueFont = this.getFont().deriveFont(1);
            this.getColumnModel().getColumn(1).setCellRenderer(new PropertyValueCellRenderer(this.valueFont));
            this.getColumnModel().getColumn(0).setMaxWidth(120);
            this.getTableHeader().setVisible(false);
            this.setShowHorizontalLines(false);
            this.setShowVerticalLines(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color foregroundColor;
            Color backgroundColor;
            String[] values = null;
            String toolTip = "";
            if (value instanceof AOI) {
                AOI entry = (AOI)value;
                values = new String[]{entry.getName(), entry.getInputFolder(), entry.getOutputFolder(), entry.getProcessingGraph()};
                for (int i = 0; i < values.length; ++i) {
                    this.setValueAt(values[i], i, 1);
                }
            } else if (value == null) {
                for (int i = 0; i < detailsLables.length; ++i) {
                    this.setValueAt(null, i, 1);
                }
            }
            if (isSelected) {
                backgroundColor = table.getSelectionBackground();
                foregroundColor = table.getSelectionForeground();
            } else {
                backgroundColor = table.getBackground();
                foregroundColor = table.getForeground();
            }
            this.setForeground(foregroundColor);
            this.setBackground(backgroundColor);
            this.centeringPanel.setForeground(foregroundColor);
            this.centeringPanel.setBackground(backgroundColor);
            this.centeringPanel.setBorder(BorderFactory.createLineBorder(backgroundColor, 3));
            this.centeringPanel.add((Component)this, "Center");
            this.centeringPanel.setToolTipText(toolTip);
            this.adjustCellSize(table, row, column, values);
            return this.centeringPanel;
        }

        private void adjustCellSize(JTable table, int row, int column, String[] values) {
            AOIDetailsRenderer.setRowHeight(table, row, 100);
            int lablesLength = AOIDetailsRenderer.getMaxStringLength(detailsLables, this.getFontMetrics(this.getFont()));
            int columnIndex = 0;
            AOIDetailsRenderer.increasePreferredColumnWidth(this.getColumnModel().getColumn(columnIndex), lablesLength);
            int valuesLength = 50;
            if (values != null) {
                valuesLength = Math.min(300, AOIDetailsRenderer.getMaxStringLength(values, this.getFontMetrics(this.valueFont)));
                AOIDetailsRenderer.increasePreferredColumnWidth(this.getColumnModel().getColumn(1), valuesLength);
            }
            int preferredWidth = lablesLength + valuesLength;
            TableColumn valueColumn = table.getColumnModel().getColumn(column);
            int valueColWidth = Math.max(valueColumn.getWidth(), preferredWidth);
            AOIDetailsRenderer.increasePreferredColumnWidth(valueColumn, valueColWidth);
        }

        private static void increasePreferredColumnWidth(TableColumn column, int length) {
            if (column.getPreferredWidth() < length) {
                column.setPreferredWidth(length);
            }
        }

        private static void setRowHeight(JTable table, int row, int rowHeight) {
            int currentRowHeight = table.getRowHeight(row);
            if (currentRowHeight < rowHeight) {
                table.setRowHeight(rowHeight);
            }
        }

        private static int getMaxStringLength(String[] strings, FontMetrics fontMetrics) {
            int maxWidth = Integer.MIN_VALUE;
            for (String string : strings) {
                if (string == null) {
                    string = String.valueOf(string);
                }
                int width = SwingUtilities.computeStringWidth(fontMetrics, string);
                maxWidth = Math.max(width, maxWidth);
            }
            return maxWidth;
        }

        private static class PropertyValueCellRenderer
        extends DefaultTableCellRenderer {
            private final Font _font;

            public PropertyValueCellRenderer(Font font) {
                this._font = font;
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                jLabel.setHorizontalAlignment(2);
                if (row == 0) {
                    jLabel.setFont(this._font);
                }
                return jLabel;
            }
        }
    }
}

