/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model.AOI;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model.dataprovider.AOIDetailsProvider;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model.dataprovider.DataProvider;

public class AOITableModel
extends AbstractTableModel {
    private final AOI[] aoiList;
    private final List<DataProvider> dataProviders = new ArrayList<DataProvider>(5);
    private final List<TableColumn> columnList = new ArrayList<TableColumn>();

    public AOITableModel(AOI[] aoiList) {
        this.aoiList = aoiList;
        this.dataProviders.add(new AOIDetailsProvider());
        for (DataProvider provider : this.dataProviders) {
            TableColumn tableColumn = provider.getTableColumn();
            tableColumn.setModelIndex(this.getColumnCount());
            this.columnList.add(tableColumn);
        }
    }

    public DataProvider getDataProvider(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.dataProviders.size()) {
            return this.dataProviders.get(columnIndex);
        }
        return null;
    }

    public TableColumnModel getColumnModel() {
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        for (TableColumn aColumnList : this.columnList) {
            columnModel.addColumn(aColumnList);
        }
        return columnModel;
    }

    @Override
    public int getRowCount() {
        return this.aoiList != null ? this.aoiList.length : 0;
    }

    @Override
    public int getColumnCount() {
        return this.columnList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        AOI entry;
        if (this.aoiList != null && (entry = this.aoiList[rowIndex]) != null) {
            return entry;
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.columnList.size()) {
            TableColumn column = this.columnList.get(columnIndex);
            return column.getHeaderValue().toString();
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex >= this.columnList.size()) {
            return false;
        }
        TableColumn column = this.columnList.get(columnIndex);
        return column.getCellEditor() != null;
    }
}

