/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.classification.gpf;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class PowerSet<E>
implements Iterator<Set<E>>,
Iterable<Set<E>> {
    private final int minSize;
    private final int maxSize;
    private final E[] arr;
    private long bits = 0L;
    private long count = 0L;

    public PowerSet(Set<E> set, int minSize, int maxSize) {
        this.minSize = Math.min(minSize, set.size());
        this.maxSize = Math.min(maxSize, set.size());
        this.arr = set.toArray();
        for (int n = 0; n < minSize; ++n) {
            this.bits |= 1L << n;
        }
        this.count = PowerSet.countBitSet(this.bits);
    }

    @Override
    public boolean hasNext() {
        return (this.bits & 1L << this.arr.length) == 0L;
    }

    @Override
    public Set<E> next() {
        TreeSet<E> returnSet = new TreeSet<E>();
        for (int i = 0; i < this.arr.length; ++i) {
            if ((this.bits & 1L << i) == 0L) continue;
            returnSet.add(this.arr[i]);
        }
        do {
            if (this.count < (long)this.minSize) {
                long maxFree = PowerSet.lowestIndex(this.bits) - 1L;
                long missing = (long)this.minSize - this.count;
                int n = 0;
                while ((long)n < Math.min(maxFree, missing)) {
                    this.bits |= 1L << n;
                    ++n;
                }
            } else {
                ++this.bits;
            }
            this.count = PowerSet.countBitSet(this.bits);
        } while (this.count < (long)this.minSize || this.count > (long)this.maxSize);
        return returnSet;
    }

    private static long lowestIndex(long i) {
        int n = 0;
        while (n < 64 && (i & 1L) == 0L) {
            ++n;
            i >>>= 1;
        }
        return n;
    }

    private static long countBitSet(long i) {
        i -= i >>> 1 & 0x5555555555555555L;
        i = (i & 0x3333333333333333L) + (i >>> 2 & 0x3333333333333333L);
        i = i + (i >>> 4) & 0xF0F0F0F0F0F0F0FL;
        return i * 0x101010101010101L >>> 56;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not Supported!");
    }

    @Override
    public Iterator<Set<E>> iterator() {
        return this;
    }
}

