/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.smart.configurator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.BackingStoreException;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.smart.configurator.BenchmarkSingleCalculus;
import org.esa.snap.smart.configurator.ConfigurationOptimizer;
import org.esa.snap.smart.configurator.PerformanceParameters;

public class Benchmark {
    private List<BenchmarkSingleCalculus> benchmarkCalculus;

    public Benchmark(List<String> readerTileDimension, List<Integer> cacheSizes, List<Integer> nbThreads) {
        if (readerTileDimension.isEmpty() || cacheSizes.isEmpty() || nbThreads.isEmpty()) {
            throw new IllegalArgumentException("All benchmark parameters need to be filled");
        }
        this.benchmarkCalculus = new ArrayList<BenchmarkSingleCalculus>();
        this.benchmarkCalculus.add(new BenchmarkSingleCalculus(readerTileDimension.get(0), cacheSizes.get(0), (int)nbThreads.get(0), true));
        for (String dim : readerTileDimension) {
            for (Integer cacheSize : cacheSizes) {
                for (Integer nbThread : nbThreads) {
                    this.benchmarkCalculus.add(new BenchmarkSingleCalculus(dim, cacheSize, nbThread));
                }
            }
        }
    }

    public BenchmarkSingleCalculus getFasterBenchmarkSingleCalculus() {
        Collections.sort(this.benchmarkCalculus);
        return this.benchmarkCalculus.get(0);
    }

    public void loadBenchmarkPerfParams(BenchmarkSingleCalculus benchmarkSingleCalculus) {
        ConfigurationOptimizer confOptimizer = ConfigurationOptimizer.getInstance();
        PerformanceParameters benchmarkPerformanceParameters = confOptimizer.getActualPerformanceParameters();
        benchmarkPerformanceParameters.setTileWidth(benchmarkSingleCalculus.getTileWidth());
        benchmarkPerformanceParameters.setTileHeight(benchmarkSingleCalculus.getTileHeight());
        benchmarkPerformanceParameters.setCacheSize(benchmarkSingleCalculus.getCacheSize());
        benchmarkPerformanceParameters.setNbThreads(benchmarkSingleCalculus.getNbThreads());
        confOptimizer.updateCustomisedParameters(benchmarkPerformanceParameters);
        try {
            confOptimizer.saveCustomisedParameters();
        }
        catch (IOException | BackingStoreException e) {
            SystemUtils.LOG.severe("Could not save performance parameters: " + e.getMessage());
        }
    }

    public String toString() {
        String benchmarksPrint = "Benchmark results sorted by execution time\n";
        benchmarksPrint = benchmarksPrint + "(Tile dimension, Cache size, Nb threads) = Execution time \n\n";
        for (BenchmarkSingleCalculus benchmarkSingleCalcul : this.benchmarkCalculus) {
            if (benchmarkSingleCalcul.isHidden()) continue;
            benchmarksPrint = benchmarksPrint + benchmarkSingleCalcul.toString() + "\n";
        }
        return benchmarksPrint;
    }

    public String[] getColumnsNames() {
        return BenchmarkSingleCalculus.getColumnNames();
    }

    public String[] getColumnsNamesWithoutTileSize() {
        return BenchmarkSingleCalculus.getColumnNamesWithoutTileSize();
    }

    public int[][] getRows() {
        int numRows = this.benchmarkCalculus.size();
        int numColumns = this.getColumnsNames().length;
        if (numRows == 0 || numColumns == 0) {
            return null;
        }
        int[][] rows = new int[numRows][numColumns];
        for (int i = 0; i < numRows; ++i) {
            rows[i] = this.benchmarkCalculus.get(i).getData();
        }
        return rows;
    }

    public int[][] getRowsToShow() {
        int numRows = 0;
        int numColumns = this.getColumnsNames().length;
        for (int i = 0; i < this.benchmarkCalculus.size(); ++i) {
            if (this.benchmarkCalculus.get(i).isHidden()) continue;
            ++numRows;
        }
        if (numRows == 0 || numColumns == 0) {
            return null;
        }
        int[][] rows = new int[numRows][numColumns];
        int index = 0;
        for (int i = 0; i < this.benchmarkCalculus.size(); ++i) {
            if (this.benchmarkCalculus.get(i).isHidden()) continue;
            rows[index] = this.benchmarkCalculus.get(i).getData();
            ++index;
        }
        return rows;
    }

    public int[][] getRowsToShowWhitoutTileSize() {
        int numRows = 0;
        int numColumns = this.getColumnsNamesWithoutTileSize().length;
        for (int i = 0; i < this.benchmarkCalculus.size(); ++i) {
            if (this.benchmarkCalculus.get(i).isHidden()) continue;
            ++numRows;
        }
        if (numRows == 0 || numColumns == 0) {
            return null;
        }
        int[][] rows = new int[numRows][numColumns];
        int index = 0;
        for (int i = 0; i < this.benchmarkCalculus.size(); ++i) {
            if (this.benchmarkCalculus.get(i).isHidden()) continue;
            rows[index] = this.benchmarkCalculus.get(i).getDataWithoutTileSize();
            ++index;
        }
        return rows;
    }

    public List<BenchmarkSingleCalculus> getBenchmarkCalculus() {
        return this.benchmarkCalculus;
    }

    public void addBenchmarkCalcul(BenchmarkSingleCalculus benchmarkSingleCalcul) {
        this.benchmarkCalculus.add(benchmarkSingleCalcul);
    }

    public boolean isAlreadyInList(BenchmarkSingleCalculus benchmarkSingleCalculNew) {
        for (BenchmarkSingleCalculus benchmarkSingleCalcul : this.benchmarkCalculus) {
            if (!benchmarkSingleCalcul.hasIdenticalParameters(benchmarkSingleCalculNew)) continue;
            return true;
        }
        return false;
    }
}

