/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.core.datamodel.StxFactory;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.statistics.AxisRangeControl;
import org.esa.snap.rcp.statistics.ChartPagePanel;
import org.esa.snap.rcp.statistics.MaskSelectionToolSupport;
import org.esa.snap.rcp.statistics.PlotAreaSelectionTool;
import org.esa.snap.rcp.statistics.RefreshActionEnabler;
import org.esa.snap.rcp.statistics.StatisticChartStyling;
import org.esa.snap.rcp.statistics.XYImagePlot;
import org.esa.snap.rcp.statistics.XYPlotToolTipGenerator;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.GridBagUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.ui.RectangleInsets;
import org.openide.windows.TopComponent;

class DensityPlotPanel
extends ChartPagePanel {
    private static final String NO_DATA_MESSAGE = "No scatter plot computed yet.\nTo create a scatter plot, select bands in both combo boxes.\nThe plot will be computed when you click the 'Refresh View' button.\nFor more information about this plot\nhit the help button at the bottom right.\nTIP: To zoom within the chart, draw a rectangle\nwith the mouse or use the context menu.";
    private static final String CHART_TITLE = "Scatter Plot";
    private static final String PROPERTY_NAME_AUTO_MIN_MAX = "autoMinMax";
    private static final String PROPERTY_NAME_MIN = "min";
    private static final String PROPERTY_NAME_MAX = "max";
    private static final String PROPERTY_NAME_USE_ROI_MASK = "useRoiMask";
    private static final String PROPERTY_NAME_ROI_MASK = "roiMask";
    private static final String PROPERTY_NAME_X_PRODUCT = "xProduct";
    private static final String PROPERTY_NAME_Y_PRODUCT = "yProduct";
    private static final String PROPERTY_NAME_X_BAND = "xBand";
    private static final String PROPERTY_NAME_Y_BAND = "yBand";
    private static final int X_VAR = 0;
    private static final int Y_VAR = 1;
    private static final int NUM_DECIMALS = 2;
    private BindingContext bindingContext;
    private DataSourceConfig dataSourceConfig;
    private Property xProductProperty;
    private Property yProductProperty;
    private Property xBandProperty;
    private Property yBandProperty;
    private JComboBox<ListCellRenderer> xProductList;
    private JComboBox<ListCellRenderer> yProductList;
    private JComboBox<ListCellRenderer> xBandList;
    private JComboBox<ListCellRenderer> yBandList;
    private Dimension referenceSize;
    private static AxisRangeControl[] axisRangeControls = new AxisRangeControl[2];
    private IndexColorModel toggledColorModel;
    private IndexColorModel untoggledColorModel;
    private ChartPanel densityPlotDisplay;
    private XYImagePlot plot;
    private static final Color backgroundColor = new Color(255, 255, 255, 0);
    private boolean plotColorsInverted;
    private JCheckBox toggleColorCheckBox;

    DensityPlotPanel(TopComponent parentComponent, String helpId) {
        super(parentComponent, helpId, CHART_TITLE, true);
    }

    @Override
    protected void initComponents() {
        this.initParameters();
        this.createUI();
        this.initActionEnablers();
    }

    private void initActionEnablers() {
        RefreshActionEnabler roiMaskActionEnabler = new RefreshActionEnabler(this.refreshButton, PROPERTY_NAME_USE_ROI_MASK, PROPERTY_NAME_ROI_MASK, PROPERTY_NAME_X_PRODUCT, PROPERTY_NAME_Y_PRODUCT, PROPERTY_NAME_X_BAND, PROPERTY_NAME_Y_BAND);
        this.bindingContext.addPropertyChangeListener((PropertyChangeListener)roiMaskActionEnabler);
        RefreshActionEnabler rangeControlActionEnabler = new RefreshActionEnabler(this.refreshButton, PROPERTY_NAME_MIN, PROPERTY_NAME_AUTO_MIN_MAX, PROPERTY_NAME_MAX);
        axisRangeControls[0].getBindingContext().addPropertyChangeListener((PropertyChangeListener)rangeControlActionEnabler);
        axisRangeControls[1].getBindingContext().addPropertyChangeListener((PropertyChangeListener)rangeControlActionEnabler);
    }

    @Override
    public void nodeDataChanged(ProductNodeEvent event) {
        super.nodeDataChanged(event);
        if (!this.dataSourceConfig.useRoiMask) {
            return;
        }
        Mask roiMask = this.dataSourceConfig.roiMask;
        if (roiMask == null) {
            return;
        }
        ProductNode sourceNode = event.getSourceNode();
        if (!(sourceNode instanceof Mask)) {
            return;
        }
        String maskName = sourceNode.getName();
        if (roiMask.getName().equals(maskName)) {
            this.updateComponents();
        }
    }

    @Override
    protected void updateComponents() {
        super.updateComponents();
        if (this.isRasterChanged() || this.isProductChanged()) {
            this.plot.setImage(null);
            this.plot.setDataset(null);
            if (this.isProductChanged()) {
                this.plot.getDomainAxis().setLabel("X");
                this.plot.getRangeAxis().setLabel("Y");
            }
            ValueSet productValueSet = new ValueSet((Object[])DensityPlotPanel.createAvailableProductList());
            this.xProductProperty.getDescriptor().setValueSet(productValueSet);
            this.yProductProperty.getDescriptor().setValueSet(productValueSet);
            if (productValueSet.getItems().length > 0) {
                Product currentProduct = this.getProduct();
                try {
                    this.xProductProperty.setValue((Object)currentProduct);
                    this.yProductProperty.setValue((Object)currentProduct);
                }
                catch (ValidationException ignored) {
                    Debug.trace((Throwable)ignored);
                }
            }
            this.updateBandList(this.getProduct(), this.xBandProperty, false);
            this.updateBandList(this.getProduct(), this.yBandProperty, true);
            this.toggleColorCheckBox.setEnabled(false);
        }
        this.refreshButton.setEnabled(this.xBandProperty.getValue() != null && this.yBandProperty.getValue() != null);
    }

    private void updateBandList(Product product, Property bandProperty, boolean considerReferenceSize) {
        if (product == null) {
            return;
        }
        ValueSet bandValueSet = new ValueSet((Object[])this.createAvailableBandList(product, considerReferenceSize));
        bandProperty.getDescriptor().setValueSet(bandValueSet);
        if (bandValueSet.getItems().length > 0) {
            RasterDataNode currentRaster = this.getRaster();
            if (bandValueSet.contains((Object)this.getRaster())) {
                currentRaster = this.getRaster();
            }
            try {
                bandProperty.setValue((Object)currentRaster);
            }
            catch (ValidationException ignored) {
                Debug.trace((Throwable)ignored);
            }
        }
    }

    private void initParameters() {
        DensityPlotPanel.axisRangeControls[0] = new AxisRangeControl("X-Axis");
        DensityPlotPanel.axisRangeControls[1] = new AxisRangeControl("Y-Axis");
        this.initColorModels();
        this.plotColorsInverted = false;
        this.dataSourceConfig = new DataSourceConfig();
        this.bindingContext = new BindingContext((PropertySet)PropertyContainer.createObjectBacked((Object)this.dataSourceConfig));
        this.xProductList = new JComboBox();
        this.xProductList.addItemListener(event -> {
            if (event.getStateChange() == 1) {
                Product selectedXProduct = (Product)event.getItem();
                this.updateBandList(selectedXProduct, this.xBandProperty, false);
            }
        });
        this.xProductList.setRenderer(new ProductListCellRenderer());
        this.bindingContext.bind(PROPERTY_NAME_X_PRODUCT, this.xProductList);
        this.xProductProperty = this.bindingContext.getPropertySet().getProperty(PROPERTY_NAME_X_PRODUCT);
        this.yProductList = new JComboBox();
        this.yProductList.addItemListener(event -> {
            if (event.getStateChange() == 1) {
                Product selectedYProduct = (Product)event.getItem();
                this.updateBandList(selectedYProduct, this.yBandProperty, true);
            }
        });
        this.yProductList.setRenderer(new ProductListCellRenderer());
        this.bindingContext.bind(PROPERTY_NAME_Y_PRODUCT, this.yProductList);
        this.yProductProperty = this.bindingContext.getPropertySet().getProperty(PROPERTY_NAME_Y_PRODUCT);
        this.xBandList = new JComboBox();
        this.xBandList.setRenderer(new BandListCellRenderer());
        this.bindingContext.bind(PROPERTY_NAME_X_BAND, this.xBandList);
        this.xBandList.addActionListener(e -> {
            Dimension rasterSize;
            Object value = this.xBandList.getSelectedItem();
            if (value != null && (rasterSize = ((RasterDataNode)value).getRasterSize()) != this.referenceSize) {
                this.referenceSize = rasterSize;
                this.updateBandList(this.getProduct(), this.yBandProperty, true);
            }
        });
        this.xBandProperty = this.bindingContext.getPropertySet().getProperty(PROPERTY_NAME_X_BAND);
        this.yBandList = new JComboBox();
        this.yBandList.setRenderer(new BandListCellRenderer());
        this.bindingContext.bind(PROPERTY_NAME_Y_BAND, this.yBandList);
        this.yBandProperty = this.bindingContext.getPropertySet().getProperty(PROPERTY_NAME_Y_BAND);
    }

    private static String formatProductName(Product product) {
        String name = product.getName().substring(0, Math.min(10, product.getName().length()));
        if (product.getName().length() > 10) {
            name = name + "...";
        }
        return product.getProductRefString() + name;
    }

    private void initColorModels() {
        for (int j = 0; j <= 1; ++j) {
            int i;
            int palSize = 256;
            byte[] r = new byte[256];
            byte[] g = new byte[256];
            byte[] b = new byte[256];
            byte[] a = new byte[256];
            r[0] = (byte)backgroundColor.getRed();
            g[0] = (byte)backgroundColor.getGreen();
            b[0] = (byte)backgroundColor.getBlue();
            a[0] = (byte)backgroundColor.getAlpha();
            for (i = 1; i < 128; ++i) {
                if (j == 0) {
                    r[i] = (byte)(2 * i);
                    g[i] = 0;
                } else {
                    r[i] = -1;
                    g[i] = (byte)(255 - 2 * (i - 128));
                }
                b[i] = 0;
                a[i] = -1;
            }
            for (i = 128; i < 256; ++i) {
                if (j == 0) {
                    r[i] = -1;
                    g[i] = (byte)(2 * (i - 128));
                } else {
                    r[i] = (byte)(255 - 2 * i);
                    g[i] = 0;
                }
                b[i] = 0;
                a[i] = -1;
            }
            if (j == 0) {
                this.toggledColorModel = new IndexColorModel(8, 256, r, g, b, a);
                continue;
            }
            this.untoggledColorModel = new IndexColorModel(8, 256, r, g, b, a);
        }
    }

    private void createUI() {
        this.plot = new XYImagePlot();
        this.plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        NumberAxis domainAxis = (NumberAxis)this.plot.getDomainAxis();
        NumberAxis rangeAxis = (NumberAxis)this.plot.getRangeAxis();
        domainAxis.setAutoRangeIncludesZero(false);
        rangeAxis.setAutoRangeIncludesZero(false);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setLowerMargin(0.0);
        rangeAxis.setUpperMargin(0.0);
        rangeAxis.setLowerMargin(0.0);
        this.plot.setNoDataMessage(NO_DATA_MESSAGE);
        this.plot.getRenderer().setBaseToolTipGenerator((XYToolTipGenerator)new XYPlotToolTipGenerator());
        JFreeChart chart = new JFreeChart(CHART_TITLE, (Plot)this.plot);
        ChartFactory.getChartTheme().apply(chart);
        chart.removeLegend();
        this.createUI(this.createChartPanel(chart), this.createOptionsPanel(), this.bindingContext);
        this.updateUIState();
    }

    private void toggleColor() {
        BufferedImage image = this.plot.getImage();
        if (image != null) {
            image = !this.plotColorsInverted ? new BufferedImage(this.untoggledColorModel, image.getRaster(), image.isAlphaPremultiplied(), null) : new BufferedImage(this.toggledColorModel, image.getRaster(), image.isAlphaPremultiplied(), null);
            this.plot.setImage(image);
            this.densityPlotDisplay.getChart().setNotify(true);
            this.plotColorsInverted = !this.plotColorsInverted;
        }
    }

    private JPanel createOptionsPanel() {
        this.toggleColorCheckBox = new JCheckBox("Invert plot colors");
        this.toggleColorCheckBox.addActionListener(e -> this.toggleColor());
        this.toggleColorCheckBox.setEnabled(false);
        JPanel optionsPanel = GridBagUtils.createPanel();
        GridBagConstraints gbc = GridBagUtils.createConstraints((String)"anchor=NORTHWEST,fill=HORIZONTAL,insets.top=0,weightx=1,gridx=0");
        GridBagUtils.addToPanel((JPanel)optionsPanel, (Component)axisRangeControls[0].getPanel(), (GridBagConstraints)gbc, (String)"gridy=0, insets.top=2");
        GridBagUtils.addToPanel((JPanel)optionsPanel, this.xProductList, (GridBagConstraints)gbc, (String)"gridy=1,insets.left=4,insets.right=2");
        GridBagUtils.addToPanel((JPanel)optionsPanel, this.xBandList, (GridBagConstraints)gbc, (String)"gridy=2,insets.left=4,insets.right=2");
        GridBagUtils.addToPanel((JPanel)optionsPanel, (Component)axisRangeControls[1].getPanel(), (GridBagConstraints)gbc, (String)"gridy=3,insets.left=0,insets.right=0");
        GridBagUtils.addToPanel((JPanel)optionsPanel, this.yProductList, (GridBagConstraints)gbc, (String)"gridy=4,insets.left=4,insets.right=2");
        GridBagUtils.addToPanel((JPanel)optionsPanel, this.yBandList, (GridBagConstraints)gbc, (String)"gridy=5,insets.left=4,insets.right=2");
        GridBagUtils.addToPanel((JPanel)optionsPanel, (Component)new JPanel(), (GridBagConstraints)gbc, (String)"gridy=6");
        GridBagUtils.addToPanel((JPanel)optionsPanel, (Component)new JSeparator(), (GridBagConstraints)gbc, (String)"gridy=7,insets.left=4,insets.right=2");
        GridBagUtils.addToPanel((JPanel)optionsPanel, (Component)this.toggleColorCheckBox, (GridBagConstraints)gbc, (String)"gridy=8,insets.left=0,insets.right=0");
        return optionsPanel;
    }

    private ChartPanel createChartPanel(JFreeChart chart) {
        this.densityPlotDisplay = new ChartPanel(chart);
        MaskSelectionToolSupport maskSelectionToolSupport = new MaskSelectionToolSupport(this, this.densityPlotDisplay, "scatter_plot_area", "Mask generated from selected scatter plot area", Color.RED, PlotAreaSelectionTool.AreaType.ELLIPSE){

            @Override
            protected String createMaskExpression(PlotAreaSelectionTool.AreaType areaType, Shape shape) {
                Rectangle2D bounds = shape.getBounds2D();
                return this.createMaskExpression(bounds.getCenterX(), bounds.getCenterY(), 0.5 * bounds.getWidth(), 0.5 * bounds.getHeight());
            }

            protected String createMaskExpression(double x0, double y0, double dx, double dy) {
                return String.format("sqrt(sq((%s - %s)/%s) + sq((%s - %s)/%s)) < 1.0", BandArithmetic.createExternalName((String)DensityPlotPanel.this.dataSourceConfig.xBand.getName()), x0, dx, BandArithmetic.createExternalName((String)DensityPlotPanel.this.dataSourceConfig.yBand.getName()), y0, dy);
            }
        };
        this.densityPlotDisplay.getPopupMenu().addSeparator();
        this.densityPlotDisplay.getPopupMenu().add(maskSelectionToolSupport.createMaskSelectionModeMenuItem());
        this.densityPlotDisplay.getPopupMenu().add(maskSelectionToolSupport.createDeleteMaskMenuItem());
        this.densityPlotDisplay.getPopupMenu().addSeparator();
        this.densityPlotDisplay.getPopupMenu().add(this.createCopyDataToClipboardMenuItem());
        return this.densityPlotDisplay;
    }

    private RasterDataNode getRaster(int varIndex) {
        Product product = this.getProduct();
        if (product == null) {
            return null;
        }
        RasterDataNode raster = varIndex == 0 ? this.dataSourceConfig.xBand : this.dataSourceConfig.yBand;
        Debug.assertTrue((raster != null ? 1 : 0) != 0);
        return raster;
    }

    private void updateUIState() {
        super.updateComponents();
    }

    private static void checkBandsForRange() throws IllegalArgumentException {
        if (axisRangeControls[0].getMin().equals(axisRangeControls[0].getMax()) && axisRangeControls[1].getMin().equals(axisRangeControls[1].getMax())) {
            throw new IllegalArgumentException("Value range of at least one band must be larger than one");
        }
    }

    @Override
    protected void updateChartData() {
        final RasterDataNode rasterX = this.getRaster(0);
        final RasterDataNode rasterY = this.getRaster(1);
        if (rasterX == null || rasterY == null) {
            return;
        }
        ProgressMonitorSwingWorker<BufferedImage, Object> swingWorker = new ProgressMonitorSwingWorker<BufferedImage, Object>((Component)this, "Computing scatter plot"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected BufferedImage doInBackground(ProgressMonitor pm) throws Exception {
                pm.beginTask("Computing scatter plot...", 100);
                try {
                    DensityPlotPanel.checkBandsForRange();
                    DensityPlotPanel.setRange(0, rasterX, ((DensityPlotPanel)DensityPlotPanel.this).dataSourceConfig.useRoiMask ? ((DensityPlotPanel)DensityPlotPanel.this).dataSourceConfig.roiMask : null, SubProgressMonitor.create((ProgressMonitor)pm, (int)15));
                    DensityPlotPanel.setRange(1, rasterY, ((DensityPlotPanel)DensityPlotPanel.this).dataSourceConfig.useRoiMask ? ((DensityPlotPanel)DensityPlotPanel.this).dataSourceConfig.roiMask : null, SubProgressMonitor.create((ProgressMonitor)pm, (int)15));
                    BufferedImage densityPlotImage = ProductUtils.createDensityPlotImage((RasterDataNode)rasterX, (float)axisRangeControls[0].getMin().floatValue(), (float)axisRangeControls[0].getMax().floatValue(), (RasterDataNode)rasterY, (float)axisRangeControls[1].getMin().floatValue(), (float)axisRangeControls[1].getMax().floatValue(), (Mask)(((DensityPlotPanel)DensityPlotPanel.this).dataSourceConfig.useRoiMask ? ((DensityPlotPanel)DensityPlotPanel.this).dataSourceConfig.roiMask : null), (int)512, (int)512, (Color)backgroundColor, null, (ProgressMonitor)SubProgressMonitor.create((ProgressMonitor)pm, (int)70));
                    DensityPlotPanel.this.toggleColorCheckBox.setSelected(false);
                    DensityPlotPanel.this.plotColorsInverted = false;
                    BufferedImage bufferedImage = densityPlotImage;
                    return bufferedImage;
                }
                finally {
                    pm.done();
                }
            }

            public void done() {
                try {
                    DensityPlotPanel.checkBandsForRange();
                    BufferedImage densityPlotImage = (BufferedImage)this.get();
                    double minX = axisRangeControls[0].getMin();
                    double maxX = axisRangeControls[0].getMax();
                    double minY = axisRangeControls[1].getMin();
                    double maxY = axisRangeControls[1].getMax();
                    if (minX > maxX || minY > maxY) {
                        Dialogs.showMessage(DensityPlotPanel.CHART_TITLE, "Failed to compute scatter plot.\nNo Pixels considered..", 0, null);
                        DensityPlotPanel.this.plot.setDataset(null);
                        return;
                    }
                    if (MathUtils.equalValues((double)minX, (double)maxX, (double)1.0E-4)) {
                        minX = Math.floor(minX);
                        maxX = Math.ceil(maxX);
                    }
                    if (MathUtils.equalValues((double)minY, (double)maxY, (double)1.0E-4)) {
                        minY = Math.floor(minY);
                        maxY = Math.ceil(maxY);
                    }
                    DensityPlotPanel.this.plot.setImage(densityPlotImage);
                    DensityPlotPanel.this.plot.setImageDataBounds(new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY));
                    axisRangeControls[0].adjustComponents(minX, maxX, 2);
                    axisRangeControls[1].adjustComponents(minY, maxY, 2);
                    DensityPlotPanel.this.plot.getDomainAxis().setLabel(StatisticChartStyling.getAxisLabel(DensityPlotPanel.this.getRaster(0), "X", false));
                    DensityPlotPanel.this.plot.getRangeAxis().setLabel(StatisticChartStyling.getAxisLabel(DensityPlotPanel.this.getRaster(1), "Y", false));
                    DensityPlotPanel.this.toggleColorCheckBox.setEnabled(true);
                }
                catch (InterruptedException | CancellationException e) {
                    e.printStackTrace();
                    Dialogs.showMessage(DensityPlotPanel.CHART_TITLE, "Failed to compute scatter plot.\nCalculation canceled.", 0, null);
                }
                catch (IllegalArgumentException | ExecutionException e) {
                    e.printStackTrace();
                    Dialogs.showMessage(DensityPlotPanel.CHART_TITLE, "Failed to compute scatter plot.\nAn error occurred:\n" + e.getCause().getMessage(), 0, null);
                }
            }
        };
        swingWorker.execute();
    }

    private static void setRange(int varIndex, RasterDataNode raster, Mask mask, ProgressMonitor pm) throws IOException {
        AxisRangeControl axisRangeControl = axisRangeControls[varIndex];
        if (axisRangeControl.isAutoMinMax()) {
            Stx stx = mask == null ? raster.getStx(false, pm) : new StxFactory().withRoiMask(mask).create(raster, pm);
            axisRangeControl.adjustComponents(stx.getMinimum(), stx.getMaximum(), 2);
        }
    }

    private static Product[] createAvailableProductList() {
        return SnapApp.getDefault().getProductManager().getProducts();
    }

    private RasterDataNode[] createAvailableBandList(Product product, boolean considerReferenceSize) {
        RasterDataNode raster;
        ArrayList<Object> availableBandList = new ArrayList<Object>(17);
        if (product != null) {
            int i;
            for (i = 0; i < product.getNumBands(); ++i) {
                Band band = product.getBandAt(i);
                if (considerReferenceSize && !band.getRasterSize().equals(this.referenceSize)) continue;
                availableBandList.add(band);
            }
            if (!considerReferenceSize || product.getSceneRasterSize().equals(this.referenceSize)) {
                for (i = 0; i < product.getNumTiePointGrids(); ++i) {
                    availableBandList.add(product.getTiePointGridAt(i));
                }
            }
        }
        if (!((raster = this.getRaster()) == null || raster.getProduct() != product || considerReferenceSize && !raster.getRasterSize().equals(raster.getProduct().getSceneRasterSize()) || availableBandList.contains(raster))) {
            availableBandList.add(raster);
        }
        return availableBandList.toArray(new RasterDataNode[availableBandList.size()]);
    }

    @Override
    protected boolean checkDataToClipboardCopy() {
        int warnLimit = 2000;
        int excelLimit = 65536;
        int numNonEmptyBins = this.getNumNonEmptyBins();
        if (numNonEmptyBins > 2000) {
            String message;
            int status;
            String excelNote = "";
            if (numNonEmptyBins > 65436) {
                excelNote = "Note that e.g., Microsoft\u00ae Excel 2002 only supports a total of 65536 rows in a sheet.\n";
            }
            if ((status = JOptionPane.showConfirmDialog(this, message = MessageFormat.format("This scatter plot contains {0} non-empty bins.\nFor each bin, a text data row containing an x, y and z value will be created.\n{1}\nPress ''Yes'' if you really want to copy this amount of data to the system clipboard.\n", numNonEmptyBins, excelNote), "Copy Data to Clipboard", 0, 2)) != 0) {
                return false;
            }
        }
        return true;
    }

    private static byte[] getValidData(BufferedImage image) {
        if (image != null && image.getColorModel() instanceof IndexColorModel && image.getData().getDataBuffer() instanceof DataBufferByte) {
            return ((DataBufferByte)image.getData().getDataBuffer()).getData();
        }
        return null;
    }

    protected int getNumNonEmptyBins() {
        byte[] data = DensityPlotPanel.getValidData(this.plot.getImage());
        int n = 0;
        if (data != null) {
            for (byte aData : data) {
                int b = aData & 0xFF;
                if (b == 0) continue;
                ++n;
            }
        }
        return n;
    }

    @Override
    protected String getDataAsText() {
        BufferedImage image = this.plot.getImage();
        Rectangle2D bounds = this.plot.getImageDataBounds();
        byte[] data = DensityPlotPanel.getValidData(image);
        if (data == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(64000);
        int w = image.getWidth();
        int h = image.getHeight();
        RasterDataNode rasterX = this.getRaster(0);
        assert (rasterX != null);
        String nameX = rasterX.getName();
        double sampleMinX = bounds.getMinX();
        double sampleMaxX = bounds.getMaxX();
        RasterDataNode rasterY = this.getRaster(1);
        assert (rasterY != null);
        String nameY = rasterY.getName();
        double sampleMinY = bounds.getMinY();
        double sampleMaxY = bounds.getMaxY();
        sb.append("Product name:\t").append(rasterX.getProduct().getName()).append("\n");
        sb.append("Dataset X name:\t").append(nameX).append("\n");
        sb.append("Dataset Y name:\t").append(nameY).append("\n");
        sb.append('\n');
        sb.append(nameX).append(" minimum:\t").append(sampleMinX).append("\t").append(rasterX.getUnit()).append("\n");
        sb.append(nameX).append(" maximum:\t").append(sampleMaxX).append("\t").append(rasterX.getUnit()).append("\n");
        sb.append(nameX).append(" bin size:\t").append((sampleMaxX - sampleMinX) / (double)w).append("\t").append(rasterX.getUnit()).append("\n");
        sb.append(nameX).append(" #bins:\t").append(w).append("\n");
        sb.append('\n');
        sb.append(nameY).append(" minimum:\t").append(sampleMinY).append("\t").append(rasterY.getUnit()).append("\n");
        sb.append(nameY).append(" maximum:\t").append(sampleMaxY).append("\t").append(rasterY.getUnit()).append("\n");
        sb.append(nameY).append(" bin size:\t").append((sampleMaxY - sampleMinY) / (double)h).append("\t").append(rasterY.getUnit()).append("\n");
        sb.append(nameY).append(" #bins:\t").append(h).append("\n");
        sb.append('\n');
        sb.append(nameX);
        sb.append('\t');
        sb.append(nameY);
        sb.append('\t');
        sb.append("Bin counts\t(cropped at 255)");
        sb.append('\n');
        for (int i = 0; i < data.length; ++i) {
            int z = data[i] & 0xFF;
            if (z == 0) continue;
            int x = i % w;
            int y = h - i / w - 1;
            double v1 = sampleMinX + ((double)x + 0.5) * (sampleMaxX - sampleMinX) / (double)w;
            double v2 = sampleMinY + ((double)y + 0.5) * (sampleMaxY - sampleMinY) / (double)h;
            sb.append(v1);
            sb.append('\t');
            sb.append(v2);
            sb.append('\t');
            sb.append(z);
            sb.append('\n');
        }
        return sb.toString();
    }

    private static class ProductListCellRenderer
    extends DefaultListCellRenderer {
        private ProductListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                this.setText(DensityPlotPanel.formatProductName((Product)value));
            }
            return this;
        }
    }

    private static class BandListCellRenderer
    extends DefaultListCellRenderer {
        private BandListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                this.setText(((RasterDataNode)value).getName());
            }
            return this;
        }
    }

    private static class DataSourceConfig {
        public boolean useRoiMask;
        public Mask roiMask;
        private Product xProduct;
        private Product yProduct;
        private RasterDataNode xBand;
        private RasterDataNode yBand;
        private Property xProductProperty;
        private Property yProductProperty;
        private Property xBandProperty;
        private Property yBandProperty;

        private DataSourceConfig() {
        }
    }
}

