/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.swing.binding.BindingContext;
import java.awt.Component;
import java.awt.GridBagConstraints;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.rcp.statistics.TitledSeparator;
import org.esa.snap.ui.GridBagUtils;
import org.jfree.chart.axis.ValueAxis;

public class AxisRangeControl {
    public static final String PROPERTY_NAME_AUTO_MIN_MAX = "autoMinMax";
    public static final String PROPERTY_NAME_MIN = "min";
    public static final String PROPERTY_NAME_MAX = "max";
    private final BindingContext bindingContext;
    private final String axisName;
    private JPanel panel;
    private TitledSeparator titledSeparator;

    public AxisRangeControl(String axisName) {
        this.axisName = axisName;
        PropertyContainer propertyContainer = PropertyContainer.createObjectBacked((Object)new Model());
        this.bindingContext = new BindingContext((PropertySet)propertyContainer);
    }

    public JPanel getPanel() {
        if (this.panel == null) {
            this.panel = this.createPanel();
            this.panel.setName(this.axisName);
        }
        return this.panel;
    }

    private JPanel createPanel() {
        JCheckBox autoMinMaxBox = new JCheckBox("Auto min/max");
        JLabel minLabel = new JLabel("Min:");
        JLabel maxLabel = new JLabel("Max:");
        JTextField minTextField = new JTextField();
        JTextField maxTextField = new JTextField();
        JPanel panel = GridBagUtils.createPanel();
        GridBagConstraints gbc = GridBagUtils.createConstraints((String)"anchor=WEST,fill=HORIZONTAL");
        GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"gridwidth=2,insets.top=2,weightx=1");
        this.titledSeparator = new TitledSeparator(this.axisName);
        GridBagUtils.addToPanel((JPanel)panel, (Component)this.titledSeparator, (GridBagConstraints)gbc, (String)"gridy=0,insets.right=-2");
        GridBagUtils.addToPanel((JPanel)panel, (Component)autoMinMaxBox, (GridBagConstraints)gbc, (String)"gridy=1");
        GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"gridwidth=1");
        GridBagUtils.addToPanel((JPanel)panel, (Component)minLabel, (GridBagConstraints)gbc, (String)"insets.left=22,gridx=0,gridy=2,weightx=0");
        GridBagUtils.addToPanel((JPanel)panel, (Component)minTextField, (GridBagConstraints)gbc, (String)"insets=2,gridx=1,gridy=2,weightx=1");
        GridBagUtils.addToPanel((JPanel)panel, (Component)maxLabel, (GridBagConstraints)gbc, (String)"insets.left=22,gridx=0,gridy=3,weightx=0");
        GridBagUtils.addToPanel((JPanel)panel, (Component)maxTextField, (GridBagConstraints)gbc, (String)"insets=2,gridx=1,gridy=3,weightx=1");
        this.bindingContext.bind(PROPERTY_NAME_AUTO_MIN_MAX, autoMinMaxBox);
        this.bindingContext.bind(PROPERTY_NAME_MIN, minTextField);
        this.bindingContext.bind(PROPERTY_NAME_MAX, maxTextField);
        this.bindingContext.getPropertySet().getDescriptor(PROPERTY_NAME_MIN).setDescription("Minimum display value for " + this.axisName);
        this.bindingContext.getPropertySet().getDescriptor(PROPERTY_NAME_MAX).setDescription("Maximum display value for " + this.axisName);
        this.bindingContext.getPropertySet().getDescriptor(PROPERTY_NAME_MIN).setValidator(new Validator(){

            public void validateValue(Property property, Object value) throws ValidationException {
                Double max = (Double)AxisRangeControl.this.bindingContext.getPropertySet().getValue(AxisRangeControl.PROPERTY_NAME_MAX);
                if ((Double)value >= max) {
                    throw new ValidationException("min value has to be less than " + max);
                }
            }
        });
        this.bindingContext.getPropertySet().getDescriptor(PROPERTY_NAME_MAX).setValidator(new Validator(){

            public void validateValue(Property property, Object value) throws ValidationException {
                Double min = (Double)AxisRangeControl.this.bindingContext.getPropertySet().getValue(AxisRangeControl.PROPERTY_NAME_MIN);
                if ((Double)value <= min) {
                    throw new ValidationException("max value has to be greater than " + min);
                }
            }
        });
        this.bindingContext.getBinding(PROPERTY_NAME_MIN).addComponent((JComponent)minLabel);
        this.bindingContext.getBinding(PROPERTY_NAME_MAX).addComponent((JComponent)maxLabel);
        this.bindingContext.bindEnabledState(PROPERTY_NAME_MIN, true, PROPERTY_NAME_AUTO_MIN_MAX, (Object)false);
        this.bindingContext.bindEnabledState(PROPERTY_NAME_MAX, true, PROPERTY_NAME_AUTO_MIN_MAX, (Object)false);
        return panel;
    }

    void addValidators() {
    }

    public void setTitleSuffix(String suffix) {
        JLabel label = this.titledSeparator.getLabelComponent();
        if (suffix == null || suffix.trim().length() == 0) {
            label.setText(this.axisName);
        } else {
            label.setText(this.axisName + " (" + suffix.trim() + ")");
        }
        this.titledSeparator.repaint();
    }

    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    public void setComponentsEnabled(boolean enabled) {
        if (!enabled) {
            for (Property property : this.bindingContext.getPropertySet().getProperties()) {
                this.bindingContext.setComponentsEnabled(property.getName(), enabled);
            }
        } else {
            for (Property property : this.bindingContext.getPropertySet().getProperties()) {
                if (property.getName().equals(PROPERTY_NAME_MIN) || property.getName().equals(PROPERTY_NAME_MAX)) {
                    this.bindingContext.setComponentsEnabled(property.getName(), !this.isAutoMinMax());
                    continue;
                }
                this.bindingContext.setComponentsEnabled(property.getName(), enabled);
            }
        }
    }

    public boolean isAutoMinMax() {
        return (Boolean)this.bindingContext.getBinding(PROPERTY_NAME_AUTO_MIN_MAX).getPropertyValue();
    }

    public void adjustComponents(ValueAxis axis, int numDecimalPlaces) {
        this.adjustComponents(axis.getLowerBound(), axis.getUpperBound(), numDecimalPlaces);
    }

    public void adjustComponents(double min, double max, int numDecimalPlaces) {
        Double oldMax = this.getMax();
        double newMax = MathUtils.round((double)max, (double)this.roundFactor(numDecimalPlaces));
        double newMin = MathUtils.round((double)min, (double)this.roundFactor(numDecimalPlaces));
        if (newMin == newMax) {
            newMax += Math.pow(10.0, -numDecimalPlaces);
        }
        if (newMin >= oldMax) {
            this.setMax(newMax);
            this.setMin(newMin);
        } else {
            this.setMin(newMin);
            this.setMax(newMax);
        }
    }

    public void adjustAxis(ValueAxis axis, int numDecimalPlaces) {
        double lowerRange = MathUtils.round((double)((Double)this.getBindingContext().getBinding(PROPERTY_NAME_MIN).getPropertyValue()), (double)this.roundFactor(numDecimalPlaces));
        double upperRange = MathUtils.round((double)((Double)this.getBindingContext().getBinding(PROPERTY_NAME_MAX).getPropertyValue()), (double)this.roundFactor(numDecimalPlaces));
        axis.setRange(lowerRange, upperRange);
    }

    private double roundFactor(int n) {
        return Math.pow(10.0, n);
    }

    public Double getMin() {
        return (Double)this.getBindingContext().getPropertySet().getValue(PROPERTY_NAME_MIN);
    }

    public Double getMax() {
        return (Double)this.getBindingContext().getPropertySet().getValue(PROPERTY_NAME_MAX);
    }

    private void setMin(double min) {
        this.getBindingContext().getPropertySet().setValue(PROPERTY_NAME_MIN, (Object)min);
    }

    private void setMax(double max) {
        this.getBindingContext().getPropertySet().setValue(PROPERTY_NAME_MAX, (Object)max);
    }

    private static class Model {
        private boolean autoMinMax = true;
        private double min = 0.0;
        private double max = 100.0;

        private Model() {
        }
    }
}

