/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.spectrum;

import com.bc.ceres.glayer.support.ImageLayer;
import java.awt.event.MouseEvent;
import javax.swing.SwingWorker;
import org.esa.snap.rcp.spectrum.SpectrumTopComponent;
import org.esa.snap.rcp.spectrum.WorkerChain;
import org.esa.snap.ui.PixelPositionListener;

public class CursorSpectrumPixelPositionListener
implements PixelPositionListener {
    private final SpectrumTopComponent topComponent;
    private final WorkerChain workerChain;
    private final WorkerChainSupport support;

    public CursorSpectrumPixelPositionListener(SpectrumTopComponent topComponent) {
        this.topComponent = topComponent;
        this.workerChain = new WorkerChain();
        this.support = new WorkerChainSupport(){

            @Override
            public void removeWorkerAndStartNext(SwingWorker worker) {
                CursorSpectrumPixelPositionListener.this.workerChain.removeCurrentWorkerAndExecuteNext(worker);
            }
        };
    }

    public void pixelPosChanged(ImageLayer imageLayer, int pixelX, int pixelY, int currentLevel, boolean pixelPosValid, MouseEvent e) {
        CursorSpectraUpdater worker = new CursorSpectraUpdater(pixelPosValid, pixelX, pixelY, currentLevel, e.isShiftDown(), this.support);
        this.workerChain.setOrExecuteNextWorker(worker, false);
    }

    public void pixelPosNotAvailable() {
        CursorSpectraRemover worker = new CursorSpectraRemover(this.support);
        this.workerChain.setOrExecuteNextWorker(worker, false);
    }

    private boolean shouldUpdateCursorPosition() {
        return this.topComponent.isVisible() && this.topComponent.isShowingCursorSpectrum();
    }

    static interface WorkerChainSupport {
        public void removeWorkerAndStartNext(SwingWorker var1);
    }

    private class Waiter
    extends SwingWorker<Void, Void> {
        private Waiter() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            Thread.sleep(1000L);
            return null;
        }

        @Override
        protected void done() {
            CursorSpectrumPixelPositionListener.this.topComponent.setPrepareForUpdateMessage();
        }
    }

    private class CursorSpectraUpdater
    extends SwingWorker<Void, Void> {
        private final boolean pixelPosValid;
        private final int pixelX;
        private final int pixelY;
        private final int currentLevel;
        private final boolean adjustAxes;
        private final WorkerChainSupport support;

        CursorSpectraUpdater(boolean pixelPosValid, int pixelX, int pixelY, int currentLevel, boolean adjustAxes, WorkerChainSupport support) {
            this.pixelPosValid = pixelPosValid;
            this.pixelX = pixelX;
            this.pixelY = pixelY;
            this.currentLevel = currentLevel;
            this.adjustAxes = adjustAxes;
            this.support = support;
        }

        @Override
        protected Void doInBackground() throws Exception {
            if (CursorSpectrumPixelPositionListener.this.shouldUpdateCursorPosition()) {
                Waiter waiter = new Waiter();
                waiter.execute();
                CursorSpectrumPixelPositionListener.this.topComponent.updateData(this.pixelX, this.pixelY, this.currentLevel, this.pixelPosValid);
                waiter.cancel(true);
            }
            return null;
        }

        @Override
        protected void done() {
            try {
                CursorSpectrumPixelPositionListener.this.topComponent.updateChart(this.adjustAxes);
            }
            finally {
                this.support.removeWorkerAndStartNext(this);
            }
        }
    }

    private class CursorSpectraRemover
    extends SwingWorker<Void, Void> {
        private final WorkerChainSupport support;

        CursorSpectraRemover(WorkerChainSupport support) {
            this.support = support;
        }

        @Override
        protected Void doInBackground() throws Exception {
            if (CursorSpectrumPixelPositionListener.this.shouldUpdateCursorPosition()) {
                CursorSpectrumPixelPositionListener.this.topComponent.removeCursorSpectraFromDataset();
            }
            return null;
        }

        @Override
        protected void done() {
            CursorSpectrumPixelPositionListener.this.topComponent.updateChart();
            this.support.removeWorkerAndStartNext(this);
        }
    }
}

