/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.placemark;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Point;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.undo.UndoableEdit;
import org.esa.snap.core.dataio.placemark.PlacemarkData;
import org.esa.snap.core.dataio.placemark.PlacemarkIO;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PinDescriptor;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.PlacemarkNameFactory;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.netbeans.docwin.WindowUtilities;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.placemark.PlacemarkDialog;
import org.esa.snap.rcp.placemark.PlacemarkManagerButtons;
import org.esa.snap.rcp.placemark.ProductChooser;
import org.esa.snap.rcp.placemark.TableModelFactory;
import org.esa.snap.rcp.placemark.UndoablePlacemarkActionFactory;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.rcp.util.SelectionSupport;
import org.esa.snap.rcp.windows.ProductSceneViewTopComponent;
import org.esa.snap.runtime.Config;
import org.esa.snap.ui.DecimalCellEditor;
import org.esa.snap.ui.DecimalTableCellRenderer;
import org.esa.snap.ui.SnapFileChooser;
import org.esa.snap.ui.color.ColorTableCellEditor;
import org.esa.snap.ui.color.ColorTableCellRenderer;
import org.esa.snap.ui.product.AbstractPlacemarkTableModel;
import org.esa.snap.ui.product.BandChooser;
import org.esa.snap.ui.product.ProductSceneView;
import org.esa.snap.ui.product.VectorDataLayer;
import org.openide.awt.UndoRedo;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;

public class PlacemarkManagerTopComponent
extends TopComponent
implements UndoRedo.Provider,
HelpCtx.Provider {
    public static final String PREFERENCE_KEY_PIN_IO_DIR = "pin.io.dir";
    private static final String PREFERENCE_KEY_ADJUST_PIN_GEO_POS = "snap.adjustPinGeoPos";
    private final PlacemarkDescriptor placemarkDescriptor;
    private final Preferences preferences;
    private SnapApp snapApp;
    private final HashMap<Product, Band[]> productToSelectedBands;
    private final HashMap<Product, TiePointGrid[]> productToSelectedGrids;
    private Product product;
    private JTable placemarkTable;
    private PlacemarkListener placemarkListener;
    private Band[] selectedBands;
    private TiePointGrid[] selectedGrids;
    private boolean synchronizingPlacemarkSelectedState;
    private AbstractPlacemarkTableModel placemarkTableModel;
    private PlacemarkManagerButtons buttonPane;
    private ProductSceneView currentView;
    private final SelectionChangeListener selectionChangeHandler;
    private final List<List<Placemark>> relatedPlacemarks;
    private final boolean adjustPinGeoPos;

    public PlacemarkManagerTopComponent(PlacemarkDescriptor placemarkDescriptor, TableModelFactory modelFactory) {
        this.placemarkDescriptor = placemarkDescriptor;
        this.snapApp = SnapApp.getDefault();
        this.preferences = this.snapApp.getPreferences();
        this.productToSelectedBands = new HashMap(50);
        this.productToSelectedGrids = new HashMap(50);
        this.placemarkTableModel = modelFactory.createTableModel(placemarkDescriptor, this.product, null, null);
        this.selectionChangeHandler = new ViewSelectionChangeHandler();
        this.relatedPlacemarks = new ArrayList<List<Placemark>>();
        this.adjustPinGeoPos = Config.instance().preferences().getBoolean(PREFERENCE_KEY_ADJUST_PIN_GEO_POS, true);
        this.initUI();
        this.setDisplayName(this.getTitle());
    }

    public void initUI() {
        this.setLayout(new BorderLayout());
        this.placemarkTable = new JTable((TableModel)this.placemarkTableModel);
        this.placemarkTable.setRowSorter(new TableRowSorter<AbstractPlacemarkTableModel>(this.placemarkTableModel));
        this.placemarkTable.setName("placemarkTable");
        this.placemarkTable.setAutoResizeMode(0);
        this.placemarkTable.setSelectionMode(2);
        this.placemarkTable.setRowSelectionAllowed(true);
        this.placemarkTable.getTableHeader().setReorderingAllowed(false);
        ToolTipSetter toolTipSetter = new ToolTipSetter();
        this.placemarkTable.addMouseMotionListener(toolTipSetter);
        this.placemarkTable.addMouseListener(toolTipSetter);
        this.placemarkTable.addMouseListener(new PopupListener());
        this.placemarkTable.getSelectionModel().addListSelectionListener(new PlacemarkTableSelectionHandler());
        this.updateTableModel();
        TableColumnModel columnModel = this.placemarkTable.getColumnModel();
        columnModel.addColumnModelListener(new ColumnModelListener());
        JScrollPane tableScrollPane = new JScrollPane(this.placemarkTable);
        JPanel mainPane = new JPanel(new BorderLayout(4, 4));
        mainPane.add((Component)tableScrollPane, "Center");
        this.buttonPane = new PlacemarkManagerButtons(this);
        JPanel content = new JPanel(new BorderLayout(4, 4));
        content.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        content.add("Center", mainPane);
        content.add("East", this.buttonPane);
        Component southExtension = this.getSouthExtension();
        if (southExtension != null) {
            content.add("South", southExtension);
        }
        content.setPreferredSize(new Dimension(420, 200));
        this.setCurrentView(this.snapApp.getSelectedProductSceneView());
        this.setProduct(this.snapApp.getSelectedProduct(SnapApp.SelectionSourceHint.VIEW));
        this.snapApp.getSelectionSupport(ProductSceneView.class).addHandler(new ProductSceneViewSelectionChangeHandler());
        this.snapApp.getProductManager().addListener((ProductManager.Listener)new ProductRemovedListener());
        this.updateUIState();
        this.add(content, "Center");
    }

    void applyFilteredGrids() {
        if (this.product != null) {
            Band[] allBands = this.product.getBands();
            TiePointGrid[] allGrids = this.product.getTiePointGrids();
            BandChooser bandChooser = new BandChooser(SwingUtilities.getWindowAncestor((Component)((Object)this)), "Available Bands And Tie Point Grids", this.getHelpId(), false, allBands, this.selectedBands, allGrids, this.selectedGrids, true);
            if (bandChooser.show() == 1) {
                this.selectedBands = bandChooser.getSelectedBands();
                this.selectedGrids = bandChooser.getSelectedTiePointGrids();
                this.productToSelectedBands.put(this.product, this.selectedBands);
                this.productToSelectedGrids.put(this.product, this.selectedGrids);
                this.updateTableModel();
            }
        }
    }

    PlacemarkDescriptor getPlacemarkDescriptor() {
        return this.placemarkDescriptor;
    }

    private void setCurrentView(ProductSceneView sceneView) {
        if (sceneView != this.currentView) {
            if (this.currentView != null) {
                this.currentView.getSelectionContext().removeSelectionChangeListener(this.selectionChangeHandler);
            }
            this.currentView = sceneView;
            if (this.currentView != null) {
                this.currentView.getSelectionContext().addSelectionChangeListener(this.selectionChangeHandler);
                this.setProduct(this.currentView.getProduct());
            } else {
                this.setProduct(null);
            }
        }
    }

    protected final Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        if (this.product == product) {
            return;
        }
        Product oldProduct = this.product;
        if (oldProduct != null) {
            oldProduct.removeProductNodeListener((ProductNodeListener)this.placemarkListener);
        }
        this.product = product;
        this.selectedBands = this.productToSelectedBands.get(this.product);
        this.selectedGrids = this.productToSelectedGrids.get(this.product);
        if (this.product != null) {
            if (this.placemarkListener == null) {
                this.placemarkListener = new PlacemarkListener();
            }
            this.product.addProductNodeListener((ProductNodeListener)this.placemarkListener);
        }
        this.updateTableModel();
        this.updatePlacemarkTableSelectionFromView();
        this.updateUIState();
    }

    protected String getTitle() {
        return "";
    }

    protected String getHelpId() {
        return null;
    }

    protected Component getSouthExtension() {
        return null;
    }

    private void updateTableModel() {
        this.placemarkTableModel.setProduct(this.product);
        this.placemarkTableModel.setSelectedBands(this.selectedBands);
        this.placemarkTableModel.setSelectedGrids(this.selectedGrids);
        this.addCellRenderer(this.placemarkTable.getColumnModel());
        this.addCellEditor(this.placemarkTable.getColumnModel());
    }

    protected void addCellRenderer(TableColumnModel columnModel) {
        columnModel.getColumn(0).setCellRenderer((TableCellRenderer)new DecimalTableCellRenderer(new DecimalFormat("0.000")));
        columnModel.getColumn(1).setCellRenderer((TableCellRenderer)new DecimalTableCellRenderer(new DecimalFormat("0.000")));
        columnModel.getColumn(2).setCellRenderer((TableCellRenderer)new DecimalTableCellRenderer(new DecimalFormat("0.000000")));
        columnModel.getColumn(3).setCellRenderer((TableCellRenderer)new DecimalTableCellRenderer(new DecimalFormat("0.000000")));
        columnModel.getColumn(4).setCellRenderer((TableCellRenderer)new ColorTableCellRenderer());
        columnModel.getColumn(5).setCellRenderer(new RightAlignmentTableCellRenderer());
    }

    protected void addCellEditor(TableColumnModel columnModel) {
        DecimalCellEditor pixelCellEditor = new DecimalCellEditor();
        columnModel.getColumn(0).setCellEditor((TableCellEditor)pixelCellEditor);
        columnModel.getColumn(1).setCellEditor((TableCellEditor)pixelCellEditor);
        columnModel.getColumn(2).setCellEditor((TableCellEditor)new DecimalCellEditor(-180.0, 180.0));
        columnModel.getColumn(3).setCellEditor((TableCellEditor)new DecimalCellEditor(-90.0, 90.0));
        columnModel.getColumn(4).setCellEditor((TableCellEditor)new ColorTableCellEditor());
    }

    private ProductSceneView getSceneView() {
        ProductSceneView selectedProductSceneView = this.snapApp.getSelectedProductSceneView();
        if (selectedProductSceneView == null && this.product != null) {
            TiePointGrid[] tiePointGrids;
            Band[] bands;
            for (Band band : bands = this.product.getBands()) {
                ProductSceneViewTopComponent productSceneViewTopComponent = this.getProductSceneViewTopComponent((RasterDataNode)band);
                if (productSceneViewTopComponent == null) continue;
                return productSceneViewTopComponent.getView();
            }
            for (TiePointGrid tiePointGrid : tiePointGrids = this.product.getTiePointGrids()) {
                ProductSceneViewTopComponent productSceneViewTopComponent = this.getProductSceneViewTopComponent((RasterDataNode)tiePointGrid);
                if (productSceneViewTopComponent == null) continue;
                return productSceneViewTopComponent.getView();
            }
        }
        return selectedProductSceneView;
    }

    private ProductSceneViewTopComponent getProductSceneViewTopComponent(RasterDataNode raster) {
        return WindowUtilities.getOpened(ProductSceneViewTopComponent.class).filter(topComponent -> raster == topComponent.getView().getRaster()).findFirst().orElse(null);
    }

    private Placemark getPlacemarkAt(int selectedRow) {
        Placemark placemark = null;
        if (this.product != null && selectedRow > -1 && selectedRow < this.getPlacemarkGroup(this.product).getNodeCount()) {
            placemark = (Placemark)this.getPlacemarkGroup(this.product).get(selectedRow);
        }
        return placemark;
    }

    void newPin() {
        Guardian.assertNotNull((String)"product", (Object)this.product);
        String[] uniquePinNameAndLabel = PlacemarkNameFactory.createUniqueNameAndLabel((PlacemarkDescriptor)this.placemarkDescriptor, (Product)this.product);
        Placemark newPlacemark = Placemark.createPointPlacemark((PlacemarkDescriptor)this.placemarkDescriptor, (String)uniquePinNameAndLabel[0], (String)uniquePinNameAndLabel[1], (String)"", (PixelPos)new PixelPos(0.0, 0.0), null, (GeoCoding)this.product.getSceneGeoCoding());
        if (PlacemarkDialog.showEditPlacemarkDialog(SwingUtilities.getWindowAncestor((Component)((Object)this)), this.product, newPlacemark, this.placemarkDescriptor)) {
            this.makePlacemarkNameUnique(newPlacemark);
            UndoRedo.Manager undoManager = SnapApp.getDefault().getUndoManager(this.product);
            if (undoManager != null) {
                undoManager.addEdit((UndoableEdit)UndoablePlacemarkActionFactory.createUndoablePlacemarkInsertion(this.product, newPlacemark, this.placemarkDescriptor));
            }
            this.updateUIState();
        }
    }

    void copyActivePlacemark() {
        Guardian.assertNotNull((String)"product", (Object)this.product);
        Placemark activePlacemark = this.getSelectedPlacemark();
        Guardian.assertNotNull((String)"activePlacemark", (Object)activePlacemark);
        Placemark newPlacemark = Placemark.createPointPlacemark((PlacemarkDescriptor)activePlacemark.getDescriptor(), (String)("copy_of_" + activePlacemark.getName()), (String)activePlacemark.getLabel(), (String)activePlacemark.getDescription(), (PixelPos)activePlacemark.getPixelPos(), (GeoPos)activePlacemark.getGeoPos(), (GeoCoding)activePlacemark.getProduct().getSceneGeoCoding());
        newPlacemark.setStyleCss(activePlacemark.getStyleCss());
        if (PlacemarkDialog.showEditPlacemarkDialog(SwingUtilities.getWindowAncestor((Component)((Object)this)), this.product, newPlacemark, this.placemarkDescriptor)) {
            this.makePlacemarkNameUnique(newPlacemark);
            UndoRedo.Manager undoManager = SnapApp.getDefault().getUndoManager(this.product);
            if (undoManager != null) {
                undoManager.addEdit((UndoableEdit)UndoablePlacemarkActionFactory.createUndoablePlacemarkCopying(this.product, newPlacemark, this.placemarkDescriptor));
            }
            this.updateUIState();
        }
    }

    private ProductNodeGroup<Placemark> getPlacemarkGroup(Product product) {
        return this.placemarkDescriptor.getPlacemarkGroup(product);
    }

    void editActivePin() {
        Guardian.assertNotNull((String)"product", (Object)this.product);
        Placemark activePlacemark = this.getSelectedPlacemark();
        Placemark originalPlacemark = Placemark.createPointPlacemark((PlacemarkDescriptor)activePlacemark.getDescriptor(), (String)activePlacemark.getName(), (String)activePlacemark.getLabel(), (String)activePlacemark.getDescription(), (PixelPos)activePlacemark.getPixelPos(), (GeoPos)activePlacemark.getGeoPos(), (GeoCoding)activePlacemark.getProduct().getSceneGeoCoding());
        Guardian.assertNotNull((String)"activePlacemark", (Object)activePlacemark);
        if (PlacemarkDialog.showEditPlacemarkDialog(SwingUtilities.getWindowAncestor((Component)((Object)this)), this.product, activePlacemark, this.placemarkDescriptor)) {
            this.makePlacemarkNameUnique(activePlacemark);
            UndoRedo.Manager undoManager = SnapApp.getDefault().getUndoManager(this.product);
            if (undoManager != null) {
                undoManager.addEdit((UndoableEdit)UndoablePlacemarkActionFactory.createUndoablePlacemarkEditing(this.product, originalPlacemark, activePlacemark, this.placemarkDescriptor));
            }
            this.updateUIState();
        }
    }

    void removeSelectedPins() {
        UndoRedo.Manager undoManager;
        List<Placemark> placemarks = this.getSelectedPlacemarks();
        for (Placemark placemark : placemarks) {
            this.getPlacemarkGroup(this.product).remove((ProductNode)placemark);
        }
        int selectedRow = this.placemarkTable.getSelectedRow();
        if (selectedRow >= this.getPlacemarkGroup(this.product).getNodeCount()) {
            selectedRow = this.getPlacemarkGroup(this.product).getNodeCount() - 1;
        }
        if (selectedRow >= 0) {
            this.placemarkTable.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
        }
        if ((undoManager = SnapApp.getDefault().getUndoManager(this.product)) != null) {
            undoManager.addEdit((UndoableEdit)UndoablePlacemarkActionFactory.createUndoablePlacemarkRemoval(this.product, placemarks, this.placemarkDescriptor));
        }
        this.updateUIState();
    }

    private int getNumSelectedPlacemarks() {
        int[] rowIndexes = this.placemarkTable.getSelectedRows();
        return rowIndexes != null ? rowIndexes.length : 0;
    }

    private Placemark getSelectedPlacemark() {
        int rowIndex = this.placemarkTable.getSelectedRow();
        if (rowIndex >= 0) {
            int modelIndex = this.placemarkTable.convertRowIndexToModel(rowIndex);
            return this.placemarkTableModel.getPlacemarkAt(modelIndex);
        }
        return null;
    }

    private List<Placemark> getSelectedPlacemarks() {
        ArrayList<Placemark> placemarkList = new ArrayList<Placemark>();
        int[] sortedRowIndexes = this.placemarkTable.getSelectedRows();
        if (sortedRowIndexes != null) {
            for (int rowIndex : sortedRowIndexes) {
                int modelRowIndex = this.placemarkTable.convertRowIndexToModel(rowIndex);
                placemarkList.add(this.placemarkTableModel.getPlacemarkAt(modelRowIndex));
            }
        }
        return placemarkList;
    }

    void zoomToActivePin() {
        Guardian.assertNotNull((String)"product", (Object)this.product);
        Placemark activePlacemark = this.getSelectedPlacemark();
        Guardian.assertNotNull((String)"activePlacemark", (Object)activePlacemark);
        ProductSceneView view = this.getSceneView();
        Object placemarkGeometry = activePlacemark.getFeature().getDefaultGeometry();
        if (placemarkGeometry != null && placemarkGeometry instanceof Point) {
            Coordinate coordinate = ((Point)placemarkGeometry).getCoordinate();
            Point2D.Double modelPos = new Point2D.Double(coordinate.x, coordinate.y);
            view.zoom(((Point2D)modelPos).getX(), ((Point2D)modelPos).getY(), view.getZoomFactor());
            this.updateUIState();
        }
    }

    private void makePlacemarkNameUnique(Placemark newPlacemark) {
        if (this.makePlacemarkNameUnique0(newPlacemark, this.product)) {
            Dialogs.showWarning(MessageFormat.format("{0} has been renamed to ''{1}'',\nbecause a {2} with the former name already exists.", StringUtils.firstLetterUp((String)this.placemarkDescriptor.getRoleLabel()), newPlacemark.getName(), this.placemarkDescriptor.getRoleLabel()));
        }
    }

    protected void updateUIState() {
        boolean productSelected = this.product != null;
        int numSelectedPins = 0;
        if (productSelected) {
            this.updatePlacemarkTableSelectionFromView();
            numSelectedPins = this.getNumSelectedPlacemarks();
        }
        this.placemarkTable.setEnabled(productSelected);
        this.buttonPane.updateUIState(productSelected, this.placemarkTable.getRowCount(), numSelectedPins);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePlacemarkTableSelectionFromView() {
        if (!this.synchronizingPlacemarkSelectedState) {
            try {
                this.synchronizingPlacemarkSelectedState = true;
                if (this.product != null) {
                    Placemark[] placemarks = this.placemarkTableModel.getPlacemarks();
                    for (int i = 0; i < placemarks.length; ++i) {
                        if (i >= this.placemarkTable.getRowCount()) continue;
                        Placemark placemark = placemarks[i];
                        int sortedRowAt = this.placemarkTable.convertRowIndexToView(i);
                        boolean selected = this.isPlacemarkSelectedInView(placemark);
                        if (selected == this.placemarkTable.isRowSelected(sortedRowAt)) continue;
                        if (selected) {
                            this.placemarkTable.getSelectionModel().addSelectionInterval(sortedRowAt, sortedRowAt);
                            continue;
                        }
                        this.placemarkTable.getSelectionModel().removeSelectionInterval(sortedRowAt, sortedRowAt);
                    }
                }
                this.placemarkTable.revalidate();
                this.placemarkTable.repaint();
            }
            finally {
                this.synchronizingPlacemarkSelectedState = false;
            }
        }
    }

    void importPlacemarks(boolean allPlacemarks) {
        List<Placemark> placemarks;
        try {
            placemarks = this.loadPlacemarksFromFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            Dialogs.showError(MessageFormat.format("I/O error, failed to import {0}s:\n{1}", this.placemarkDescriptor.getRoleLabel(), e.getMessage()));
            return;
        }
        if (placemarks.isEmpty()) {
            return;
        }
        this.addPlacemarksToProduct(placemarks, this.product, allPlacemarks);
    }

    void addPlacemarksToProduct(List<Placemark> placemarks, Product targetProduct, boolean allPlacemarks) {
        GeoCoding geoCoding = targetProduct.getSceneGeoCoding();
        boolean canGetPixelPos = geoCoding != null && geoCoding.canGetPixelPos();
        boolean isPin = this.placemarkDescriptor instanceof PinDescriptor;
        int numPinsOutOfBounds = 0;
        int numPinsRenamed = 0;
        int numInvalids = 0;
        for (Placemark placemark : placemarks) {
            if (this.makePlacemarkNameUnique0(placemark, targetProduct)) {
                ++numPinsRenamed;
                placemark = this.createTransferrablePlacemark(placemark, targetProduct);
            }
            PixelPos pixelPos = placemark.getPixelPos();
            boolean productContainsPixelPos = targetProduct.containsPixel(pixelPos);
            if (!canGetPixelPos && isPin && !productContainsPixelPos) {
                ++numInvalids;
                continue;
            }
            if (canGetPixelPos && this.adjustPinGeoPos) {
                this.placemarkDescriptor.updatePixelPos(geoCoding, placemark.getGeoPos(), pixelPos);
            }
            if (!productContainsPixelPos && isPin) {
                ++numPinsOutOfBounds;
            } else {
                this.getPlacemarkGroup(targetProduct).add((ProductNode)placemark);
                if (this.adjustPinGeoPos) {
                    placemark.setPixelPos(pixelPos);
                } else {
                    placemark.setGeoPos(placemark.getGeoPos());
                }
            }
            if (allPlacemarks) continue;
            break;
        }
        String intoProductMessage = "";
        if (targetProduct != this.product) {
            intoProductMessage = "into product " + targetProduct.getDisplayName() + "\n";
        }
        if (numInvalids > 0) {
            Dialogs.showWarning(MessageFormat.format("One or more {0}s have not been imported,\n{1}because they can not be assigned to a product without a geo-coding.", this.placemarkDescriptor.getRoleLabel(), intoProductMessage));
        }
        if (numPinsRenamed > 0) {
            Dialogs.showWarning(MessageFormat.format("One or more {0}s have been renamed,\n{1}because their former names are already existing.", this.placemarkDescriptor.getRoleLabel(), intoProductMessage));
        }
        if (numPinsOutOfBounds > 0) {
            if (numPinsOutOfBounds == placemarks.size()) {
                Dialogs.showError(MessageFormat.format("No {0}s have been imported,\n{1}because their pixel positions\nare outside the product''s bounds.", this.placemarkDescriptor.getRoleLabel(), intoProductMessage));
            } else {
                Dialogs.showError(MessageFormat.format("{0} {1}s have not been imported,\n{2}because their pixel positions\nare outside the product''s bounds.", numPinsOutOfBounds, this.placemarkDescriptor.getRoleLabel(), intoProductMessage));
            }
        }
    }

    private boolean isPlacemarkSelectedInView(Placemark placemark) {
        boolean selected = false;
        ProductSceneView sceneView = this.getSceneView();
        if (sceneView != null) {
            selected = this.getPlacemarkDescriptor() instanceof PinDescriptor ? sceneView.isPinSelected(placemark) : sceneView.isGcpSelected(placemark);
        }
        return selected;
    }

    private boolean makePlacemarkNameUnique0(Placemark placemark, Product targetProduct) {
        String label0;
        String name0;
        ProductNodeGroup<Placemark> placemarkGroup = this.getPlacemarkGroup(targetProduct);
        if (placemarkGroup.get(placemark.getName()) == placemark) {
            return false;
        }
        String name = name0 = placemark.getName();
        String label = label0 = placemark.getLabel();
        int id = 1;
        while (placemarkGroup.contains(name)) {
            if (((Placemark)placemarkGroup.get(name)).getLabel().equals(label)) {
                label = label0 + "_" + id;
            }
            name = name0 + "_" + id;
            ++id;
        }
        if (!name0.equals(name)) {
            placemark.setName(name);
            if (!label0.equals(label)) {
                placemark.setLabel(label);
            }
            return true;
        }
        return false;
    }

    private List<Placemark> loadPlacemarksFromFile() throws IOException {
        File file;
        SnapFileChooser fileChooser = new SnapFileChooser();
        String roleLabel = StringUtils.firstLetterUp((String)this.placemarkDescriptor.getRoleLabel());
        fileChooser.setDialogTitle("Import " + roleLabel + "s");
        this.setComponentName((JComponent)fileChooser, "Import");
        fileChooser.addChoosableFileFilter((FileFilter)PlacemarkIO.createTextFileFilter());
        fileChooser.setFileFilter((FileFilter)PlacemarkIO.createPlacemarkFileFilter());
        fileChooser.setCurrentDirectory(this.getIODir());
        int result = fileChooser.showOpenDialog((Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        if (result == 0 && (file = fileChooser.getSelectedFile()) != null) {
            this.setIODir(file.getAbsoluteFile().getParentFile());
            GeoCoding geoCoding = null;
            if (this.product != null) {
                geoCoding = this.product.getSceneGeoCoding();
            }
            return PlacemarkIO.readPlacemarks((Reader)new FileReader(file), (GeoCoding)geoCoding, (PlacemarkDescriptor)this.placemarkDescriptor);
        }
        return Collections.emptyList();
    }

    void exportPlacemarks() {
        block43: {
            File file;
            SnapFileChooser fileChooser = new SnapFileChooser();
            fileChooser.setDialogTitle(MessageFormat.format("Export {0}(s)", StringUtils.firstLetterUp((String)this.placemarkDescriptor.getRoleLabel())));
            this.setComponentName((JComponent)fileChooser, "Export_Selected");
            fileChooser.addChoosableFileFilter((FileFilter)PlacemarkIO.createTextFileFilter());
            fileChooser.addChoosableFileFilter((FileFilter)PlacemarkIO.createKmzFileFilter());
            fileChooser.setFileFilter((FileFilter)PlacemarkIO.createPlacemarkFileFilter());
            File ioDir = this.getIODir();
            fileChooser.setCurrentDirectory(ioDir);
            fileChooser.setSelectedFile(new File(ioDir, this.placemarkDescriptor.getRoleName()));
            int result = fileChooser.showSaveDialog((Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
            if (result == 0 && (file = fileChooser.getSelectedFile()) != null && Boolean.TRUE.equals(Dialogs.requestOverwriteDecision(this.getTitle(), file))) {
                this.setIODir(file.getAbsoluteFile().getParentFile());
                SnapFileFilter snapFileFilter = fileChooser.getSnapFileFilter();
                String fileExtension = FileUtils.getExtension((File)file);
                if (fileExtension == null || !StringUtils.contains((String[])snapFileFilter.getExtensions(), (String)fileExtension)) {
                    file = FileUtils.ensureExtension((File)file, (String)snapFileFilter.getDefaultExtension());
                }
                try {
                    String formatName = snapFileFilter.getFormatName();
                    if (formatName.equals(PlacemarkIO.createPlacemarkFileFilter().getFormatName())) {
                        try (FileWriter writer = new FileWriter(file);){
                            List<Placemark> placemarkList = this.getPlacemarksForExport();
                            PlacemarkIO.writePlacemarksFile((Writer)writer, placemarkList);
                            break block43;
                        }
                    }
                    if (formatName.equals(PlacemarkIO.createTextFileFilter().getFormatName())) {
                        try (FileWriter writer = new FileWriter(file);){
                            this.writePlacemarkDataTableText(writer);
                            break block43;
                        }
                    }
                    if (formatName.equals(PlacemarkIO.createKmzFileFilter().getFormatName())) {
                        try (FileOutputStream outStream = new FileOutputStream(file);){
                            List<Placemark> placemarkList = this.getPlacemarksForExport();
                            List<PlacemarkData> placemarkData = this.getExtraDataFromTable(placemarkList);
                            PlacemarkIO.writePlacemarkKmzFile((OutputStream)outStream, placemarkData, (ProgressMonitor)ProgressMonitor.NULL);
                            break block43;
                        }
                    }
                    Dialogs.showError(String.format("Unknown export format '%s'. Nothing has been exported.", formatName));
                }
                catch (IOException ioe) {
                    Dialogs.showError(String.format("I/O Error.\n   Failed to export %ss.\n%s", this.placemarkDescriptor.getRoleLabel(), ioe.getMessage()));
                    ioe.printStackTrace();
                }
            }
        }
    }

    private List<PlacemarkData> getExtraDataFromTable(List<Placemark> placemarkList) {
        ArrayList<PlacemarkData> list = new ArrayList<PlacemarkData>();
        String[] additionalColumnNames = this.placemarkTableModel.getAdditionalColumnNames();
        for (int rowIndex = 0; rowIndex < this.placemarkTableModel.getRowCount(); ++rowIndex) {
            Placemark placemark = this.placemarkTableModel.getPlacemarkAt(rowIndex);
            if (!placemarkList.contains(placemark)) continue;
            LinkedHashMap<String, Object> extraData = new LinkedHashMap<String, Object>();
            for (String additionalColumnName : additionalColumnNames) {
                int columnIndex = this.placemarkTableModel.getColumnIndex(additionalColumnName);
                if (columnIndex < 0) continue;
                Object valueAt = this.placemarkTableModel.getValueAt(rowIndex, columnIndex);
                extraData.put(additionalColumnName, valueAt);
            }
            list.add(new PlacemarkData(placemark, extraData.isEmpty() ? null : extraData));
        }
        return list;
    }

    private List<Placemark> getPlacemarksForExport() {
        boolean noPlacemarksSelected = this.placemarkTable.getSelectionModel().isSelectionEmpty();
        List<Placemark> placemarkList = noPlacemarksSelected ? Arrays.asList(this.placemarkTableModel.getPlacemarks()) : this.getSelectedPlacemarks();
        return placemarkList;
    }

    void transferPlacemarks() {
        Product thisProduct = this.getProduct();
        Product[] allProducts = this.snapApp.getProductManager().getProducts();
        if (allProducts.length < 2 || thisProduct == null) {
            return;
        }
        Product[] allOtherProducts = new Product[allProducts.length - 1];
        int allOtherProductsIndex = 0;
        for (Product product : allProducts) {
            if (product == thisProduct) continue;
            allOtherProducts[allOtherProductsIndex++] = product;
        }
        ProductChooser productChooser = new ProductChooser(this.snapApp.getMainFrame(), this.getTitle(), this.getHelpId(), allOtherProducts, null);
        int buttonID = productChooser.show();
        System.out.println("buttonID = " + buttonID);
        if (buttonID == 1) {
            List<Placemark> placemarks = this.getPlacemarksForExport();
            Product[] selectedProducts = productChooser.getSelectedProducts();
            boolean notAlreadyAsked = true;
            boolean updateExistingPins = true;
            for (Product selectedProduct : selectedProducts) {
                ArrayList<Placemark> placemarksCopy = new ArrayList<Placemark>(placemarks.size());
                for (Placemark placemark : placemarks) {
                    Placemark[] existingPlacemarks = this.getExistingPlacemarks(placemark, selectedProduct);
                    if (existingPlacemarks.length > 0) {
                        if (notAlreadyAsked) {
                            notAlreadyAsked = false;
                            Dialogs.Answer answer = Dialogs.requestDecision("Transfer placemarks", "Do you want to update existing placemarks?", false, null);
                            boolean bl = updateExistingPins = answer == Dialogs.Answer.YES;
                        }
                        if (updateExistingPins) {
                            for (Placemark existingPlacemark : existingPlacemarks) {
                                existingPlacemark.setName(placemark.getName());
                                existingPlacemark.setLabel(placemark.getLabel());
                                existingPlacemark.setDescription(placemark.getDescription());
                                existingPlacemark.setPixelPos(placemark.getPixelPos());
                                existingPlacemark.setGeoPos(placemark.getGeoPos());
                                existingPlacemark.setStyleCss(placemark.getStyleCss());
                            }
                            continue;
                        }
                        Placemark placemark2 = this.createTransferrablePlacemark(placemark, selectedProduct);
                        placemarksCopy.add(placemark2);
                        this.setRelatedPlacemark(placemark, placemark2);
                        continue;
                    }
                    Placemark placemark3 = this.createTransferrablePlacemark(placemark, selectedProduct);
                    placemarksCopy.add(placemark3);
                    this.setRelatedPlacemark(placemark, placemark3);
                }
                this.addPlacemarksToProduct(placemarksCopy, selectedProduct, true);
            }
        }
    }

    private Placemark createTransferrablePlacemark(Placemark placemark, Product product) {
        Placemark newPlacemark = Placemark.createPointPlacemark((PlacemarkDescriptor)placemark.getDescriptor(), (String)placemark.getName(), (String)placemark.getLabel(), (String)placemark.getDescription(), (PixelPos)placemark.getPixelPos(), (GeoPos)placemark.getGeoPos(), (GeoCoding)product.getSceneGeoCoding());
        newPlacemark.setStyleCss(placemark.getStyleCss());
        return newPlacemark;
    }

    private Placemark[] getExistingPlacemarks(Placemark referencePlacemark, Product product) {
        ArrayList<Placemark> associatedPlacemarksList = new ArrayList<Placemark>();
        for (List<Placemark> relatedPlacemarkList : this.relatedPlacemarks) {
            for (Placemark placemark : relatedPlacemarkList) {
                if (placemark != referencePlacemark) continue;
                for (Placemark placemarkCandidate : relatedPlacemarkList) {
                    if (placemarkCandidate.getProduct() != product) continue;
                    associatedPlacemarksList.add(placemarkCandidate);
                }
            }
        }
        return associatedPlacemarksList.toArray(new Placemark[associatedPlacemarksList.size()]);
    }

    private void setRelatedPlacemark(Placemark originalPlacemark, Placemark newPlacemark) {
        boolean added = false;
        block0: for (List<Placemark> relatedPlacemarkList : this.relatedPlacemarks) {
            for (int j = 0; j < relatedPlacemarkList.size(); ++j) {
                Placemark placemark = relatedPlacemarkList.get(j);
                if (placemark != originalPlacemark) continue;
                added = relatedPlacemarkList.add(newPlacemark);
                continue block0;
            }
        }
        if (!added) {
            ArrayList<Placemark> relatedPlacemarkList = new ArrayList<Placemark>();
            relatedPlacemarkList.add(originalPlacemark);
            relatedPlacemarkList.add(newPlacemark);
            this.relatedPlacemarks.add(relatedPlacemarkList);
        }
    }

    private void removePlacemarksFromRelatedPlacemarks(Placemark placemark) {
        for (List<Placemark> relatedPlacemarkList : this.relatedPlacemarks) {
            for (Placemark relatedPlacemark : relatedPlacemarkList) {
                if (placemark != relatedPlacemark) continue;
                relatedPlacemarkList.remove(placemark);
                if (relatedPlacemarkList.size() != 1) continue;
                this.relatedPlacemarks.remove(relatedPlacemarkList);
            }
        }
    }

    private void setComponentName(JComponent component, String name) {
        component.setName(((Object)((Object)this)).getClass().getName() + "." + name);
    }

    void exportPlacemarkDataTable() {
        File file;
        SnapFileChooser fileChooser = new SnapFileChooser();
        fileChooser.setDialogTitle(MessageFormat.format("Export {0} Data Table", StringUtils.firstLetterUp((String)this.placemarkDescriptor.getRoleLabel())));
        this.setComponentName((JComponent)fileChooser, "Export_Data_Table");
        fileChooser.setFileFilter((FileFilter)PlacemarkIO.createTextFileFilter());
        File ioDir = this.getIODir();
        fileChooser.setCurrentDirectory(ioDir);
        fileChooser.setSelectedFile(new File(ioDir, "Data"));
        int result = fileChooser.showSaveDialog((Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        if (result == 0 && (file = fileChooser.getSelectedFile()) != null && Boolean.TRUE.equals(Dialogs.requestOverwriteDecision(this.getTitle(), file))) {
            this.setIODir(file.getAbsoluteFile().getParentFile());
            file = FileUtils.ensureExtension((File)file, (String)".txt");
            try (FileWriter writer = new FileWriter(file);){
                this.writePlacemarkDataTableText(writer);
            }
            catch (IOException ignored) {
                Dialogs.showError(MessageFormat.format("I/O Error.\nFailed to export {0} data table.", this.placemarkDescriptor.getRoleLabel()));
            }
        }
    }

    private void writePlacemarkDataTableText(Writer writer) {
        String[] additionalColumnNames = this.placemarkTableModel.getAdditionalColumnNames();
        String[] standardColumnNames = this.placemarkTableModel.getStandardColumnNames();
        int columnCount = this.placemarkTableModel.getColumnCount();
        ArrayList<Placemark> placemarkList = new ArrayList<Placemark>();
        ArrayList<Object[]> valueList = new ArrayList<Object[]>();
        for (int sortedRow = 0; sortedRow < this.placemarkTable.getRowCount(); ++sortedRow) {
            ListSelectionModel selectionModel = this.placemarkTable.getSelectionModel();
            if (!selectionModel.isSelectionEmpty() && !selectionModel.isSelectedIndex(sortedRow)) continue;
            int modelRow = this.placemarkTable.convertRowIndexToModel(sortedRow);
            placemarkList.add(this.placemarkTableModel.getPlacemarkAt(modelRow));
            Object[] values = new Object[columnCount];
            for (int col = 0; col < columnCount; ++col) {
                values[col] = this.placemarkTableModel.getValueAt(modelRow, col);
            }
            valueList.add(values);
        }
        PlacemarkIO.writePlacemarksWithAdditionalData((Writer)writer, (String)this.placemarkDescriptor.getRoleLabel(), (String)this.product.getName(), placemarkList, valueList, (String[])standardColumnNames, (String[])additionalColumnNames);
    }

    private void setIODir(File dir) {
        if (this.preferences != null && dir != null) {
            this.preferences.put(PREFERENCE_KEY_PIN_IO_DIR, dir.getPath());
        }
    }

    private File getIODir() {
        File dir = SystemUtils.getUserHomeDir();
        if (this.preferences != null) {
            dir = new File(this.preferences.get(PREFERENCE_KEY_PIN_IO_DIR, dir.getPath()));
        }
        return dir;
    }

    public UndoRedo getUndoRedo() {
        if (this.product != null) {
            return this.snapApp.getUndoManager(this.getProduct());
        }
        return UndoRedo.NONE;
    }

    private static class RightAlignmentTableCellRenderer
    extends DefaultTableCellRenderer {
        private RightAlignmentTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            label.setHorizontalAlignment(4);
            return label;
        }
    }

    private class ViewSelectionChangeHandler
    implements SelectionChangeListener {
        private ViewSelectionChangeHandler() {
        }

        public void selectionChanged(SelectionChangeEvent event) {
            VectorDataLayer vectorDataLayer;
            Layer layer;
            if (PlacemarkManagerTopComponent.this.synchronizingPlacemarkSelectedState) {
                return;
            }
            ProductSceneView sceneView = PlacemarkManagerTopComponent.this.getSceneView();
            if (sceneView != null && (layer = sceneView.getSelectedLayer()) instanceof VectorDataLayer && ((vectorDataLayer = (VectorDataLayer)layer).getVectorDataNode() == PlacemarkManagerTopComponent.this.getProduct().getPinGroup().getVectorDataNode() || vectorDataLayer.getVectorDataNode() == PlacemarkManagerTopComponent.this.getProduct().getGcpGroup().getVectorDataNode())) {
                PlacemarkManagerTopComponent.this.updateUIState();
            }
        }

        public void selectionContextChanged(SelectionChangeEvent event) {
        }
    }

    private class PlacemarkTableSelectionHandler
    implements ListSelectionListener {
        private PlacemarkTableSelectionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting() || e.getFirstIndex() == -1 || PlacemarkManagerTopComponent.this.synchronizingPlacemarkSelectedState) {
                return;
            }
            try {
                PlacemarkManagerTopComponent.this.synchronizingPlacemarkSelectedState = true;
                Placemark[] placemarks = PlacemarkManagerTopComponent.this.placemarkTableModel.getPlacemarks();
                ArrayList<Placemark> selectedPlacemarks = new ArrayList<Placemark>();
                for (int i = 0; i < placemarks.length; ++i) {
                    Placemark placemark = placemarks[i];
                    int sortedIndex = PlacemarkManagerTopComponent.this.placemarkTable.convertRowIndexToView(i);
                    if (!PlacemarkManagerTopComponent.this.placemarkTable.isRowSelected(sortedIndex)) continue;
                    selectedPlacemarks.add(placemark);
                }
                ProductSceneView sceneView = PlacemarkManagerTopComponent.this.getSceneView();
                if (sceneView != null) {
                    Placemark[] placemarkArray = selectedPlacemarks.toArray(new Placemark[selectedPlacemarks.size()]);
                    if (PlacemarkManagerTopComponent.this.getPlacemarkDescriptor() instanceof PinDescriptor) {
                        sceneView.selectPins(placemarkArray);
                    } else {
                        sceneView.selectGcps(placemarkArray);
                    }
                }
            }
            finally {
                PlacemarkManagerTopComponent.this.updateUIState();
                PlacemarkManagerTopComponent.this.synchronizingPlacemarkSelectedState = false;
            }
        }
    }

    private class ProductRemovedListener
    implements ProductManager.Listener {
        private ProductRemovedListener() {
        }

        public void productAdded(ProductManager.Event event) {
        }

        public void productRemoved(ProductManager.Event event) {
            PlacemarkManagerTopComponent.this.productToSelectedBands.remove(PlacemarkManagerTopComponent.this.product);
            PlacemarkManagerTopComponent.this.productToSelectedGrids.remove(PlacemarkManagerTopComponent.this.product);
        }
    }

    private class ProductSceneViewSelectionChangeHandler
    implements SelectionSupport.Handler<ProductSceneView> {
        private ProductSceneViewSelectionChangeHandler() {
        }

        @Override
        public void selectionChange(ProductSceneView oldValue, ProductSceneView newValue) {
            if (oldValue == PlacemarkManagerTopComponent.this.currentView) {
                PlacemarkManagerTopComponent.this.setCurrentView(null);
            }
            PlacemarkManagerTopComponent.this.setCurrentView(newValue);
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.action(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.action(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.action(e);
        }

        private void action(MouseEvent e) {
            if (e.isPopupTrigger() && PlacemarkManagerTopComponent.this.getNumSelectedPlacemarks() > 0) {
                JPopupMenu popupMenu = new JPopupMenu();
                JMenuItem menuItem = new JMenuItem("Copy selected data to clipboard");
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StringWriter stringWriter = new StringWriter();
                        PlacemarkManagerTopComponent.this.writePlacemarkDataTableText(stringWriter);
                        String text = stringWriter.toString();
                        text = text.replaceAll("\r\n", "\n");
                        text = text.replaceAll("\r", "\n");
                        SystemUtils.copyToClipboard((String)text);
                    }
                });
                popupMenu.add(menuItem);
                java.awt.Point point = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), PlacemarkManagerTopComponent.this.placemarkTable);
                popupMenu.show(PlacemarkManagerTopComponent.this.placemarkTable, point.x, point.y);
            }
        }
    }

    private static class ColumnModelListener
    implements TableColumnModelListener {
        private ColumnModelListener() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            int minWidth;
            int index = e.getToIndex();
            switch (index) {
                case 0: 
                case 1: {
                    minWidth = 60;
                    break;
                }
                default: {
                    minWidth = 80;
                }
            }
            TableColumnModel columnModel = (TableColumnModel)e.getSource();
            columnModel.getColumn(index).setPreferredWidth(minWidth);
            columnModel.getColumn(index).setCellRenderer(new RightAlignmentTableCellRenderer());
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }

    private class ToolTipSetter
    extends MouseInputAdapter {
        private int _rowIndex = -1;

        private ToolTipSetter() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this._rowIndex = -1;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int rowIndex = PlacemarkManagerTopComponent.this.placemarkTable.rowAtPoint(e.getPoint());
            if (rowIndex != this._rowIndex) {
                GeoPos geoPos;
                this._rowIndex = rowIndex;
                if (this._rowIndex >= 0 && this._rowIndex < PlacemarkManagerTopComponent.this.placemarkTable.getRowCount() && (geoPos = PlacemarkManagerTopComponent.this.getPlacemarkAt(PlacemarkManagerTopComponent.this.placemarkTable.convertRowIndexToModel(this._rowIndex)).getGeoPos()) != null) {
                    PlacemarkManagerTopComponent.this.placemarkTable.setToolTipText(geoPos.getLonString() + " / " + geoPos.getLatString());
                }
            }
        }
    }

    private class PlacemarkListener
    implements ProductNodeListener {
        private PlacemarkListener() {
        }

        public void nodeChanged(ProductNodeEvent event) {
            ProductNode sourceNode = event.getSourceNode();
            if (sourceNode instanceof Placemark && sourceNode.getOwner() == PlacemarkManagerTopComponent.this.placemarkDescriptor.getPlacemarkGroup(PlacemarkManagerTopComponent.this.product)) {
                PlacemarkManagerTopComponent.this.updateUIState();
            }
        }

        public void nodeDataChanged(ProductNodeEvent event) {
            ProductNode sourceNode = event.getSourceNode();
            if (sourceNode instanceof Placemark && sourceNode.getOwner() == PlacemarkManagerTopComponent.this.placemarkDescriptor.getPlacemarkGroup(PlacemarkManagerTopComponent.this.product)) {
                PlacemarkManagerTopComponent.this.updateUIState();
            }
        }

        public void nodeAdded(ProductNodeEvent event) {
            ProductNode sourceNode = event.getSourceNode();
            if (sourceNode instanceof Placemark && sourceNode.getOwner() == PlacemarkManagerTopComponent.this.placemarkDescriptor.getPlacemarkGroup(PlacemarkManagerTopComponent.this.product)) {
                PlacemarkManagerTopComponent.this.placemarkTableModel.addPlacemark((Placemark)sourceNode);
                PlacemarkManagerTopComponent.this.updateUIState();
            }
        }

        public void nodeRemoved(ProductNodeEvent event) {
            ProductNode sourceNode = event.getSourceNode();
            if (sourceNode instanceof Placemark) {
                Placemark placemark = (Placemark)sourceNode;
                PlacemarkManagerTopComponent.this.removePlacemarksFromRelatedPlacemarks(placemark);
                if (sourceNode.getOwner() == PlacemarkManagerTopComponent.this.placemarkDescriptor.getPlacemarkGroup(PlacemarkManagerTopComponent.this.product)) {
                    PlacemarkManagerTopComponent.this.placemarkTableModel.removePlacemark(placemark);
                    int selectedRow = PlacemarkManagerTopComponent.this.placemarkTable.getSelectedRow();
                    if (selectedRow >= PlacemarkManagerTopComponent.this.getPlacemarkGroup(PlacemarkManagerTopComponent.this.product).getNodeCount()) {
                        selectedRow = PlacemarkManagerTopComponent.this.getPlacemarkGroup(PlacemarkManagerTopComponent.this.product).getNodeCount() - 1;
                    }
                    if (selectedRow >= 0) {
                        PlacemarkManagerTopComponent.this.placemarkTable.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                    }
                    PlacemarkManagerTopComponent.this.updateUIState();
                }
            }
        }
    }
}

