/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc.shapefile;

import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.support.DefaultFigureStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;

public class SLDUtils {
    private static final StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);

    public static File getSLDFile(File shapeFile) {
        String filename = shapeFile.getAbsolutePath();
        if (filename.endsWith(".shp") || filename.endsWith(".dbf") || filename.endsWith(".shx")) {
            filename = filename.substring(0, filename.length() - 4);
            filename = filename + ".sld";
        } else if (filename.endsWith(".SHP") || filename.endsWith(".DBF") || filename.endsWith(".SHX")) {
            filename = filename.substring(0, filename.length() - 4);
            filename = filename + ".SLD";
        }
        return new File(filename);
    }

    public static Style[] loadSLD(File shapeFile) {
        File sld = SLDUtils.getSLDFile(shapeFile);
        if (sld.exists()) {
            return SLDUtils.createFromSLD(sld);
        }
        return new Style[0];
    }

    public static Style[] createFromSLD(File sld) {
        try {
            SLDParser stylereader = new SLDParser(styleFactory, sld.toURI().toURL());
            return stylereader.readXML();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new Style[0];
        }
    }

    public static void applyStyle(Style style, String defaultCss, DefaultFeatureCollection featureCollection, DefaultFeatureCollection styledCollection) {
        List featureTypeStyles = style.featureTypeStyles();
        SimpleFeatureType featureType = featureCollection.getSchema();
        SimpleFeatureType styledFeatureType = styledCollection.getSchema();
        ArrayList<Feature> featuresToStyle = new ArrayList<Feature>(featureCollection.size());
        Throwable throwable = null;
        try (SimpleFeatureIterator iterator = featureCollection.features();){
            while (iterator.hasNext()) {
                featuresToStyle.add(iterator.next());
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        for (FeatureTypeStyle featureTypeStyle : featureTypeStyles) {
            if (!SLDUtils.isFeatureTypeStyleActive(featureType, featureTypeStyle)) continue;
            ArrayList<Rule> ruleList = new ArrayList<Rule>();
            ArrayList<Rule> elseRuleList = new ArrayList<Rule>();
            for (Rule rule : featureTypeStyle.rules()) {
                if (rule.isElseFilter()) {
                    elseRuleList.add(rule);
                    continue;
                }
                ruleList.add(rule);
            }
            Iterator featureIterator = featuresToStyle.iterator();
            while (featureIterator.hasNext()) {
                SimpleFeature simpleFeature = (SimpleFeature)featureIterator.next();
                SimpleFeature styledFeature = SLDUtils.processRules(simpleFeature, styledFeatureType, ruleList, elseRuleList);
                if (styledFeature == null) continue;
                styledCollection.add(styledFeature);
                featureIterator.remove();
            }
        }
        for (SimpleFeature simpleFeature : featuresToStyle) {
            styledCollection.add(SLDUtils.createStyledFeature(styledFeatureType, simpleFeature, defaultCss));
        }
    }

    public static SimpleFeature processRules(SimpleFeature sf, SimpleFeatureType styledSFT, List<Rule> ruleList, List<Rule> elseRuleList) {
        SimpleFeature styledFeature;
        Symbolizer[] symbolizers;
        boolean doElse = true;
        for (Rule rule : ruleList) {
            Filter filter = rule.getFilter();
            if (filter != null && !filter.evaluate((Object)sf)) continue;
            doElse = false;
            symbolizers = rule.getSymbolizers();
            styledFeature = SLDUtils.processSymbolizers(styledSFT, sf, symbolizers);
            if (styledFeature == null) continue;
            return styledFeature;
        }
        if (doElse) {
            for (Rule rule : elseRuleList) {
                symbolizers = rule.getSymbolizers();
                styledFeature = SLDUtils.processSymbolizers(styledSFT, sf, symbolizers);
                if (styledFeature == null) continue;
                return styledFeature;
            }
        }
        return null;
    }

    public static SimpleFeature processSymbolizers(SimpleFeatureType sft, SimpleFeature feature, Symbolizer[] symbolizers) {
        for (Symbolizer symbolizer : symbolizers) {
            if (symbolizer instanceof LineSymbolizer) {
                LineSymbolizer lineSymbolizer = (LineSymbolizer)symbolizer;
                org.geotools.styling.Stroke stroke = lineSymbolizer.getStroke();
                Color strokeColor = SLD.color((org.geotools.styling.Stroke)stroke);
                int width = SLD.width((org.geotools.styling.Stroke)stroke);
                FigureStyle figureStyle = DefaultFigureStyle.createLineStyle((Paint)strokeColor, (Stroke)new BasicStroke(width));
                String cssStyle = figureStyle.toCssString();
                return SLDUtils.createStyledFeature(sft, feature, cssStyle);
            }
            if (!(symbolizer instanceof PolygonSymbolizer)) continue;
            PolygonSymbolizer polygonSymbolizer = (PolygonSymbolizer)symbolizer;
            Color fillColor = SLD.color((Fill)polygonSymbolizer.getFill());
            org.geotools.styling.Stroke stroke = polygonSymbolizer.getStroke();
            Color strokeColor = SLD.color((org.geotools.styling.Stroke)stroke);
            int width = SLD.width((org.geotools.styling.Stroke)stroke);
            DefaultFigureStyle figureStyle = DefaultFigureStyle.createPolygonStyle((Paint)fillColor, (Paint)strokeColor, (Stroke)new BasicStroke(width));
            String cssStyle = figureStyle.toCssString();
            return SLDUtils.createStyledFeature(sft, feature, cssStyle);
        }
        return null;
    }

    public static boolean isFeatureTypeStyleActive(SimpleFeatureType ftype, FeatureTypeStyle fts) {
        return ftype.getTypeName() != null && (ftype.getTypeName().equalsIgnoreCase(fts.getFeatureTypeName()) || FeatureTypes.isDecendedFrom((FeatureType)ftype, null, (String)fts.getFeatureTypeName()));
    }

    public static SimpleFeatureType createStyledFeatureType(SimpleFeatureType type) {
        SimpleFeatureTypeBuilder sftb = new SimpleFeatureTypeBuilder();
        sftb.init(type);
        sftb.add("style_css", String.class);
        return sftb.buildFeatureType();
    }

    public static SimpleFeature createStyledFeature(SimpleFeatureType type, SimpleFeature feature, String styleCSS) {
        SimpleFeatureBuilder sfb = new SimpleFeatureBuilder(type);
        sfb.init(feature);
        sfb.set("style_css", (Object)styleCSS);
        return sfb.buildFeature(feature.getID());
    }
}

