/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc.shapefile;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.grender.Rendering;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.label.LabelCacheImpl;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.style.Fill;

public class FeatureLayer
extends Layer {
    private MapContext mapContext;
    private CoordinateReferenceSystem crs;
    private StreamingRenderer renderer;
    private LabelCache labelCache;
    private double polyFillOpacity = 1.0;
    private double polyStrokeOpacity = 1.0;
    private double textOpacity = 1.0;
    private Rectangle2D modelBounds;

    public FeatureLayer(LayerType layerType, FeatureCollection<SimpleFeatureType, SimpleFeature> fc, PropertySet configuration) {
        super(layerType, configuration);
        this.crs = ((SimpleFeatureType)fc.getSchema()).getGeometryDescriptor().getCoordinateReferenceSystem();
        if (this.crs == null) {
            this.crs = DefaultGeographicCRS.WGS84;
        }
        ReferencedEnvelope envelope = new ReferencedEnvelope((Envelope)fc.getBounds(), this.crs);
        this.modelBounds = new Rectangle2D.Double(envelope.getMinX(), envelope.getMinY(), envelope.getWidth(), envelope.getHeight());
        this.mapContext = new DefaultMapContext(this.crs);
        Style style = (Style)configuration.getValue("sldStyle");
        this.mapContext.addLayer(fc, style);
        this.renderer = new StreamingRenderer();
        this.workaroundLabelCacheBug();
        style.accept((StyleVisitor)new RetrievingStyleVisitor());
        this.renderer.setContext(this.mapContext);
    }

    protected Rectangle2D getLayerModelBounds() {
        return this.modelBounds;
    }

    public double getPolyFillOpacity() {
        return this.polyFillOpacity;
    }

    public double getPolyStrokeOpacity() {
        return this.polyStrokeOpacity;
    }

    public double getTextOpacity() {
        return this.textOpacity;
    }

    public void setPolyFillOpacity(double opacity) {
        if (opacity != this.polyFillOpacity) {
            this.polyFillOpacity = opacity;
            this.applyOpacity();
            this.fireLayerDataChanged(null);
        }
    }

    public void setPolyStrokeOpacity(double opacity) {
        if (opacity != this.polyStrokeOpacity) {
            this.polyStrokeOpacity = opacity;
            this.applyOpacity();
            this.fireLayerDataChanged(null);
        }
    }

    public void setTextOpacity(double opacity) {
        if (opacity != this.textOpacity) {
            this.textOpacity = opacity;
            this.applyOpacity();
            this.fireLayerDataChanged(null);
        }
    }

    protected void fireLayerPropertyChanged(PropertyChangeEvent event) {
        if ("transparency".equals(event.getPropertyName())) {
            this.applyOpacity();
        }
        super.fireLayerPropertyChanged(event);
    }

    private void workaroundLabelCacheBug() {
        HashMap<String, LabelCache> hints = this.renderer.getRendererHints();
        if (hints == null) {
            hints = new HashMap<String, LabelCache>();
        }
        if (hints.containsKey("labelCache")) {
            this.labelCache = (LabelCache)hints.get("labelCache");
        } else {
            this.labelCache = new LabelCacheImpl();
            hints.put("labelCache", this.labelCache);
        }
        this.renderer.setRendererHints(hints);
    }

    protected void renderLayer(Rendering rendering) {
        Rectangle bounds = rendering.getViewport().getViewBounds();
        AffineTransform v2mTransform = rendering.getViewport().getViewToModelTransform();
        Rectangle2D bounds2D = v2mTransform.createTransformedShape(bounds).getBounds2D();
        ReferencedEnvelope mapArea = new ReferencedEnvelope(bounds2D, this.crs);
        this.mapContext.setAreaOfInterest(mapArea);
        this.labelCache.clear();
        AffineTransform modelToViewTransform = rendering.getViewport().getModelToViewTransform();
        this.renderer.paint(rendering.getGraphics(), bounds, mapArea, modelToViewTransform);
    }

    private void applyOpacity() {
        MapLayer layer = this.mapContext.getLayer(0);
        if (layer != null) {
            Style style = layer.getStyle();
            ApplyingStyleVisitor copyStyle = new ApplyingStyleVisitor();
            style.accept((StyleVisitor)copyStyle);
            layer.setStyle((Style)copyStyle.getCopy());
        }
    }

    private class RetrievingStyleVisitor
    extends DuplicatingStyleVisitor {
        private RetrievingStyleVisitor() {
        }

        public void visit(PolygonSymbolizer poly) {
            Expression opacityExpression;
            Stroke polyStroke;
            Expression opacityExpression2;
            super.visit(poly);
            PolygonSymbolizer polyCopy = (PolygonSymbolizer)this.pages.peek();
            org.geotools.styling.Fill polyFill = polyCopy.getFill();
            if (polyFill != null && (opacityExpression2 = polyFill.getOpacity()) != null) {
                FeatureLayer.this.polyFillOpacity = (Double)opacityExpression2.evaluate((Object)opacityExpression2, Double.class);
            }
            if ((polyStroke = polyCopy.getStroke()) != null && (opacityExpression = polyStroke.getOpacity()) != null) {
                FeatureLayer.this.polyStrokeOpacity = (Double)opacityExpression.evaluate((Object)opacityExpression, Double.class);
            }
        }

        public void visit(TextSymbolizer text) {
            Expression opacityExpression;
            super.visit(text);
            TextSymbolizer textCopy = (TextSymbolizer)this.pages.peek();
            org.geotools.styling.Fill textFill = textCopy.getFill();
            if (textFill != null && (opacityExpression = textFill.getOpacity()) != null) {
                FeatureLayer.this.textOpacity = (Double)opacityExpression.evaluate((Object)opacityExpression, Double.class);
            }
        }
    }

    private class ApplyingStyleVisitor
    extends DuplicatingStyleVisitor {
        private final Expression polyFillExp;
        private final Expression polyStrokeExp;
        private final Expression textExp;
        private final org.geotools.styling.Fill defaultTextFill;

        private ApplyingStyleVisitor() {
            StyleBuilder sb = new StyleBuilder();
            double layerOpacity = 1.0 - FeatureLayer.this.getTransparency();
            this.polyFillExp = sb.literalExpression(FeatureLayer.this.polyFillOpacity * layerOpacity);
            this.polyStrokeExp = sb.literalExpression(FeatureLayer.this.polyStrokeOpacity * layerOpacity);
            this.textExp = sb.literalExpression(FeatureLayer.this.textOpacity * layerOpacity);
            this.defaultTextFill = sb.createFill(Color.BLACK, FeatureLayer.this.textOpacity * layerOpacity);
        }

        public void visit(PolygonSymbolizer poly) {
            Stroke polyStroke;
            super.visit(poly);
            PolygonSymbolizer polyCopy = (PolygonSymbolizer)this.pages.peek();
            org.geotools.styling.Fill polyFill = polyCopy.getFill();
            if (polyFill != null) {
                polyFill.setOpacity(this.polyFillExp);
            }
            if ((polyStroke = polyCopy.getStroke()) != null) {
                polyStroke.setOpacity(this.polyStrokeExp);
            }
        }

        public void visit(TextSymbolizer text) {
            super.visit(text);
            TextSymbolizer textCopy = (TextSymbolizer)this.pages.peek();
            org.geotools.styling.Fill textFill = textCopy.getFill();
            if (textFill != null) {
                textFill.setOpacity(this.textExp);
            } else {
                textCopy.setFill((Fill)this.defaultTextFill);
            }
        }
    }
}

