/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.RGBChannelDef;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.colormanip.BrightnessContrastData;
import org.esa.snap.rcp.colormanip.ColorManipulationForm;
import org.esa.snap.rcp.colormanip.ColorUtils;
import org.esa.snap.rcp.colormanip.SliderPanel;
import org.esa.snap.ui.product.ProductSceneView;
import org.netbeans.api.annotations.common.NonNull;

class BrightnessContrastPanel
extends JPanel {
    private final ColorManipulationForm parentForm;
    private SliderPanel brightnessPanel;
    private SliderPanel contrastPanel;
    private SliderPanel saturationPanel;
    private PropertyChangeListener imageInfoChangeListener;
    private Map<ProductSceneView, BrightnessContrastData> visibleProductScenes;

    BrightnessContrastPanel(ColorManipulationForm parentForm) {
        super(new BorderLayout());
        this.parentForm = parentForm;
        ChangeListener sliderChangeListener = event -> this.applySliderValues();
        this.brightnessPanel = new SliderPanel("Brightness", sliderChangeListener);
        this.contrastPanel = new SliderPanel("Contrast", sliderChangeListener);
        this.saturationPanel = new SliderPanel("Saturation", sliderChangeListener);
        int maximumPreferredWidth = Math.max(this.brightnessPanel.getTitlePreferredWidth(), this.contrastPanel.getTitlePreferredWidth());
        maximumPreferredWidth = Math.max(maximumPreferredWidth, this.saturationPanel.getTitlePreferredWidth());
        this.saturationPanel.setTitlePreferredWidth(maximumPreferredWidth);
        this.contrastPanel.setTitlePreferredWidth(maximumPreferredWidth);
        this.saturationPanel.setTitlePreferredWidth(maximumPreferredWidth);
        this.visibleProductScenes = new HashMap<ProductSceneView, BrightnessContrastData>();
        this.imageInfoChangeListener = event -> {
            ImageInfo modifiedImageInfo = (ImageInfo)event.getNewValue();
            ProductSceneView selectedSceneView = (ProductSceneView)event.getSource();
            this.sceneImageInfoChangedOutside(selectedSceneView, modifiedImageInfo);
        };
        JPanel colorsPanel = new JPanel(new GridLayout(3, 1, 0, 15));
        colorsPanel.setBorder(new EmptyBorder(5, 5, 0, 0));
        colorsPanel.add(this.brightnessPanel);
        colorsPanel.add(this.contrastPanel);
        colorsPanel.add(this.saturationPanel);
        JButton resetButton = new JButton("Reset");
        resetButton.setFocusable(false);
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                BrightnessContrastPanel.this.resetSliderValues();
            }
        });
        JPanel componentsPanel = new JPanel();
        componentsPanel.setLayout(new BoxLayout(componentsPanel, 1));
        componentsPanel.add(colorsPanel);
        componentsPanel.add(resetButton);
        JScrollPane scrollPane = new JScrollPane(componentsPanel);
        scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add((Component)scrollPane, "North");
    }

    public void productSceneViewSelected(@NonNull ProductSceneView selectedSceneView) {
        RGBChannelDef initialRGBChannelDef;
        selectedSceneView.addPropertyChangeListener("imageInfo", this.imageInfoChangeListener);
        BrightnessContrastData brightnessContrastData = this.visibleProductScenes.get(selectedSceneView);
        if (brightnessContrastData == null) {
            RasterDataNode[] rasterDataNodes = selectedSceneView.getSceneImage().getRasters();
            ImageInfo initialImageInfo = selectedSceneView.getImageInfo().clone();
            brightnessContrastData = new BrightnessContrastData(initialImageInfo);
            for (int i = 0; i < rasterDataNodes.length; ++i) {
                ImageInfo nodeImageInfo = rasterDataNodes[i].getImageInfo().clone();
                brightnessContrastData.putImageInfo(rasterDataNodes[i], nodeImageInfo);
            }
            this.visibleProductScenes.put(selectedSceneView, brightnessContrastData);
        }
        boolean enableSaturationPanel = (initialRGBChannelDef = brightnessContrastData.getInitialImageInfo().getRgbChannelDef()) != null;
        this.saturationPanel.setEnabled(enableSaturationPanel);
        this.refreshSliderValues(brightnessContrastData);
    }

    public void productSceneViewDeselected(@NonNull ProductSceneView deselectedSceneView) {
        deselectedSceneView.removePropertyChangeListener("imageInfo", this.imageInfoChangeListener);
    }

    private void resetSliderValues() {
        ProductSceneView selectedSceneView = this.getSelectedProductSceneView();
        BrightnessContrastData brightnessContrastData = this.visibleProductScenes.get(selectedSceneView);
        brightnessContrastData.setSliderValues(0, 0, 0);
        this.refreshSliderValues(brightnessContrastData);
        this.applySliderValues();
    }

    private void refreshSliderValues(BrightnessContrastData brightnessContrastData) {
        this.brightnessPanel.setSliderValue(brightnessContrastData.getBrightnessSliderValue());
        this.contrastPanel.setSliderValue(brightnessContrastData.getContrastSliderValue());
        this.saturationPanel.setSliderValue(brightnessContrastData.getSaturationSliderValue());
    }

    private void sceneImageInfoChangedOutside(ProductSceneView selectedSceneView, ImageInfo modifiedImageInfo) {
        BrightnessContrastData brightnessContrastData = this.visibleProductScenes.get(selectedSceneView);
        ImageInfo initialImageInfo = modifiedImageInfo.clone();
        brightnessContrastData.setInitialImageInfo(initialImageInfo);
        brightnessContrastData.setSliderValues(0, 0, 0);
        this.refreshSliderValues(brightnessContrastData);
    }

    private ProductSceneView getSelectedProductSceneView() {
        return SnapApp.getDefault().getSelectedProductSceneView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applySliderValues() {
        ColorPaletteDef initialColorPaletteDef;
        RasterDataNode currentDataNode;
        ProductSceneView selectedSceneView = this.getSelectedProductSceneView();
        int brightnessValue = this.brightnessPanel.getSliderValue();
        int contrastValue = this.contrastPanel.getSliderValue();
        int saturationValue = this.saturationPanel.getSliderValue();
        BrightnessContrastData brightnessContrastData = this.visibleProductScenes.get(selectedSceneView);
        brightnessContrastData.setSliderValues(brightnessValue, contrastValue, saturationValue);
        brightnessValue = BrightnessContrastPanel.computeSliderValueToApply(brightnessValue, this.brightnessPanel.getSliderMaximumValue(), 255);
        contrastValue = BrightnessContrastPanel.computeSliderValueToApply(contrastValue, this.contrastPanel.getSliderMaximumValue(), 255);
        saturationValue = BrightnessContrastPanel.computeSliderValueToApply(saturationValue, this.saturationPanel.getSliderMaximumValue(), 100);
        ImageInfo sceneImageInfo = this.parentForm.getFormModel().getModifiedImageInfo();
        RasterDataNode[] rasterDataNodes = selectedSceneView.getSceneImage().getRasters();
        RGBChannelDef initialRGBChannelDef = brightnessContrastData.getInitialImageInfo().getRgbChannelDef();
        if (initialRGBChannelDef == null) {
            ColorPaletteDef colorPaletteDef = sceneImageInfo.getColorPaletteDef();
            for (int k = 0; k < rasterDataNodes.length; ++k) {
                currentDataNode = rasterDataNodes[k];
                initialColorPaletteDef = brightnessContrastData.getInitialImageInfo(currentDataNode).getColorPaletteDef();
                int pointCount = initialColorPaletteDef.getNumPoints();
                for (int i = 0; i < pointCount; ++i) {
                    ColorPaletteDef.Point initialPoint = initialColorPaletteDef.getPointAt(i);
                    Color newColor = BrightnessContrastPanel.computeColor(initialPoint.getColor(), brightnessValue, contrastValue, saturationValue);
                    ColorPaletteDef.Point currentPoint = colorPaletteDef.getPointAt(i);
                    currentPoint.setColor(newColor);
                }
            }
        } else {
            RGBChannelDef rgbChannelDef = sceneImageInfo.getRgbChannelDef();
            for (int i = 0; i < rasterDataNodes.length; ++i) {
                currentDataNode = rasterDataNodes[i];
                if (!(currentDataNode instanceof Band)) continue;
                initialColorPaletteDef = brightnessContrastData.getInitialImageInfo(currentDataNode).getColorPaletteDef();
                Color initialFirstColor = initialColorPaletteDef.getFirstPoint().getColor();
                Color newInitialFirstColor = BrightnessContrastPanel.computeColor(initialFirstColor, brightnessValue, contrastValue, saturationValue);
                float firstPercent = BrightnessContrastPanel.computePercent(initialFirstColor, newInitialFirstColor);
                double min = initialRGBChannelDef.getMinDisplaySample(i);
                min += min * (double)firstPercent;
                rgbChannelDef.setMinDisplaySample(i, min);
                Color initialLastColor = initialColorPaletteDef.getLastPoint().getColor();
                Color newInitialLastColor = BrightnessContrastPanel.computeColor(initialLastColor, brightnessValue, contrastValue, saturationValue);
                float lastPercent = BrightnessContrastPanel.computePercent(initialLastColor, newInitialLastColor);
                double max = initialRGBChannelDef.getMaxDisplaySample(i);
                max += max * (double)lastPercent;
                rgbChannelDef.setMaxDisplaySample(i, max);
            }
        }
        selectedSceneView.removePropertyChangeListener("imageInfo", this.imageInfoChangeListener);
        try {
            this.parentForm.applyChanges();
            for (int i = 0; i < rasterDataNodes.length; ++i) {
                RasterDataNode currentDataNode2 = rasterDataNodes[i];
                currentDataNode2.getProduct().setModified(true);
            }
        }
        finally {
            selectedSceneView.addPropertyChangeListener("imageInfo", this.imageInfoChangeListener);
        }
    }

    private static Color computeColor(Color color, int brightnessValue, int contrastValue, int saturationValue) {
        int newRgb = BrightnessContrastPanel.computePixelBrightness(color.getRGB(), brightnessValue);
        newRgb = BrightnessContrastPanel.computePixelContrast(newRgb, contrastValue);
        newRgb = BrightnessContrastPanel.computePixelSaturation(newRgb, saturationValue);
        return new Color(newRgb);
    }

    private static int computeSliderValueToApply(int visibleSliderValue, int maximumVisibleSliderValue, int maximumAllowedValue) {
        float visiblePercent = (float)visibleSliderValue / (float)maximumVisibleSliderValue;
        float percent = Math.round(visiblePercent * (float)maximumAllowedValue);
        return (int)percent;
    }

    private static float computePercent(Color initialColor, Color currentColor) {
        float initialRedPercent = (float)initialColor.getRed() / 255.0f;
        float initialGreenPercent = (float)initialColor.getGreen() / 255.0f;
        float initialBluePercent = (float)initialColor.getBlue() / 255.0f;
        float currentRedPercent = (float)currentColor.getRed() / 255.0f;
        float currentGreenPercent = (float)currentColor.getGreen() / 255.0f;
        float currentBluePercent = (float)currentColor.getBlue() / 255.0f;
        float redPercent = initialRedPercent - currentRedPercent;
        float greenPercent = initialGreenPercent - currentGreenPercent;
        float bluePercent = initialBluePercent - currentBluePercent;
        return (redPercent + greenPercent + bluePercent) / 3.0f;
    }

    private static int checkRGBValue(int v) {
        if (v > 255) {
            return 255;
        }
        if (v < 0) {
            return 0;
        }
        return v;
    }

    private static int computePixelBrightness(int pixel, int sliderValue) {
        int red = ColorUtils.red(pixel) + sliderValue;
        int green = ColorUtils.green(pixel) + sliderValue;
        int blue = ColorUtils.blue(pixel) + sliderValue;
        return ColorUtils.rgba(BrightnessContrastPanel.checkRGBValue(red), BrightnessContrastPanel.checkRGBValue(green), BrightnessContrastPanel.checkRGBValue(blue));
    }

    private static int computePixelSaturation(int pixel, int sliderValue) {
        int red = ColorUtils.red(pixel);
        int green = ColorUtils.green(pixel);
        int blue = ColorUtils.blue(pixel);
        float[] hsb = new float[3];
        Color.RGBtoHSB(red, green, blue, hsb);
        hsb[1] = hsb[1] + (float)sliderValue * 0.01f;
        if (hsb[1] > 1.0f) {
            hsb[1] = 1.0f;
        } else if (hsb[1] < 0.0f) {
            hsb[1] = 0.0f;
        }
        return Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
    }

    private static int computePixelContrast(int pixel, int sliderValue) {
        float factor = 259.0f * ((float)sliderValue + 255.0f) / (255.0f * (259.0f - (float)sliderValue));
        int red = ColorUtils.red(pixel);
        int green = ColorUtils.green(pixel);
        int blue = ColorUtils.blue(pixel);
        int newRed = (int)(factor * (float)(red - 128) + 128.0f);
        int newGreen = (int)(factor * (float)(green - 128) + 128.0f);
        int newBlue = (int)(factor * (float)(blue - 128) + 128.0f);
        return ColorUtils.rgba(BrightnessContrastPanel.checkRGBValue(newRed), BrightnessContrastPanel.checkRGBValue(newGreen), BrightnessContrastPanel.checkRGBValue(newBlue));
    }
}

