/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.window;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RGBImageProfile;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.util.ArrayUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.netbeans.docwin.DocumentWindow;
import org.esa.snap.netbeans.docwin.DocumentWindowManager;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.window.Bundle;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.rcp.windows.ProductSceneViewTopComponent;
import org.esa.snap.ui.RGBImageProfilePane;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.product.ProductSceneImage;
import org.esa.snap.ui.product.ProductSceneView;
import org.openide.awt.UndoRedo;
import org.openide.util.HelpCtx;

public class OpenRGBImageViewAction
extends AbstractAction
implements HelpCtx.Provider {
    private static final String HELP_ID = "rgbImageProfile";
    private Product product;

    public OpenRGBImageViewAction(ProductNode node) {
        super(Bundle.CTL_OpenRGBImageViewAction_MenuText());
        this.product = node.getProduct();
        this.putValue("ShortDescription", Bundle.CTL_OpenRGBImageViewAction_ShortDescription());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.product != null) {
            this.openProductSceneViewRGB(this.product, HELP_ID);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    public void openProductSceneViewRGB(Product rgbProduct, String helpId) {
        Product[] openedProducts = SnapApp.getDefault().getProductManager().getProducts();
        int[] defaultBandIndices = OpenRGBImageViewAction.getDefaultBandIndices(rgbProduct);
        RGBImageProfilePane profilePane = new RGBImageProfilePane(SnapApp.getDefault().getPreferencesPropertyMap(), rgbProduct, openedProducts, defaultBandIndices);
        String title = "Select RGB-Image Channels";
        boolean ok = profilePane.showDialog((Window)SnapApp.getDefault().getMainFrame(), "Select RGB-Image Channels", helpId);
        if (!ok) {
            return;
        }
        String[] rgbaExpressions = profilePane.getRgbaExpressions();
        if (profilePane.getStoreProfileInProduct()) {
            RGBImageProfile.storeRgbaExpressions((Product)rgbProduct, (String[])rgbaExpressions);
        }
        String sceneName = OpenRGBImageViewAction.createSceneName(rgbProduct, profilePane.getSelectedProfile(), "RGB");
        this.openProductSceneViewRGB(sceneName, rgbProduct, rgbaExpressions);
    }

    public static int[] getDefaultBandIndices(Product product) {
        int[] bandIndices = null;
        Band[] bands = product.getBands();
        if (bands.length == 1) {
            return new int[]{0};
        }
        if (bands.length == 2) {
            return new int[]{0, 1};
        }
        if (bands.length > 2) {
            bandIndices = new int[3];
            int cnt = 0;
            int i = 0;
            for (Band band : product.getBands()) {
                String unit = band.getUnit();
                if (unit != null && unit.contains("intensity")) {
                    bandIndices[i++] = cnt;
                }
                if (i >= bandIndices.length) break;
                ++cnt;
            }
            if (i == 0) {
                while (i < 3) {
                    bandIndices[i] = i++;
                }
            }
            if (i == 1) {
                return new int[]{bandIndices[0]};
            }
            if (i == 2) {
                return new int[]{bandIndices[0], bandIndices[1]};
            }
        }
        return bandIndices;
    }

    private void openProductSceneViewRGB(final String name, final Product product, final String[] rgbaExpressions) {
        ProgressMonitorSwingWorker<ProductSceneImage, Object> worker = new ProgressMonitorSwingWorker<ProductSceneImage, Object>((Component)SnapApp.getDefault().getMainFrame(), SnapApp.getDefault().getInstanceName() + " - Creating image for '" + name + "'"){

            protected ProductSceneImage doInBackground(ProgressMonitor pm) throws Exception {
                return OpenRGBImageViewAction.this.createProductSceneImageRGB(name, product, rgbaExpressions, pm);
            }

            protected void done() {
                SnapApp.getDefault().getMainFrame().setCursor(Cursor.getDefaultCursor());
                String errorMsg = "The RGB image view could not be created.";
                try {
                    ProductSceneView productSceneView = new ProductSceneView((ProductSceneImage)this.get());
                    OpenRGBImageViewAction.openDocumentWindow(productSceneView);
                }
                catch (OutOfMemoryError e) {
                    Dialogs.showOutOfMemoryError(errorMsg);
                    return;
                }
                catch (Exception e) {
                    SnapApp.getDefault().handleError(errorMsg, e);
                    return;
                }
                SnapApp.getDefault().setStatusBarMessage("");
            }
        };
        SnapApp.getDefault().setStatusBarMessage("Creating RGB image view...");
        UIUtils.setRootFrameWaitCursor((Component)SnapApp.getDefault().getMainFrame());
        worker.execute();
    }

    public static ProductSceneViewTopComponent openDocumentWindow(ProductSceneView view) {
        UndoRedo.Manager undoManager = SnapApp.getDefault().getUndoManager(view.getProduct());
        ProductSceneViewTopComponent psvTopComponent = new ProductSceneViewTopComponent(view, (UndoRedo)undoManager);
        DocumentWindowManager.getDefault().openWindow((DocumentWindow)psvTopComponent);
        psvTopComponent.requestSelected();
        return psvTopComponent;
    }

    private ProductSceneImage createProductSceneImageRGB(String name, Product product, String[] rgbaExpressions, ProgressMonitor pm) throws Exception {
        Band[] rgbBands = null;
        boolean errorOccurred = false;
        ProductSceneImage productSceneImage = null;
        try {
            pm.beginTask("Creating RGB image...", 2);
            rgbBands = OpenRGBImageViewAction.allocateRgbBands(product, rgbaExpressions);
            productSceneImage = new ProductSceneImage(name, (RasterDataNode)rgbBands[0], (RasterDataNode)rgbBands[1], (RasterDataNode)rgbBands[2], SnapApp.getDefault().getPreferencesPropertyMap(), SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            productSceneImage.initVectorDataCollectionLayer();
            productSceneImage.initMaskCollectionLayer();
        }
        catch (Exception e) {
            errorOccurred = true;
            throw e;
        }
        finally {
            pm.done();
            if (rgbBands != null) {
                OpenRGBImageViewAction.releaseRgbBands(rgbBands, errorOccurred);
            }
        }
        return productSceneImage;
    }

    public static Band[] allocateRgbBands(Product product, String[] rgbaExpressions) {
        Band[] rgbBands = new Band[3];
        boolean productModificationState = product.isModified();
        Object[] products = SnapApp.getDefault().getProductManager().getProducts();
        int elementIndex = ArrayUtils.getElementIndex((Object)product, (Object[])products);
        try {
            if (!BandArithmetic.areRastersEqualInSize((Product[])products, (int)elementIndex, (String[])rgbaExpressions)) {
                throw new IllegalArgumentException("Referenced rasters are not of the same size");
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Expressions are invalid");
        }
        HashSet referencedProducts = new HashSet();
        Arrays.stream(rgbaExpressions).forEach(arg_0 -> OpenRGBImageViewAction.lambda$allocateRgbBands$0(referencedProducts, (Product[])products, arg_0));
        boolean moreProductsReferences = referencedProducts.size() > 1;
        for (int i = 0; i < rgbBands.length; ++i) {
            Band rgbBand;
            String expression = rgbaExpressions[i].isEmpty() ? "0" : rgbaExpressions[i];
            Band band = rgbBand = moreProductsReferences ? null : product.getBand(expression);
            if (rgbBand == null) {
                rgbBand = new ProductSceneView.RGBChannel(product, OpenRGBImageViewAction.determineWidth(expression, (Product[])products, elementIndex), OpenRGBImageViewAction.determineHeight(expression, (Product[])products, elementIndex), RGBImageProfile.RGB_BAND_NAMES[i], expression);
            }
            rgbBands[i] = rgbBand;
        }
        product.setModified(productModificationState);
        return rgbBands;
    }

    private static int determineWidth(String expression, Product[] products, int index) {
        int width = products[index].getSceneRasterWidth();
        try {
            RasterDataNode[] refRasters = BandArithmetic.getRefRasters((String)expression, (Product[])products, (int)index);
            if (refRasters.length > 0) {
                width = refRasters[0].getRasterWidth();
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid expression: " + expression);
        }
        return width;
    }

    private static int determineHeight(String expression, Product[] products, int index) {
        int height = products[index].getSceneRasterHeight();
        try {
            RasterDataNode[] refRasters = BandArithmetic.getRefRasters((String)expression, (Product[])products, (int)index);
            if (refRasters.length > 0) {
                height = refRasters[0].getRasterHeight();
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid expression: " + expression);
        }
        return height;
    }

    public static void releaseRgbBands(Band[] rgbBands, boolean errorOccurred) {
        for (int i = 0; i < rgbBands.length; ++i) {
            Band rgbBand = rgbBands[i];
            if (rgbBand != null && rgbBand instanceof ProductSceneView.RGBChannel && errorOccurred) {
                rgbBand.dispose();
            }
            rgbBands[i] = null;
        }
    }

    public static String createSceneName(Product product, RGBImageProfile rgbImageProfile, String operation) {
        StringBuilder nameBuilder = new StringBuilder();
        String productRef = product.getProductRefString();
        if (productRef != null) {
            nameBuilder.append(productRef);
            nameBuilder.append(" ");
        }
        if (rgbImageProfile != null) {
            nameBuilder.append(rgbImageProfile.getName().replace("_", " "));
            nameBuilder.append(" ");
        }
        nameBuilder.append(operation);
        return nameBuilder.toString();
    }

    private static /* synthetic */ void lambda$allocateRgbBands$0(Set referencedProducts, Product[] products, String e) {
        try {
            referencedProducts.addAll(Arrays.stream(BandArithmetic.getRefRasters((String)e, (Product[])products)).map(ProductNode::getProduct).collect(Collectors.toList()));
        }
        catch (ParseException pex) {
            SystemUtils.LOG.warning(pex.getMessage());
        }
    }
}

