/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.raster;

import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FilterBand;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.netbeans.docwin.WindowUtilities;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.raster.Bundle;
import org.esa.snap.rcp.windows.ProductSceneViewTopComponent;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ConvertComputedBandIntoBandAction
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    private final Lookup lookup;
    private final Lookup.Result<VirtualBand> vbResult;
    private final Lookup.Result<FilterBand> fbResult;

    public ConvertComputedBandIntoBandAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ConvertComputedBandIntoBandAction(Lookup lookup) {
        super(Bundle.CTL_ConvertComputedBandIntoBandAction_MenuText());
        this.lookup = lookup;
        this.vbResult = lookup.lookupResult(VirtualBand.class);
        this.vbResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.vbResult));
        this.fbResult = lookup.lookupResult(FilterBand.class);
        this.fbResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.fbResult));
        this.setEnableState();
    }

    private void setEnableState() {
        VirtualBand virtualBand = (VirtualBand)this.lookup.lookup(VirtualBand.class);
        FilterBand filterBand = (FilterBand)this.lookup.lookup(FilterBand.class);
        this.setEnabled(virtualBand != null || filterBand != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ImageInfo imageInfo;
        SnapApp snapApp = SnapApp.getDefault();
        ProductNode selectedProductNode = snapApp.getSelectedProductNode(SnapApp.SelectionSourceHint.EXPLORER);
        if (!this.isComputedBand(selectedProductNode)) {
            return;
        }
        Band computedBand = (Band)selectedProductNode;
        String bandName = computedBand.getName();
        int width = computedBand.getRasterWidth();
        int height = computedBand.getRasterHeight();
        Band realBand = new Band(bandName, computedBand.getDataType(), width, height);
        realBand.setDescription(this.createDescription(computedBand));
        realBand.setValidPixelExpression(computedBand.getValidPixelExpression());
        realBand.setUnit(computedBand.getUnit());
        realBand.setSpectralWavelength(computedBand.getSpectralWavelength());
        realBand.setGeophysicalNoDataValue(computedBand.getGeophysicalNoDataValue());
        realBand.setNoDataValueUsed(computedBand.isNoDataValueUsed());
        if (computedBand.isStxSet()) {
            realBand.setStx(computedBand.getStx());
        }
        if ((imageInfo = computedBand.getImageInfo()) != null) {
            realBand.setImageInfo(imageInfo.clone());
        }
        Product product = computedBand.getProduct();
        ProductSceneViewTopComponent topComponent = this.getProductSceneViewTopComponent((RasterDataNode)computedBand);
        if (topComponent != null) {
            topComponent.close();
        }
        ProductNodeGroup bandGroup = product.getBandGroup();
        int bandIndex = bandGroup.indexOf((ProductNode)computedBand);
        bandGroup.remove((ProductNode)computedBand);
        bandGroup.add(bandIndex, (ProductNode)realBand);
        realBand.setSourceImage(this.createSourceImage(computedBand, realBand));
        realBand.setModified(true);
    }

    MultiLevelImage createSourceImage(Band computedBand, Band realBand) {
        if (computedBand instanceof VirtualBand) {
            return VirtualBand.createSourceImage((RasterDataNode)realBand, (String)((VirtualBand)computedBand).getExpression());
        }
        return computedBand.getSourceImage();
    }

    private String createDescription(Band computedBand) {
        if (computedBand instanceof VirtualBand) {
            VirtualBand virtualBand = (VirtualBand)computedBand;
            String oldDescription = virtualBand.getDescription();
            String newDescription = oldDescription == null ? "" : oldDescription.trim();
            String formerExpressionDescription = "(expression was '" + virtualBand.getExpression() + "')";
            newDescription = newDescription.isEmpty() ? formerExpressionDescription : newDescription + " " + formerExpressionDescription;
            return newDescription;
        }
        return computedBand.getDescription();
    }

    private ProductSceneViewTopComponent getProductSceneViewTopComponent(RasterDataNode raster) {
        return WindowUtilities.getOpened(ProductSceneViewTopComponent.class).filter(topComponent -> raster == topComponent.getView().getRaster()).findFirst().orElse(null);
    }

    private boolean isComputedBand(ProductNode selectedProductNode) {
        return selectedProductNode instanceof VirtualBand || selectedProductNode instanceof FilterBand;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ConvertComputedBandIntoBandAction(actionContext);
    }

    public void resultChanged(LookupEvent ev) {
        this.setEnableState();
    }
}

