/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file.export;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureSelection;
import com.bc.ceres.swing.figure.ShapeFigure;
import com.bc.ceres.swing.progress.DialogProgressMonitor;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.TransectProfileData;
import org.esa.snap.core.datamodel.TransectProfileDataBuilder;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.export.Bundle;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.rcp.util.MultiSizeIssue;
import org.esa.snap.ui.SelectExportMethodDialog;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.product.ProductSceneView;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ExportTransectPixelsAction
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    private static final String ERR_MSG_BASE = "Transect pixels cannot be exported:\n";
    private final Lookup.Result<FigureSelection> result;

    public ExportTransectPixelsAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ExportTransectPixelsAction(Lookup lkp) {
        super(Bundle.CTL_ExportTransectPixelsAction_MenuText());
        this.putValue("popupText", Bundle.CTL_ExportTransectPixelsAction_PopupText());
        this.result = lkp.lookupResult(FigureSelection.class);
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.result));
        this.updateEnableState(this.getCurrentFigureSelection());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        ProductSceneView sceneView = SnapApp.getDefault().getSelectedProductSceneView();
        if (sceneView != null && sceneView.getProduct().isMultiSize()) {
            MultiSizeIssue.maybeResample(sceneView.getProduct());
        } else {
            this.exportTransectPixels();
        }
    }

    public Action createContextAwareInstance(Lookup lkp) {
        return new ExportTransectPixelsAction(lkp);
    }

    public void resultChanged(LookupEvent le) {
        this.updateEnableState(this.getCurrentFigureSelection());
    }

    private void exportTransectPixels() {
        StringBuffer clipboardText;
        PrintWriter out;
        TransectProfileData transectProfileData;
        Figure figure;
        ProductSceneView view = SnapApp.getDefault().getSelectedProductSceneView();
        if (view == null) {
            return;
        }
        FigureSelection selection = this.getCurrentFigureSelection();
        final RasterDataNode raster = view.getRaster();
        ShapeFigure transect = null;
        if (selection.getFigureCount() > 0 && (figure = selection.getFigure(0)) instanceof ShapeFigure) {
            transect = (ShapeFigure)figure;
        }
        if (transect == null) {
            Dialogs.showError(Bundle.CTL_ExportTransectPixelsAction_DialogTitle(), "Transect pixels cannot be exported:\nThere is no transect defined in the selected band.");
            return;
        }
        try {
            transectProfileData = new TransectProfileDataBuilder().raster(raster).path(transect.getShape()).build();
        }
        catch (IOException e) {
            Dialogs.showError(Bundle.CTL_ExportTransectPixelsAction_DialogTitle(), "Transect pixels cannot be exported:\nAn I/O error occurred:\n" + e.getMessage());
            return;
        }
        final int numTransectPixels = ExportTransectPixelsAction.getNumTransectPixels(raster.getProduct(), transectProfileData);
        String numPixelsText = numTransectPixels == 1 ? "One transect pixel will be exported.\n" : numTransectPixels + " transect pixels will be exported.\n";
        String questionText = "How do you want to export the pixel values?\n";
        final JCheckBox createHeaderBox = new JCheckBox("Create header");
        final JCheckBox exportTiePointsBox = new JCheckBox("Export tie-points");
        final JCheckBox exportWavelengthsAndSFBox = new JCheckBox("Export wavelengths + solar fluxes");
        int method = SelectExportMethodDialog.run((Component)SnapApp.getDefault().getMainFrame(), (String)ExportTransectPixelsAction.getWindowTitle(), (String)("How do you want to export the pixel values?\n" + numPixelsText), (JCheckBox[])new JCheckBox[]{createHeaderBox, exportTiePointsBox, exportWavelengthsAndSFBox}, (String)"exportTransectPixels");
        int initialBufferSize = 256000;
        if (method == 0) {
            StringWriter stringWriter = new StringWriter(256000);
            out = new PrintWriter(stringWriter);
            clipboardText = stringWriter.getBuffer();
        } else if (method == 1) {
            FileWriter fileWriter;
            File file = ExportTransectPixelsAction.promptForFile(ExportTransectPixelsAction.createDefaultFileName(raster));
            if (file == null) {
                return;
            }
            try {
                fileWriter = new FileWriter(file);
            }
            catch (IOException e) {
                Dialogs.showError(Bundle.CTL_ExportTransectPixelsAction_DialogTitle(), "Transect pixels cannot be exported:\nFailed to create file '" + file + "':\n" + e.getMessage());
                return;
            }
            out = new PrintWriter(new BufferedWriter(fileWriter, 256000));
            clipboardText = null;
        } else {
            return;
        }
        SwingWorker<Exception, Object> swingWorker = new SwingWorker<Exception, Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Exception doInBackground() throws Exception {
                Exception returnValue = null;
                DialogProgressMonitor pm = new DialogProgressMonitor((Component)SnapApp.getDefault().getMainFrame(), Bundle.CTL_ExportTransectPixelsAction_DialogTitle(), Dialog.ModalityType.APPLICATION_MODAL);
                try {
                    boolean mustCreateHeader = createHeaderBox.isSelected();
                    boolean mustExportWavelengthsAndSF = exportWavelengthsAndSFBox.isSelected();
                    boolean mustExportTiePoints = exportTiePointsBox.isSelected();
                    TransectExporter exporter = new TransectExporter(mustCreateHeader, mustExportWavelengthsAndSF, mustExportTiePoints);
                    boolean success = exporter.exportTransectPixels(out, raster.getProduct(), transectProfileData, numTransectPixels, (ProgressMonitor)pm);
                    if (success && clipboardText != null) {
                        SystemUtils.copyToClipboard((String)clipboardText.toString());
                        clipboardText.setLength(0);
                    }
                }
                catch (Exception e) {
                    returnValue = e;
                }
                finally {
                    out.close();
                }
                return returnValue;
            }

            @Override
            public void done() {
                Exception exception;
                SnapApp.getDefault().setStatusBarMessage("");
                UIUtils.setRootFrameDefaultCursor((Component)SnapApp.getDefault().getMainFrame());
                try {
                    exception = (Exception)this.get();
                }
                catch (Exception e) {
                    exception = e;
                }
                if (exception != null) {
                    Dialogs.showError(Bundle.CTL_ExportTransectPixelsAction_DialogTitle(), ExportTransectPixelsAction.ERR_MSG_BASE + exception.getMessage());
                }
            }
        };
        UIUtils.setRootFrameWaitCursor((Component)SnapApp.getDefault().getMainFrame());
        SnapApp.getDefault().setStatusBarMessage("Exporting transect pixels...");
        swingWorker.execute();
    }

    private FigureSelection getCurrentFigureSelection() {
        return this.result.allInstances().stream().findFirst().orElse(null);
    }

    private void updateEnableState(FigureSelection figureSelection) {
        this.setEnabled(figureSelection != null);
    }

    private static String createDefaultFileName(RasterDataNode raster) {
        return FileUtils.getFilenameWithoutExtension((String)raster.getProduct().getName()) + "_TRANSECT.txt";
    }

    private static String getWindowTitle() {
        return SnapApp.getDefault().getInstanceName() + " - " + Bundle.CTL_ExportTransectPixelsAction_DialogTitle();
    }

    private static File promptForFile(String defaultFileName) {
        SnapFileFilter fileFilter = new SnapFileFilter("TXT", "txt", "Text");
        return Dialogs.requestFileForSave(Bundle.CTL_ExportTransectPixelsAction_DialogTitle(), false, (FileFilter)fileFilter, ".txt", defaultFileName, null, "exportTransectPixels.lastDir");
    }

    private static int getNumTransectPixels(Product product, TransectProfileData transectProfileData) {
        Point2D[] pixelPositions = transectProfileData.getPixelPositions();
        int numTransectPixels = 0;
        for (Point2D pixelPosition : pixelPositions) {
            int x = (int)Math.floor(pixelPosition.getX());
            int y = (int)Math.floor(pixelPosition.getY());
            if (x < 0 || x >= product.getSceneRasterWidth() || y < 0 || y >= product.getSceneRasterHeight()) continue;
            ++numTransectPixels;
        }
        return numTransectPixels;
    }

    static class TransectExporter {
        private final boolean mustCreateHeader;
        private final boolean mustExportWavelengthsAndSF;
        private final boolean mustExportTiePoints;

        TransectExporter(boolean mustCreateHeader, boolean mustExportWavelengthsAndSF, boolean mustExportTiePoints) {
            this.mustCreateHeader = mustCreateHeader;
            this.mustExportWavelengthsAndSF = mustExportWavelengthsAndSF;
            this.mustExportTiePoints = mustExportTiePoints;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean exportTransectPixels(PrintWriter out, Product product, TransectProfileData transectProfileData, int numTransectPixels, ProgressMonitor pm) {
            Band[] bands = product.getBands();
            TiePointGrid[] tiePointGrids = product.getTiePointGrids();
            GeoCoding geoCoding = product.getSceneGeoCoding();
            if (this.mustCreateHeader) {
                this.writeFileHeader(out, bands);
            }
            this.writeTableHeader(out, geoCoding, bands, this.mustExportTiePoints, tiePointGrids, this.mustExportWavelengthsAndSF);
            Point2D[] pixelPositions = transectProfileData.getPixelPositions();
            pm.beginTask("Writing pixel data...", numTransectPixels);
            try {
                for (Point2D pixelPosition : pixelPositions) {
                    int x = (int)Math.floor(pixelPosition.getX());
                    int y = (int)Math.floor(pixelPosition.getY());
                    if (x < 0 || x >= product.getSceneRasterWidth() || y < 0 || y >= product.getSceneRasterHeight()) continue;
                    this.writeDataLine(out, geoCoding, bands, this.mustExportTiePoints, tiePointGrids, x, y);
                    pm.worked(1);
                    if (!pm.isCanceled()) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                pm.done();
            }
            return true;
        }

        private void writeFileHeader(PrintWriter out, Band[] bands) {
            ProductData.UTC utc = ProductData.UTC.create((Date)new Date(), (long)0L);
            out.printf("# Exported transect on %s%n", utc.format());
            if (bands.length >= 0) {
                Product product = bands[0].getProduct();
                out.printf("# Product name: %s%n", product.getName());
                if (product.getFileLocation() != null) {
                    out.printf("# Product file location: %s%n", product.getFileLocation().getAbsolutePath());
                }
            }
            out.println();
        }

        private void writeTableHeader(PrintWriter out, GeoCoding geoCoding, Band[] bands, boolean mustExportTiePoints, TiePointGrid[] tiePointGrids, boolean mustExportWavelengthsAndSF) {
            if (mustExportWavelengthsAndSF) {
                float[] wavelengthArray = new float[bands.length];
                for (int i = 0; i < bands.length; ++i) {
                    wavelengthArray[i] = bands[i].getSpectralWavelength();
                }
                out.printf("# Wavelength:\t \t \t \t%s\n", StringUtils.arrayToString((Object)wavelengthArray, (String)"\t"));
                float[] solarFluxArray = new float[bands.length];
                for (int i = 0; i < bands.length; ++i) {
                    solarFluxArray[i] = bands[i].getSolarFlux();
                }
                out.printf("# Solar flux:\t \t \t \t%s%n", StringUtils.arrayToString((Object)solarFluxArray, (String)"\t"));
            }
            out.print("Pixel-X");
            out.print("\t");
            out.print("Pixel-Y");
            if (geoCoding != null) {
                out.print("\t");
                out.print("Longitude");
                out.print("\t");
                out.print("Latitude");
            }
            for (Band band : bands) {
                out.print("\t");
                out.print(band.getName());
            }
            if (mustExportTiePoints) {
                for (Band band : tiePointGrids) {
                    out.print("\t");
                    out.print(band.getName());
                }
            }
            out.print("\n");
        }

        private void writeDataLine(PrintWriter out, GeoCoding geoCoding, Band[] bands, boolean mustExportTiePoints, TiePointGrid[] tiePointGrids, int x, int y) {
            PixelPos pixelPos = new PixelPos((double)((float)x + 0.5f), (double)((float)y + 0.5f));
            out.print(String.valueOf(pixelPos.x));
            out.print("\t");
            out.print(String.valueOf(pixelPos.y));
            if (geoCoding != null) {
                out.print("\t");
                GeoPos geoPos = geoCoding.getGeoPos(pixelPos, null);
                out.print(String.valueOf(geoPos.lon));
                out.print("\t");
                out.print(String.valueOf(geoPos.lat));
            }
            for (Band band : bands) {
                out.print("\t");
                String pixelString = band.getPixelString(x, y);
                out.print(pixelString);
            }
            if (mustExportTiePoints) {
                for (Band band : tiePointGrids) {
                    out.print("\t");
                    out.print(band.getPixelString(x, y));
                }
            }
            out.print("\n");
        }
    }
}

