/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file;

import com.bc.ceres.core.Assert;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import org.esa.snap.core.dataio.dimap.DimapProductReader;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.Bundle;
import org.esa.snap.rcp.actions.file.SaveProductAsAction;
import org.esa.snap.rcp.actions.file.WriteProductOperation;
import org.esa.snap.rcp.util.Dialogs;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressHandle;

public final class SaveProductAction
extends AbstractAction {
    private WeakReference<ProductNode> productNodeRef;

    public SaveProductAction(ProductNode productNode) {
        this.productNodeRef = new WeakReference<ProductNode>(productNode);
    }

    static Boolean saveProduct(Product product) {
        Assert.notNull((Object)product.getFileLocation());
        File file = product.getFileLocation();
        if (file.isFile() && !file.canWrite()) {
            Dialogs.showWarning(Bundle.CTL_SaveProductActionName(), MessageFormat.format("The product\n''{0}''\nexists and cannot be overwritten, because it is read only.\nPlease choose another file or remove the write protection.", file.getPath()), null);
            return false;
        }
        SnapApp.getDefault().setStatusBarMessage(MessageFormat.format("Writing product ''{0}'' to {1}...", product.getDisplayName(), file));
        boolean incremental = true;
        WriteProductOperation operation = new WriteProductOperation(product, incremental);
        BaseProgressUtils.runOffEventThreadWithProgressDialog((Runnable)operation, (String)Bundle.CTL_SaveProductActionName(), (ProgressHandle)operation.getProgressHandle(), (boolean)true, (int)50, (int)1000);
        SnapApp.getDefault().setStatusBarMessage("");
        return operation.getStatus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.execute();
    }

    public Boolean execute() {
        ProductNode productNode = (ProductNode)this.productNodeRef.get();
        if (productNode != null && productNode.getProduct() != null) {
            Product product = productNode.getProduct();
            if (product != null) {
                if (product.getFileLocation() != null && (product.getProductReader() == null || product.getProductReader() instanceof DimapProductReader)) {
                    return SaveProductAction.saveProduct(product);
                }
                return new SaveProductAsAction((ProductNode)product).execute();
            }
            return true;
        }
        return true;
    }
}

