/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file;

import com.bc.ceres.core.Assert;
import java.io.File;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.Bundle;
import org.esa.snap.rcp.actions.file.OpenProductAction;
import org.esa.snap.rcp.util.Dialogs;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

class ReadProductOperation
implements Runnable {
    private final File file;
    private final String formatName;
    private ProgressWrapper ph;

    public ReadProductOperation(File file, String formatName) {
        Assert.notNull((Object)file, (String)"file");
        Assert.notNull((Object)formatName, (String)"formatName");
        this.file = file;
        this.formatName = formatName;
        this.ph = PhWrapper.NULL;
    }

    public File getFile() {
        return this.file;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public Cancellable createCancellable(RequestProcessor.Task task) {
        return new Cancel(this, task);
    }

    public void attacheProgressHandle(ProgressHandle handle) {
        this.ph = new PhWrapper(handle);
    }

    @Override
    public void run() {
        try {
            this.ph.start();
            this.ph.switchToIndeterminate();
            Product product = ProductIO.readProduct((File)this.file, (String[])new String[]{this.formatName});
            boolean interrupted = Thread.interrupted();
            if (!interrupted) {
                if (product == null) {
                    SwingUtilities.invokeLater(() -> Dialogs.showError(Bundle.LBL_NoReaderFoundText() + String.format("%nFile '%s' can not be opened.", this.file)));
                } else {
                    OpenProductAction.getRecentProductPaths().add(this.file.getPath());
                    SwingUtilities.invokeLater(() -> SnapApp.getDefault().getProductManager().addProduct(product));
                }
            }
        }
        catch (IOException problem) {
            SwingUtilities.invokeLater(() -> Dialogs.showError(Bundle.CTL_OpenProductActionName(), problem.getMessage()));
        }
        finally {
            this.ph.finish();
        }
    }

    private static class PhWrapper
    extends ProgressWrapper {
        public static ProgressWrapper NULL = new ProgressWrapper(){};
        private final ProgressHandle handle;

        public PhWrapper(ProgressHandle handle) {
            this.handle = handle;
        }

        @Override
        void start() {
            this.handle.start();
        }

        @Override
        void switchToIndeterminate() {
            this.handle.switchToIndeterminate();
        }

        @Override
        void finish() {
            this.handle.finish();
        }
    }

    private static abstract class ProgressWrapper {
        private ProgressWrapper() {
        }

        void start() {
        }

        void switchToIndeterminate() {
        }

        void finish() {
        }
    }

    static class Cancel
    implements Cancellable {
        private final ReadProductOperation operation;
        private final RequestProcessor.Task task;

        public Cancel(ReadProductOperation operation, RequestProcessor.Task task) {
            this.operation = operation;
            this.task = task;
        }

        public boolean cancel() {
            this.task.cancel();
            this.operation.ph.finish();
            return true;
        }
    }
}

