/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import com.vividsolutions.jts.geom.Geometry;
import java.awt.Rectangle;
import java.io.File;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.ProductCustomizer;
import org.esa.snap.binning.Reprojector;
import org.esa.snap.binning.TemporalBinRenderer;
import org.esa.snap.binning.TemporalBinSource;
import org.esa.snap.binning.operator.FormatterConfig;
import org.esa.snap.binning.operator.ImageTemporalBinRenderer;
import org.esa.snap.binning.operator.ProductTemporalBinRenderer;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;

public class Formatter {
    public static void format(PlanetaryGrid planetaryGrid, TemporalBinSource temporalBinSource, String[] featureNames, FormatterConfig formatterConfig, Geometry roiGeometry, ProductData.UTC startTime, ProductData.UTC stopTime, MetadataElement ... metadataElements) throws Exception {
        if (featureNames.length == 0) {
            throw new IllegalArgumentException("Illegal binning context: featureNames.length == 0");
        }
        File outputFile = new File(formatterConfig.getOutputFile());
        String outputType = formatterConfig.getOutputType();
        String outputFormat = Formatter.getOutputFormat(formatterConfig, outputFile);
        Rectangle outputRegion = Reprojector.computeRasterSubRegion(planetaryGrid, roiGeometry);
        ProductCustomizer productCustomizer = formatterConfig.getProductCustomizer();
        TemporalBinRenderer temporalBinRenderer = outputType.equalsIgnoreCase("Product") ? new ProductTemporalBinRenderer(featureNames, outputFile, outputFormat, outputRegion, Reprojector.getRasterPixelSize(planetaryGrid), startTime, stopTime, productCustomizer, metadataElements) : new ImageTemporalBinRenderer(featureNames, outputFile, outputFormat, outputRegion, formatterConfig.getBandConfigurations(), outputType.equalsIgnoreCase("RGB"));
        Reprojector.reproject(planetaryGrid, temporalBinSource, temporalBinRenderer);
    }

    static String getOutputFormat(FormatterConfig formatterConfig, File outputFile) {
        String fileName = outputFile.getName();
        int extPos = fileName.lastIndexOf(".");
        String outputFileNameExt = fileName.substring(extPos + 1);
        String outputFormat = formatterConfig.getOutputFormat();
        if (outputFormat == null) {
            String string = outputFileNameExt.equalsIgnoreCase("nc") ? "NetCDF" : (outputFileNameExt.equalsIgnoreCase("dim") ? "BEAM-DIMAP" : (outputFileNameExt.equalsIgnoreCase("tiff") ? "GeoTIFF" : (outputFileNameExt.equalsIgnoreCase("png") ? "PNG" : (outputFormat = outputFileNameExt.equalsIgnoreCase("jpg") ? "JPEG" : null))));
        }
        if (outputFormat == null) {
            throw new IllegalArgumentException("No output format given");
        }
        if (!(outputFormat.startsWith("NetCDF") || outputFormat.equalsIgnoreCase("BEAM-DIMAP") || outputFormat.equalsIgnoreCase("GeoTIFF") || outputFormat.equalsIgnoreCase("PNG") || outputFormat.equalsIgnoreCase("JPEG"))) {
            throw new IllegalArgumentException("Unknown output format: " + outputFormat);
        }
        if (outputFormat.equalsIgnoreCase("NetCDF")) {
            outputFormat = "NetCDF-BEAM";
        }
        return outputFormat;
    }
}

