/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.unmixing;

import com.bc.ceres.core.Assert;
import org.esa.snap.core.gpf.annotations.Parameter;

public class Endmember {
    @Parameter(pattern="[a-zA-Z_0-9]*")
    private String name;
    @Parameter
    private double[] wavelengths;
    @Parameter
    private double[] radiations;

    public Endmember() {
    }

    public Endmember(String name, double[] wavelengths, double[] radiations) {
        Assert.notNull((Object)name, (String)"name");
        if (wavelengths.length != radiations.length) {
            throw new IllegalArgumentException("wavelengths.length != radiations.length");
        }
        this.name = name;
        this.wavelengths = wavelengths;
        this.radiations = radiations;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.wavelengths.length;
    }

    public double getWavelength(int i) {
        return this.wavelengths[i];
    }

    public double[] getWavelengths() {
        return (double[])this.wavelengths.clone();
    }

    public double getRadiation(int i) {
        return this.radiations[i];
    }

    public double[] getRadiations() {
        return (double[])this.radiations.clone();
    }

    public String toString() {
        return this.getName();
    }
}

