/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.launcher;

import com.bc.ceres.core.runtime.RuntimeConfig;
import com.bc.ceres.core.runtime.RuntimeConfigException;
import com.bc.ceres.core.runtime.internal.DefaultRuntimeConfig;
import com.bc.ceres.launcher.ClasspathFactory;
import com.bc.ceres.launcher.internal.BruteForceClasspathFactory;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class Launcher {
    private RuntimeConfig runtimeConfig;
    private ClasspathFactory classpathFactory;

    public static void main(String[] args) {
        try {
            Launcher launcher = Launcher.createDefaultLauncher();
            launcher.launch(args);
        }
        catch (Throwable e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public static Launcher createDefaultLauncher() throws RuntimeConfigException {
        DefaultRuntimeConfig runtimeConfig = new DefaultRuntimeConfig();
        return new Launcher(runtimeConfig, new BruteForceClasspathFactory(runtimeConfig));
    }

    public Launcher(RuntimeConfig runtimeConfig, ClasspathFactory classpathFactory) {
        this.runtimeConfig = runtimeConfig;
        this.classpathFactory = classpathFactory;
        this.trace("Configuration type: " + this.runtimeConfig.getClass().getName());
        this.trace("Classpath type:     " + this.classpathFactory.getClass().getName());
    }

    public RuntimeConfig getRuntimeConfig() {
        return this.runtimeConfig;
    }

    public ClasspathFactory getClasspathFactory() {
        return this.classpathFactory;
    }

    public ClassLoader createClassLoader() throws RuntimeConfigException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL[] defaultClasspath = this.createDefaultClasspath();
        if (defaultClasspath.length > 0) {
            classLoader = new URLClassLoader(defaultClasspath, classLoader);
        }
        URL[] mainClasspath = this.createMainClasspath();
        if (defaultClasspath.length > 0) {
            classLoader = new URLClassLoader(mainClasspath, classLoader);
        }
        this.traceClassLoader("classLoader", classLoader);
        return classLoader;
    }

    URL[] createDefaultClasspath() throws RuntimeConfigException {
        return this.classpathFactory.createClasspath();
    }

    URL[] createMainClasspath() {
        ArrayList<URL> urlList = new ArrayList<URL>(16);
        String paths = this.runtimeConfig.getMainClassPath();
        if (paths != null) {
            StringTokenizer st = new StringTokenizer(paths, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String path = st.nextToken().trim();
                try {
                    URL url = new File(path).toURI().toURL();
                    urlList.add(url);
                }
                catch (MalformedURLException e) {
                    this.trace(MessageFormat.format("Invalid classpath entry: {0}", path));
                }
            }
        }
        return urlList.toArray(new URL[urlList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(String[] args) throws Exception {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = this.createClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            Class<?> mainClass = classLoader.loadClass(this.runtimeConfig.getMainClassName());
            if (this.runtimeConfig.isUsingModuleRuntime()) {
                Method mainMethod = mainClass.getMethod("launch", RuntimeConfig.class, ClassLoader.class, String[].class);
                mainMethod.invoke(null, this.runtimeConfig, classLoader, args);
            } else {
                Method mainMethod = mainClass.getMethod("main", String[].class);
                mainMethod.invoke(null, new Object[]{args});
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    private void trace(String msg) {
        if (this.runtimeConfig.isDebug()) {
            this.runtimeConfig.getLogger().info(String.format("ceres-launcher: %s", msg));
        }
    }

    private void traceClassLoader(String name, ClassLoader classLoader) {
        this.trace("=============================================================================");
        this.trace(name + ".class = " + classLoader.getClass());
        if (classLoader instanceof URLClassLoader) {
            URL[] classpath = ((URLClassLoader)classLoader).getURLs();
            for (int i = 0; i < classpath.length; ++i) {
                this.trace(name + ".url[" + i + "] = " + classpath[i]);
            }
        }
        if (classLoader.getParent() != null) {
            this.traceClassLoader(name + ".parent", classLoader.getParent());
        } else {
            this.trace(name + ".parent = null");
        }
    }
}

